/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query {
    private final ParentChildIndexFieldData ifd;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final ScoreType scoreType;
    private Query originalChildQuery;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenQuery(ParentChildIndexFieldData ifd, String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.ifd = ifd;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.originalChildQuery = childQuery;
        this.scoreType = scoreType;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenQuery that = (ChildrenQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        return "ChildrenQuery[" + this.childType + "/" + this.parentType + "](" + this.originalChildQuery.toString(field) + ')' + ToStringUtils.boost((float)this.getBoost());
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
        }
        return this;
    }

    public Query clone() {
        ChildrenQuery q = (ChildrenQuery)super.clone();
        q.originalChildQuery = this.originalChildQuery.clone();
        if (q.rewrittenChildQuery != null) {
            q.rewrittenChildQuery = this.rewrittenChildQuery.clone();
        }
        return q;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        block13: {
            block14: {
                sc = SearchContext.current();
                if (!ChildrenQuery.$assertionsDisabled && this.rewrittenChildQuery == null) {
                    throw new AssertionError();
                }
                if (!ChildrenQuery.$assertionsDisabled && this.rewriteIndexReader != searcher.getIndexReader()) {
                    throw new AssertionError((Object)("not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader()));
                }
                childQuery = this.rewrittenChildQuery;
                globalIfd = this.ifd.getGlobalParentChild(this.parentType, searcher.getIndexReader());
                if (globalIfd == null) {
                    return Queries.newMatchNoDocsQuery().createWeight(searcher);
                }
                indexSearcher = new IndexSearcher(searcher.getIndexReader());
                indexSearcher.setSimilarity(searcher.getSimilarity());
                abort = true;
                collector = null;
                try {
                    switch (1.$SwitchMap$org$elasticsearch$index$search$child$ScoreType[this.scoreType.ordinal()]) {
                        case 1: {
                            collector = new MaxCollector(globalIfd, sc);
                            break;
                        }
                        case 2: {
                            collector = new SumCollector(globalIfd, sc);
                            break;
                        }
                        case 3: {
                            collector = new AvgCollector(globalIfd, sc);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Are we missing a score type here? -- " + (Object)this.scoreType);
                        }
                    }
                    indexSearcher.search(childQuery, (Collector)collector);
                    numFoundParents = collector.foundParents();
                    if (numFoundParents != 0L) break block13;
                    var10_9 = Queries.newMatchNoDocsQuery().createWeight(searcher);
                    if (!abort) break block14;
                }
                catch (Throwable var11_11) {
                    if (abort) {
                        Releasables.close(new Releasable[]{collector});
                    }
                    throw var11_11;
                }
                Releasables.close(new Releasable[]{collector});
            }
            return var10_9;
        }
        abort = false;
        ** if (!abort) goto lbl45
lbl-1000:
        // 1 sources

        {
            Releasables.close(new Releasable[]{collector});
        }
        {
        }
lbl45:
        // 2 sources

        sc.addReleasable(collector, SearchContext.Lifetime.COLLECTION);
        parentFilter /* !! */  = numFoundParents <= (long)this.shortCircuitParentDocSet ? ParentIdsFilter.createShortCircuitFilter(this.nonNestedDocsFilter, sc, this.parentType, collector.values, collector.parentIdxs, numFoundParents) : new ApplyAcceptedDocsFilter(this.parentFilter);
        return new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentFilter /* !! */ , numFoundParents, collector);
    }

    private static final class AvgParentScorer
    extends ParentScorer {
        private final IntArray occurrences;

        AvgParentScorer(ParentWeight weight, DocIdSetIterator parentsIterator, ParentOrdAndScoreCollector collector, Ordinals.Docs globalOrdinals) {
            super(weight, parentsIterator, collector, globalOrdinals);
            this.occurrences = ((AvgCollector)collector).occurrences;
        }

        @Override
        public int nextDoc() throws IOException {
            long parentIdx;
            long globalOrdinal;
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId != Integer.MAX_VALUE) continue;
                return this.currentDocId;
            } while ((globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId)) == -1L || (parentIdx = this.parentIds.find(globalOrdinal)) == -1L);
            this.currentScore = this.scores.get(parentIdx);
            this.currentScore /= (float)this.occurrences.get(parentIdx);
            this.parentWeight.remaining--;
            return this.currentDocId;
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            long globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId);
            if (globalOrdinal == -1L) {
                return this.nextDoc();
            }
            long parentIdx = this.parentIds.find(globalOrdinal);
            if (parentIdx != -1L) {
                this.currentScore = this.scores.get(parentIdx);
                this.currentScore /= (float)this.occurrences.get(parentIdx);
                this.parentWeight.remaining--;
                return this.currentDocId;
            }
            return this.nextDoc();
        }
    }

    private static class ParentScorer
    extends Scorer {
        final ParentWeight parentWeight;
        final LongHash parentIds;
        final FloatArray scores;
        final Ordinals.Docs globalOrdinals;
        final DocIdSetIterator parentsIterator;
        int currentDocId = -1;
        float currentScore;

        ParentScorer(ParentWeight parentWeight, DocIdSetIterator parentsIterator, ParentOrdAndScoreCollector collector, Ordinals.Docs globalOrdinals) {
            super((Weight)parentWeight);
            this.parentWeight = parentWeight;
            this.globalOrdinals = globalOrdinals;
            this.parentsIterator = parentsIterator;
            this.parentIds = collector.parentIdxs;
            this.scores = collector.scores;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentDocId;
        }

        public int nextDoc() throws IOException {
            long parentIdx;
            long globalOrdinal;
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId != Integer.MAX_VALUE) continue;
                return this.currentDocId;
            } while ((globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId)) == -1L || (parentIdx = this.parentIds.find(globalOrdinal)) == -1L);
            this.currentScore = this.scores.get(parentIdx);
            this.parentWeight.remaining--;
            return this.currentDocId;
        }

        public int advance(int target) throws IOException {
            if (this.parentWeight.remaining == 0L) {
                this.currentDocId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            long globalOrdinal = this.globalOrdinals.getOrd(this.currentDocId);
            if (globalOrdinal == -1L) {
                return this.nextDoc();
            }
            long parentIdx = this.parentIds.find(globalOrdinal);
            if (parentIdx != -1L) {
                this.currentScore = this.scores.get(parentIdx);
                this.parentWeight.remaining--;
                return this.currentDocId;
            }
            return this.nextDoc();
        }

        public long cost() {
            return this.parentsIterator.cost();
        }
    }

    private static final class AvgCollector
    extends ParentOrdAndScoreCollector {
        private IntArray occurrences;

        AvgCollector(IndexFieldData.WithOrdinals globalIfd, SearchContext searchContext) {
            super(globalIfd, searchContext);
            this.occurrences = this.bigArrays.newIntArray(512L, false);
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.globalOrdinals != null && (globalOrdinal = this.globalOrdinals.getOrd(doc)) != -1L) {
                long parentIdx = this.parentIdxs.add(globalOrdinal);
                if (parentIdx >= 0L) {
                    this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
                    this.occurrences = this.bigArrays.grow(this.occurrences, parentIdx + 1L);
                    this.scores.set(parentIdx, this.scorer.score());
                    this.occurrences.set(parentIdx, 1);
                } else {
                    parentIdx = -1L - parentIdx;
                    this.scores.increment(parentIdx, this.scorer.score());
                    this.occurrences.increment(parentIdx, 1);
                }
            }
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.scores, this.occurrences);
        }
    }

    private static final class MaxCollector
    extends ParentOrdAndScoreCollector {
        private MaxCollector(IndexFieldData.WithOrdinals globalIfd, SearchContext searchContext) {
            super(globalIfd, searchContext);
        }

        @Override
        protected void doScore(long index) throws IOException {
            float currentScore = this.scorer.score();
            if (currentScore > this.scores.get(index)) {
                this.scores.set(index, currentScore);
            }
        }
    }

    private static final class SumCollector
    extends ParentOrdAndScoreCollector {
        private SumCollector(IndexFieldData.WithOrdinals globalIfd, SearchContext searchContext) {
            super(globalIfd, searchContext);
        }

        @Override
        protected void doScore(long index) throws IOException {
            this.scores.increment(index, this.scorer.score());
        }
    }

    private static abstract class ParentOrdAndScoreCollector
    extends NoopCollector
    implements Releasable {
        private final IndexFieldData.WithOrdinals globalIfd;
        protected final LongHash parentIdxs;
        protected final BigArrays bigArrays;
        protected FloatArray scores;
        protected final SearchContext searchContext;
        protected Ordinals.Docs globalOrdinals;
        protected BytesValues.WithOrdinals values;
        protected Scorer scorer;

        private ParentOrdAndScoreCollector(IndexFieldData.WithOrdinals globalIfd, SearchContext searchContext) {
            this.globalIfd = globalIfd;
            this.bigArrays = searchContext.bigArrays();
            this.parentIdxs = new LongHash(512L, this.bigArrays);
            this.scores = this.bigArrays.newFloatArray(512L, false);
            this.searchContext = searchContext;
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrdinal;
            if (this.globalOrdinals != null && (globalOrdinal = this.globalOrdinals.getOrd(doc)) != -1L) {
                long parentIdx = this.parentIdxs.add(globalOrdinal);
                if (parentIdx >= 0L) {
                    this.scores = this.bigArrays.grow(this.scores, parentIdx + 1L);
                    this.scores.set(parentIdx, this.scorer.score());
                } else {
                    parentIdx = -1L - parentIdx;
                    this.doScore(parentIdx);
                }
            }
        }

        protected void doScore(long index) throws IOException {
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = this.globalIfd.load(context).getBytesValues(false);
            if (this.values != null) {
                this.globalOrdinals = this.values.ordinals();
            }
        }

        public long foundParents() {
            return this.parentIdxs.size();
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.parentIdxs, this.scores);
        }
    }

    private final class ParentWeight
    extends Weight {
        private final Weight childWeight;
        private final Filter parentFilter;
        private final ParentOrdAndScoreCollector collector;
        private long remaining;

        private ParentWeight(Weight childWeight, Filter parentFilter, long remaining, ParentOrdAndScoreCollector collector) {
            this.childWeight = childWeight;
            this.parentFilter = parentFilter;
            this.remaining = remaining;
            this.collector = collector;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.childWeight.getValueForNormalization();
            return sum *= ChildrenQuery.this.getBoost() * ChildrenQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSet parentsSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(parentsSet) || this.remaining == 0L) {
                return null;
            }
            DocIdSetIterator parents = BitsFilteredDocIdSet.wrap((DocIdSet)parentsSet, (Bits)context.reader().getLiveDocs()).iterator();
            BytesValues.WithOrdinals bytesValues = this.collector.globalIfd.load(context).getBytesValues(false);
            if (bytesValues == null) {
                return null;
            }
            switch (ChildrenQuery.this.scoreType) {
                case AVG: {
                    return new AvgParentScorer(this, parents, this.collector, bytesValues.ordinals());
                }
            }
            return new ParentScorer(this, parents, this.collector, bytesValues.ordinals());
        }
    }
}

