/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.morelikethis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.get.GetField;

public class MoreLikeThisFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public MoreLikeThisFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public List<LikeText> fetch(List<MultiGetRequest.Item> items) throws IOException {
        MultiGetRequest request = new MultiGetRequest();
        for (MultiGetRequest.Item item : items) {
            request.add(item);
        }
        MultiGetResponse responses = this.client.multiGet(request).actionGet();
        ArrayList<LikeText> likeTexts = new ArrayList<LikeText>();
        for (MultiGetItemResponse response : responses) {
            GetResponse getResponse;
            if (response.isFailed() || !(getResponse = response.getResponse()).isExists()) continue;
            for (GetField getField : getResponse.getFields().values()) {
                for (Object value : getField.getValues()) {
                    likeTexts.add(new LikeText(getField.getName(), value.toString()));
                }
            }
        }
        return likeTexts;
    }

    public static final class LikeText {
        public final String field;
        public final String text;

        public LikeText(String field, String text) {
            this.field = field;
            this.text = text;
        }
    }
}

