/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.store.fs.MmapFsIndexStoreModule;
import org.elasticsearch.index.store.fs.NioFsIndexStoreModule;
import org.elasticsearch.index.store.fs.SimpleFsIndexStoreModule;
import org.elasticsearch.index.store.ram.RamIndexStoreModule;

public class IndexStoreModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public IndexStoreModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        Class indexStoreModule = NioFsIndexStoreModule.class;
        if ((Constants.WINDOWS || Constants.SUN_OS || Constants.LINUX) && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            indexStoreModule = MmapFsIndexStoreModule.class;
        } else if (Constants.WINDOWS) {
            indexStoreModule = SimpleFsIndexStoreModule.class;
        }
        String storeType = this.settings.get("index.store.type");
        if ("ram".equalsIgnoreCase(storeType)) {
            indexStoreModule = RamIndexStoreModule.class;
        } else if ("memory".equalsIgnoreCase(storeType)) {
            indexStoreModule = RamIndexStoreModule.class;
        } else if (!"fs".equalsIgnoreCase(storeType)) {
            if ("simplefs".equalsIgnoreCase(storeType) || "simple_fs".equals(storeType)) {
                indexStoreModule = SimpleFsIndexStoreModule.class;
            } else if ("niofs".equalsIgnoreCase(storeType) || "nio_fs".equalsIgnoreCase(storeType)) {
                indexStoreModule = NioFsIndexStoreModule.class;
            } else if ("mmapfs".equalsIgnoreCase(storeType) || "mmap_fs".equalsIgnoreCase(storeType)) {
                indexStoreModule = MmapFsIndexStoreModule.class;
            } else if (storeType != null) {
                indexStoreModule = this.settings.getAsClass("index.store.type", indexStoreModule, "org.elasticsearch.index.store.", "IndexStoreModule");
            }
        }
        return ImmutableList.of(Modules.createModule(indexStoreModule, this.settings));
    }

    @Override
    protected void configure() {
    }
}

