/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginInfo;
import org.elasticsearch.action.admin.cluster.node.info.PluginsInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.plugins.Plugin;

public class PluginsService
extends AbstractComponent {
    public static final String ES_PLUGIN_PROPERTIES = "es-plugin.properties";
    private final Environment environment;
    private final ImmutableList<Tuple<PluginInfo, Plugin>> plugins;
    private final ImmutableMap<Plugin, List<OnModuleReference>> onModuleReferences;
    private PluginsInfo cachedPluginsInfo;
    private final TimeValue refreshInterval;
    private final boolean checkLucene;
    private long lastRefresh;

    public PluginsService(Settings settings, Environment environment) {
        super(settings);
        String[] defaultPluginsClasses;
        this.environment = environment;
        this.checkLucene = this.componentSettings.getAsBoolean("check_lucene", (Boolean)true);
        ImmutableList.Builder tupleBuilder = ImmutableList.builder();
        for (String string : defaultPluginsClasses = settings.getAsArray("plugin.types")) {
            Plugin plugin = this.loadPlugin(string, settings);
            PluginInfo pluginInfo = new PluginInfo(plugin.name(), plugin.description(), this.hasSite(plugin.name()), true, "NA");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("plugin loaded from settings [{}]", pluginInfo);
            }
            tupleBuilder.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
        }
        this.loadPluginsIntoClassLoader();
        tupleBuilder.addAll(this.loadPluginsFromClasspath(settings));
        this.plugins = tupleBuilder.build();
        HashMap jvmPlugins = Maps.newHashMap();
        ArrayList<String> sitePlugins = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            jvmPlugins.put(((Plugin)tuple.v2()).name(), tuple.v2());
            if (!((PluginInfo)tuple.v1()).isSite()) continue;
            sitePlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        ImmutableList<Tuple<PluginInfo, Plugin>> tuples = this.loadSitePlugins();
        for (Tuple tuple : tuples) {
            sitePlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        String[] stringArray = settings.getAsArray("plugin.mandatory", null);
        if (stringArray != null) {
            HashSet<String> hashSet = Sets.newHashSet();
            for (String mandatoryPlugin : stringArray) {
                if (jvmPlugins.containsKey(mandatoryPlugin) || sitePlugins.contains(mandatoryPlugin) || hashSet.contains(mandatoryPlugin)) continue;
                hashSet.add(mandatoryPlugin);
            }
            if (!hashSet.isEmpty()) {
                throw new ElasticsearchException("Missing mandatory plugins [" + Strings.collectionToDelimitedString(hashSet, ", ") + "]");
            }
        }
        this.logger.info("loaded {}, sites {}", jvmPlugins.keySet(), sitePlugins);
        MapBuilder mapBuilder = MapBuilder.newMapBuilder();
        for (Plugin plugin : jvmPlugins.values()) {
            ArrayList<OnModuleReference> list = Lists.newArrayList();
            for (Method method : plugin.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("onModule")) continue;
                if (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1) {
                    this.logger.warn("Plugin: {} implementing onModule with no parameters or more than one parameter", plugin.name());
                    continue;
                }
                Class<?> moduleClass = method.getParameterTypes()[0];
                if (!Module.class.isAssignableFrom(moduleClass)) {
                    this.logger.warn("Plugin: {} implementing onModule by the type is not of Module type {}", plugin.name(), moduleClass);
                    continue;
                }
                method.setAccessible(true);
                list.add(new OnModuleReference(moduleClass, method));
            }
            if (list.isEmpty()) continue;
            mapBuilder.put(plugin, list);
        }
        this.onModuleReferences = mapBuilder.immutableMap();
        this.refreshInterval = this.componentSettings.getAsTime("info_refresh_interval", TimeValue.timeValueSeconds(10L));
    }

    public ImmutableList<Tuple<PluginInfo, Plugin>> plugins() {
        return this.plugins;
    }

    public void processModules(Iterable<Module> modules) {
        for (Module module : modules) {
            this.processModule(module);
        }
    }

    public void processModule(Module module) {
        for (Tuple tuple : this.plugins()) {
            ((Plugin)tuple.v2()).processModule(module);
            List<OnModuleReference> references = this.onModuleReferences.get(tuple.v2());
            if (references == null) continue;
            for (OnModuleReference reference : references) {
                if (!reference.moduleClass.isAssignableFrom(module.getClass())) continue;
                try {
                    reference.onModuleMethod.invoke(tuple.v2(), module);
                }
                catch (Exception e) {
                    this.logger.warn("plugin {}, failed to invoke custom onModule method", e, ((Plugin)tuple.v2()).name());
                }
            }
        }
    }

    public Settings updatedSettings() {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(this.settings);
        for (Tuple tuple : this.plugins) {
            builder.put(((Plugin)tuple.v2()).additionalSettings());
        }
        return builder.build();
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).modules());
        }
        return modules;
    }

    public Collection<Module> modules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).modules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList<Class<? extends LifecycleComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).services());
        }
        return services;
    }

    public Collection<Class<? extends Module>> indexModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).indexModules());
        }
        return modules;
    }

    public Collection<Module> indexModules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).indexModules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> indexServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).indexServices());
        }
        return services;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).shardModules());
        }
        return modules;
    }

    public Collection<Module> shardModules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).shardModules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> shardServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).shardServices());
        }
        return services;
    }

    public synchronized PluginsInfo info() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedPluginsInfo != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve plugins info", new Object[0]);
                }
                return this.cachedPluginsInfo;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("starting to fetch info on plugins", new Object[0]);
        }
        this.cachedPluginsInfo = new PluginsInfo();
        for (Tuple tuple : this.plugins) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("adding jvm plugin [{}]", tuple.v1());
            }
            this.cachedPluginsInfo.add((PluginInfo)tuple.v1());
        }
        for (Tuple tuple : this.loadSitePlugins()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("adding site plugin [{}]", tuple.v1());
            }
            this.cachedPluginsInfo.add((PluginInfo)tuple.v1());
        }
        return this.cachedPluginsInfo;
    }

    private void loadPluginsIntoClassLoader() {
        File pluginsDirectory = this.environment.pluginsFile();
        if (!FileSystemUtils.isAccessibleDirectory(pluginsDirectory, this.logger)) {
            return;
        }
        ClassLoader classLoader = this.settings.getClassLoader();
        Class<?> classLoaderClass = classLoader.getClass();
        Method addURL = null;
        while (!classLoaderClass.equals(Object.class)) {
            try {
                addURL = classLoaderClass.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException e) {
                classLoaderClass = classLoaderClass.getSuperclass();
            }
        }
        if (addURL == null) {
            this.logger.debug("failed to find addURL method on classLoader [" + classLoader + "] to add methods", new Object[0]);
            return;
        }
        for (File plugin : pluginsDirectory.listFiles()) {
            if (!FileSystemUtils.isAccessibleDirectory(plugin, this.logger)) continue;
            this.logger.trace("--- adding plugin [{}]", plugin.getAbsolutePath());
            try {
                File libLocation;
                addURL.invoke((Object)classLoader, plugin.toURI().toURL());
                ArrayList<File> libFiles = Lists.newArrayList();
                if (plugin.listFiles() != null) {
                    libFiles.addAll(Arrays.asList(plugin.listFiles()));
                }
                if ((libLocation = new File(plugin, "lib")).exists() && libLocation.isDirectory() && libLocation.listFiles() != null) {
                    libFiles.addAll(Arrays.asList(libLocation.listFiles()));
                }
                for (File libFile : libFiles) {
                    if (!libFile.getName().endsWith(".jar") && !libFile.getName().endsWith(".zip")) continue;
                    addURL.invoke((Object)classLoader, libFile.toURI().toURL());
                }
            }
            catch (Throwable e) {
                this.logger.warn("failed to add plugin [" + plugin + "]", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImmutableList<Tuple<PluginInfo, Plugin>> loadPluginsFromClasspath(Settings settings) {
        ImmutableList.Builder plugins = ImmutableList.builder();
        try {
            Enumeration<URL> pluginUrls = settings.getClassLoader().getResources(ES_PLUGIN_PROPERTIES);
            while (pluginUrls.hasMoreElements()) {
                URL pluginUrl = pluginUrls.nextElement();
                Properties pluginProps = new Properties();
                InputStream is = null;
                try {
                    is = pluginUrl.openStream();
                    pluginProps.load(is);
                    String pluginClassName = pluginProps.getProperty("plugin");
                    String pluginVersion = pluginProps.getProperty("version", "NA");
                    Plugin plugin = this.loadPlugin(pluginClassName, settings);
                    File siteFile = new File(new File(this.environment.pluginsFile(), plugin.name()), "_site");
                    boolean isSite = FileSystemUtils.isAccessibleDirectory(siteFile, this.logger);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("found a jvm plugin [{}], [{}]{}", plugin.name(), plugin.description(), isSite ? ": with _site structure" : "");
                    }
                    PluginInfo pluginInfo = new PluginInfo(plugin.name(), plugin.description(), isSite, true, pluginVersion);
                    plugins.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
                }
                catch (Throwable e) {
                    try {
                        this.logger.warn("failed to load plugin from [" + pluginUrl + "]", e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                        throw throwable;
                        return plugins.build();
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    continue;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            }
        }
        catch (IOException e) {
            this.logger.warn("failed to find jvm plugins from classpath", e, new Object[0]);
        }
        return plugins.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<Tuple<PluginInfo, Plugin>> loadSitePlugins() {
        ImmutableList.Builder sitePlugins = ImmutableList.builder();
        ArrayList<String> loadedJvmPlugins = new ArrayList<String>();
        for (Tuple tuple : this.plugins) {
            if (!((PluginInfo)tuple.v1()).isSite()) continue;
            loadedJvmPlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return sitePlugins.build();
        }
        for (File pluginFile : pluginsFile.listFiles()) {
            File sitePluginDir;
            if (loadedJvmPlugins.contains(pluginFile.getName()) || !FileSystemUtils.isAccessibleDirectory(sitePluginDir = new File(pluginFile, "_site"), this.logger)) continue;
            String name = pluginFile.getName();
            String version = "NA";
            String description = "No description found.";
            File pluginPropFile = new File(sitePluginDir, ES_PLUGIN_PROPERTIES);
            if (pluginPropFile.exists()) {
                Properties pluginProps = new Properties();
                FileInputStream is = null;
                try {
                    is = new FileInputStream(pluginPropFile.getAbsolutePath());
                    pluginProps.load(is);
                    description = pluginProps.getProperty("description", "No description found.");
                    version = pluginProps.getProperty("version", "NA");
                }
                catch (Exception e) {
                    try {
                        this.logger.debug("can not load {} file.", e, ES_PLUGIN_PROPERTIES);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("found a site plugin name [{}], version [{}], description [{}]", name, version, description);
            }
            sitePlugins.add(new Tuple<PluginInfo, Object>(new PluginInfo(name, description, true, false, version), null));
        }
        return sitePlugins.build();
    }

    private boolean hasSite(String name) {
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return false;
        }
        File sitePluginDir = new File(pluginsFile, name + "/_site");
        return FileSystemUtils.isAccessibleDirectory(sitePluginDir, this.logger);
    }

    private Plugin loadPlugin(String className, Settings settings) {
        try {
            Plugin plugin;
            Class<?> pluginClass = settings.getClassLoader().loadClass(className);
            if (!this.checkLucene || PluginsService.checkLuceneCompatibility(pluginClass, settings, this.logger)) {
                try {
                    plugin = (Plugin)pluginClass.getConstructor(Settings.class).newInstance(settings);
                }
                catch (NoSuchMethodException e) {
                    try {
                        plugin = (Plugin)pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        throw new ElasticsearchException("No constructor for [" + pluginClass + "]. A plugin class must " + "have either an empty default constructor or a single argument constructor accepting a " + "Settings instance");
                    }
                }
            } else {
                throw new ElasticsearchException("Plugin is incompatible with the current node");
            }
            return plugin;
        }
        catch (Throwable e) {
            throw new ElasticsearchException("Failed to load plugin class [" + className + "]", e);
        }
    }

    public static boolean checkLuceneCompatibility(Class<? extends Plugin> pluginClass, Settings settings, ESLogger logger) {
        String luceneVersion;
        block19: {
            luceneVersion = null;
            try {
                Enumeration<URL> pluginUrls = settings.getClassLoader().getResources(ES_PLUGIN_PROPERTIES);
                while (pluginUrls.hasMoreElements()) {
                    URL pluginUrl = pluginUrls.nextElement();
                    InputStream is = pluginUrl.openStream();
                    Throwable throwable = null;
                    try {
                        Properties pluginProps = new Properties();
                        pluginProps.load(is);
                        String plugin = pluginProps.getProperty("plugin");
                        if (pluginClass.getName().equals(plugin)) {
                            luceneVersion = pluginProps.getProperty("lucene");
                            break;
                        }
                        logger.debug("skipping [{}]", pluginUrl);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                if (luceneVersion != null) {
                    String[] parts = luceneVersion.split("\\.");
                    org.apache.lucene.util.Version luceneExpectedVersion = org.apache.lucene.util.Version.parseLeniently((String)(parts[0] + "." + parts[1]));
                    if (Version.CURRENT.luceneVersion.equals((Object)luceneExpectedVersion)) {
                        logger.debug("starting analysis plugin for Lucene [{}].", luceneExpectedVersion);
                        return true;
                    }
                    break block19;
                }
                logger.debug("lucene property is not set in plugin {} file. Skipping test.", ES_PLUGIN_PROPERTIES);
                return true;
            }
            catch (Throwable t) {
                logger.debug("exception raised while checking plugin Lucene version.", t, new Object[0]);
            }
        }
        logger.error("cannot start plugin due to incorrect Lucene version: plugin [{}], node [{}].", luceneVersion, Constants.LUCENE_MAIN_VERSION);
        return false;
    }

    static class OnModuleReference {
        public final Class<? extends Module> moduleClass;
        public final Method onModuleMethod;

        OnModuleReference(Class<? extends Module> moduleClass, Method onModuleMethod) {
            this.moduleClass = moduleClass;
            this.onModuleMethod = onModuleMethod;
        }
    }
}

