/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.get;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;

public class RestHeadAction
extends BaseRestHandler {
    @Inject
    public RestHeadAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.listenerThreaded(false);
        getRequest.operationThreaded(true);
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", null));
        getRequest.fields(Strings.EMPTY_ARRAY);
        this.client.get(getRequest, (ActionListener<GetResponse>)new RestResponseListener<GetResponse>(channel){

            @Override
            public RestResponse buildResponse(GetResponse response) {
                if (!response.isExists()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND);
                }
                return new BytesRestResponse(RestStatus.OK);
            }
        });
    }
}

