/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class BucketsAggregator
extends Aggregator {
    private LongArray docCounts;

    public BucketsAggregator(String name, Aggregator.BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        super(name, bucketAggregationMode, factories, estimatedBucketsCount, context, parent);
        this.docCounts = this.bigArrays.newLongArray(estimatedBucketsCount, true);
    }

    protected final long maxBucketOrd() {
        return this.docCounts.size();
    }

    protected final void collectBucket(int doc, long bucketOrd) throws IOException {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.collectExistingBucket(doc, bucketOrd);
    }

    protected final void collectExistingBucket(int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, 1L);
        this.collectBucketNoCounts(doc, bucketOrd);
    }

    public LongArray getDocCounts() {
        return this.docCounts;
    }

    protected final void collectBucketNoCounts(int doc, long bucketOrd) throws IOException {
        this.collectableSugAggregators.collect(doc, bucketOrd);
    }

    protected final void incrementBucketDocCount(long inc, long bucketOrd) throws IOException {
        this.docCounts = this.bigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final long bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0L;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected final InternalAggregations bucketAggregations(long bucketOrd) {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        long bucketDocCount = this.bucketDocCount(bucketOrd);
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = bucketDocCount == 0L ? this.subAggregators[i].buildEmptyAggregation() : this.subAggregators[i].buildAggregation(bucketOrd);
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    protected final InternalAggregations bucketEmptyAggregations() {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = this.subAggregators[i].buildEmptyAggregation();
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    @Override
    public final void close() {
        try (LongArray releasable = this.docCounts;){
            super.close();
        }
    }
}

