/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.InternalGlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ValuesSource.Bytes.WithOrdinals.FieldData valuesSource;
    protected final IncludeExclude includeExclude;
    protected BytesValues.WithOrdinals globalValues;
    protected Ordinals.Docs globalOrdinals;
    protected LongBitSet acceptedGlobalOrdinals;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent) {
        super(name, factories, maxOrd, aggregationContext, parent, order, bucketCountThresholds);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.globalValues = this.valuesSource.globalBytesValues();
        this.globalOrdinals = this.globalValues.ordinals();
        if (this.acceptedGlobalOrdinals != null) {
            this.globalOrdinals = new FilteredOrdinals(this.globalOrdinals, this.acceptedGlobalOrdinals);
        } else if (this.includeExclude != null) {
            this.acceptedGlobalOrdinals = this.includeExclude.acceptedGlobalOrdinals(this.globalOrdinals, this.valuesSource);
            this.globalOrdinals = new FilteredOrdinals(this.globalOrdinals, this.acceptedGlobalOrdinals);
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        int numOrds = this.globalOrdinals.setDocument(doc);
        for (int i = 0; i < numOrds; ++i) {
            long globalOrd = this.globalOrdinals.nextOrd();
            this.collectExistingBucket(doc, globalOrd);
        }
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize((int)from.length, (int)1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.globalOrdinals == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalOrdinals.getMaxOrd(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        StringTerms.Bucket spare = null;
        for (long globalTermOrd = 0L; globalTermOrd < this.globalOrdinals.getMaxOrd(); ++globalTermOrd) {
            long bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            long l = bucketDocCount = bucketOrd < 0L ? 0L : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0L) continue;
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null);
            }
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            GlobalOrdinalsStringTermsAggregator.copy(this.globalValues.getValueByOrd(globalTermOrd), spare.termBytes);
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount) continue;
            spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            bucket.aggregations = bucket.docCount == 0L ? this.bucketEmptyAggregations() : this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list));
    }

    private static final class FilteredOrdinals
    implements Ordinals.Docs {
        private final Ordinals.Docs inner;
        private final LongBitSet accepted;
        private long currentOrd;
        private long[] buffer = new long[0];
        private int bufferSlot;

        private FilteredOrdinals(Ordinals.Docs inner, LongBitSet accepted) {
            this.inner = inner;
            this.accepted = accepted;
        }

        @Override
        public long getMaxOrd() {
            return this.inner.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return this.inner.isMultiValued();
        }

        @Override
        public long getOrd(int docId) {
            long ord = this.inner.getOrd(docId);
            if (this.accepted.get(ord)) {
                this.currentOrd = ord;
                return this.currentOrd;
            }
            this.currentOrd = -1L;
            return -1L;
        }

        @Override
        public long nextOrd() {
            this.currentOrd = this.buffer[this.bufferSlot++];
            return this.currentOrd;
        }

        @Override
        public int setDocument(int docId) {
            int numDocs = this.inner.setDocument(docId);
            this.buffer = ArrayUtil.grow((long[])this.buffer, (int)numDocs);
            this.bufferSlot = 0;
            int numAcceptedOrds = 0;
            for (int slot = 0; slot < numDocs; ++slot) {
                long ord = this.inner.nextOrd();
                if (!this.accepted.get(ord)) continue;
                this.buffer[numAcceptedOrds] = ord;
                ++numAcceptedOrds;
            }
            return numAcceptedOrds;
        }

        @Override
        public long currentOrd() {
            return this.currentOrd;
        }
    }

    public static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private final LongArray segmentDocCounts;
        private Ordinals.Docs segmentOrdinals;
        private LongArray current;

        public LowCardinality(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent) {
            super(name, factories, valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, null, aggregationContext, parent);
            this.segmentDocCounts = this.bigArrays.newLongArray(maxOrd, true);
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            int numOrds = this.segmentOrdinals.setDocument(doc);
            for (int i = 0; i < numOrds; ++i) {
                long segmentOrd = this.segmentOrdinals.nextOrd();
                this.current.increment(segmentOrd, 1L);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            if (this.segmentOrdinals != null && this.segmentOrdinals.getMaxOrd() != this.globalOrdinals.getMaxOrd()) {
                this.mapSegmentCountsToGlobalCounts();
            }
            this.globalValues = this.valuesSource.globalBytesValues();
            this.globalOrdinals = this.globalValues.ordinals();
            BytesValues.WithOrdinals bytesValues = this.valuesSource.bytesValues();
            this.segmentOrdinals = bytesValues.ordinals();
            this.current = this.segmentOrdinals.getMaxOrd() != this.globalOrdinals.getMaxOrd() ? this.segmentDocCounts : this.getDocCounts();
        }

        @Override
        protected void doPostCollection() {
            if (this.segmentOrdinals.getMaxOrd() != this.globalOrdinals.getMaxOrd()) {
                this.mapSegmentCountsToGlobalCounts();
            }
        }

        @Override
        protected void doClose() {
            Releasables.close(this.segmentDocCounts);
        }

        private void mapSegmentCountsToGlobalCounts() {
            InternalGlobalOrdinalsBuilder.GlobalOrdinalMapping mapping = (InternalGlobalOrdinalsBuilder.GlobalOrdinalMapping)this.globalOrdinals;
            int i = 0;
            while ((long)i < this.segmentDocCounts.size()) {
                long inc = this.segmentDocCounts.set(i, 0L);
                if (inc != 0L) {
                    long globalOrd = mapping.getGlobalOrd(i);
                    try {
                        this.incrementBucketDocCount(inc, globalOrd);
                    }
                    catch (IOException e) {
                        throw ExceptionsHelper.convertToElastic(e);
                    }
                }
                ++i;
            }
        }
    }

    public static class WithHash
    extends GlobalOrdinalsStringTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent) {
            super(name, factories, valuesSource, estimatedBucketCount, estimatedBucketCount, order, bucketCountThresholds, includeExclude, aggregationContext, parent);
            this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            int numOrds = this.globalOrdinals.setDocument(doc);
            for (int i = 0; i < numOrds; ++i) {
                long globalOrd = this.globalOrdinals.nextOrd();
                long bucketOrd = this.bucketOrds.add(globalOrd);
                if (bucketOrd < 0L) {
                    bucketOrd = -1L - bucketOrd;
                    this.collectExistingBucket(doc, bucketOrd);
                    continue;
                }
                this.collectBucket(doc, bucketOrd);
            }
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.bucketOrds);
        }
    }
}

