/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.min;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class MinAggregator
extends MetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private DoubleValues values;
    private DoubleArray mins;

    public MinAggregator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.mins = this.bigArrays.newDoubleArray(initialSize, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        if (this.values.setDocument(doc) == 0) {
            return;
        }
        if (owningBucketOrdinal >= this.mins.size()) {
            long from = this.mins.size();
            this.mins = this.bigArrays.grow(this.mins, owningBucketOrdinal + 1L);
            this.mins.fill(from, this.mins.size(), Double.POSITIVE_INFINITY);
        }
        this.mins.set(owningBucketOrdinal, Math.min(this.values.nextValue(), this.mins.get(owningBucketOrdinal)));
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? Double.POSITIVE_INFINITY : this.mins.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalMin(this.name, Double.POSITIVE_INFINITY);
        }
        assert (owningBucketOrdinal < this.mins.size());
        return new InternalMin(this.name, this.mins.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMin(this.name, Double.POSITIVE_INFINITY);
    }

    @Override
    public void doClose() {
        Releasables.close(this.mins);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, InternalMin.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new MinAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new MinAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

