/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class ValueCountAggregator
extends MetricsAggregator.SingleValue {
    private final ValuesSource valuesSource;
    private BytesValues values;
    LongArray counts;

    public ValueCountAggregator(String name, long expectedBucketsCount, ValuesSource valuesSource, AggregationContext aggregationContext, Aggregator parent) {
        super(name, 0L, aggregationContext, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = expectedBucketsCount < 2L ? 1L : expectedBucketsCount;
            this.counts = this.bigArrays.newLongArray(initialSize, true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.bytesValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.counts = this.bigArrays.grow(this.counts, owningBucketOrdinal + 1L);
        this.counts.increment(owningBucketOrdinal, this.values.setDocument(doc));
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalValueCount(this.name, 0L);
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalValueCount(this.name, this.counts.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts);
    }

    public static class Factory<VS extends ValuesSource>
    extends ValuesSourceAggregatorFactory.LeafOnly<VS> {
        public Factory(String name, ValuesSourceConfig<VS> config) {
            super(name, InternalValueCount.TYPE.name(), config);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new ValueCountAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new ValueCountAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

