/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.common.lucene.TopReaderContextAware;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class AggregationContext
implements ReaderContextAware,
ScorerAware {
    private final SearchContext searchContext;
    private ObjectObjectOpenHashMap<ConfigCacheKey, ValuesSource>[] perDepthFieldDataSources = new ObjectObjectOpenHashMap[4];
    private List<ReaderContextAware> readerAwares = new ArrayList<ReaderContextAware>();
    private List<TopReaderContextAware> topReaderAwares = new ArrayList<TopReaderContextAware>();
    private List<ScorerAware> scorerAwares = new ArrayList<ScorerAware>();
    private AtomicReaderContext reader;
    private Scorer scorer;
    private boolean scoreDocsInOrder = false;

    public AggregationContext(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public SearchContext searchContext() {
        return this.searchContext;
    }

    public PageCacheRecycler pageCacheRecycler() {
        return this.searchContext.pageCacheRecycler();
    }

    public BigArrays bigArrays() {
        return this.searchContext.bigArrays();
    }

    public AtomicReaderContext currentReader() {
        return this.reader;
    }

    public Scorer currentScorer() {
        return this.scorer;
    }

    public void setNextReader(IndexReaderContext reader) {
        for (TopReaderContextAware topReaderAware : this.topReaderAwares) {
            topReaderAware.setNextReader(reader);
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.reader = reader;
        for (ReaderContextAware aware : this.readerAwares) {
            aware.setNextReader(reader);
        }
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
        for (ScorerAware scorerAware : this.scorerAwares) {
            scorerAware.setScorer(scorer);
        }
    }

    public boolean scoreDocsInOrder() {
        return this.scoreDocsInOrder;
    }

    public void ensureScoreDocsInOrder() {
        this.scoreDocsInOrder = true;
    }

    public <VS extends ValuesSource> VS valuesSource(ValuesSourceConfig<VS> config, int depth) {
        assert (config.valid()) : "value source config is invalid - must have either a field context or a script or marked as unmapped";
        assert (!config.unmapped) : "value source should not be created for unmapped fields";
        if (this.perDepthFieldDataSources.length <= depth) {
            this.perDepthFieldDataSources = Arrays.copyOf(this.perDepthFieldDataSources, ArrayUtil.oversize((int)(1 + depth), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        if (this.perDepthFieldDataSources[depth] == null) {
            this.perDepthFieldDataSources[depth] = new ObjectObjectOpenHashMap();
        }
        ObjectObjectOpenHashMap<ConfigCacheKey, ValuesSource> fieldDataSources = this.perDepthFieldDataSources[depth];
        if (config.fieldContext == null) {
            if (ValuesSource.Numeric.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.numericScript(config);
            }
            if (ValuesSource.Bytes.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.bytesScript(config);
            }
            throw new AggregationExecutionException("value source of type [" + config.valueSourceType.getSimpleName() + "] is not supported by scripts");
        }
        if (ValuesSource.Numeric.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.numericField(fieldDataSources, config);
        }
        if (ValuesSource.GeoPoint.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.geoPointField(fieldDataSources, config);
        }
        return (VS)this.bytesField(fieldDataSources, config);
    }

    private ValuesSource.Numeric numericScript(ValuesSourceConfig<?> config) {
        this.setScorerIfNeeded(config.script);
        this.setReaderIfNeeded(config.script);
        this.scorerAwares.add(config.script);
        this.readerAwares.add(config.script);
        ValuesSource.Numeric source = new ValuesSource.Numeric.Script(config.script, config.scriptValueType);
        if (config.ensureUnique || config.ensureSorted) {
            source = new ValuesSource.Numeric.SortedAndUnique(source);
            this.readerAwares.add((ReaderContextAware)((Object)source));
        }
        return source;
    }

    private ValuesSource.Numeric numericField(ObjectObjectOpenHashMap<ConfigCacheKey, ValuesSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        ValuesSource.Numeric dataSource = (ValuesSource.Numeric)fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            ValuesSource.MetaData metaData = ValuesSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)config.fieldContext.indexFieldData(), metaData);
            this.setReaderIfNeeded((ReaderContextAware)((Object)dataSource));
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.script != null) {
            this.setScorerIfNeeded(config.script);
            this.setReaderIfNeeded(config.script);
            this.scorerAwares.add(config.script);
            this.readerAwares.add(config.script);
            dataSource = new ValuesSource.Numeric.WithScript(dataSource, config.script);
            if (config.ensureUnique || config.ensureSorted) {
                dataSource = new ValuesSource.Numeric.SortedAndUnique(dataSource);
                this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            }
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        return dataSource;
    }

    private ValuesSource bytesField(ObjectObjectOpenHashMap<ConfigCacheKey, ValuesSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        ValuesSource dataSource = fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            IndexFieldData<?> indexFieldData = config.fieldContext.indexFieldData();
            ValuesSource.MetaData metaData = ValuesSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = indexFieldData instanceof IndexFieldData.WithOrdinals ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexFieldData.WithOrdinals)indexFieldData, metaData) : new ValuesSource.Bytes.FieldData(indexFieldData, metaData);
            this.setReaderIfNeeded((ReaderContextAware)((Object)dataSource));
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            if (dataSource instanceof TopReaderContextAware) {
                this.topReaderAwares.add((TopReaderContextAware)((Object)dataSource));
            }
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.script != null) {
            this.setScorerIfNeeded(config.script);
            this.setReaderIfNeeded(config.script);
            this.scorerAwares.add(config.script);
            this.readerAwares.add(config.script);
            dataSource = new ValuesSource.WithScript(dataSource, config.script);
        }
        if (config.ensureUnique && !dataSource.metaData().uniqueness().unique() || config.ensureSorted) {
            dataSource = new ValuesSource.Bytes.SortedAndUnique(dataSource);
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        return dataSource;
    }

    private ValuesSource.Bytes bytesScript(ValuesSourceConfig<?> config) {
        this.setScorerIfNeeded(config.script);
        this.setReaderIfNeeded(config.script);
        this.scorerAwares.add(config.script);
        this.readerAwares.add(config.script);
        ValuesSource.Bytes source = new ValuesSource.Bytes.Script(config.script);
        if (config.ensureUnique || config.ensureSorted) {
            source = new ValuesSource.Bytes.SortedAndUnique(source);
            this.readerAwares.add((ReaderContextAware)((Object)source));
        }
        return source;
    }

    private ValuesSource.GeoPoint geoPointField(ObjectObjectOpenHashMap<ConfigCacheKey, ValuesSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        ValuesSource.GeoPoint dataSource = (ValuesSource.GeoPoint)fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            ValuesSource.MetaData metaData = ValuesSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = new ValuesSource.GeoPoint((IndexGeoPointFieldData)config.fieldContext.indexFieldData(), metaData);
            this.setReaderIfNeeded(dataSource);
            this.readerAwares.add(dataSource);
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        return dataSource;
    }

    public void registerReaderContextAware(ReaderContextAware readerContextAware) {
        this.setReaderIfNeeded(readerContextAware);
        this.readerAwares.add(readerContextAware);
    }

    public void registerScorerAware(ScorerAware scorerAware) {
        this.setScorerIfNeeded(scorerAware);
        this.scorerAwares.add(scorerAware);
    }

    private void setReaderIfNeeded(ReaderContextAware readerAware) {
        if (this.reader != null) {
            readerAware.setNextReader(this.reader);
        }
    }

    private void setScorerIfNeeded(ScorerAware scorerAware) {
        if (this.scorer != null) {
            scorerAware.setScorer(this.scorer);
        }
    }

    private static class ConfigCacheKey {
        private final String field;
        private final Class<? extends ValuesSource> valueSourceType;

        private ConfigCacheKey(ValuesSourceConfig config) {
            this.field = config.fieldContext.field();
            this.valueSourceType = config.valueSourceType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigCacheKey that = (ConfigCacheKey)o;
            if (!this.field.equals(that.field)) {
                return false;
            }
            return this.valueSourceType.equals(that.valueSourceType);
        }

        public int hashCode() {
            int result = this.field.hashCode();
            result = 31 * result + this.valueSourceType.hashCode();
            return result;
        }
    }
}

