/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptTermsStringFieldFacetExecutor
extends FacetExecutor {
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int shardSize;
    private final SearchScript script;
    private final Matcher matcher;
    private final ImmutableSet<BytesRef> excluded;
    private final int numberOfShards;
    final Recycler.V<ObjectIntOpenHashMap<BytesRef>> facets;
    long missing;
    long total;

    public ScriptTermsStringFieldFacetExecutor(int size, int shardSize, TermsFacet.ComparatorType comparatorType, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, String scriptLang, String script, Map<String, Object> params, CacheRecycler cacheRecycler) {
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
        this.excluded = excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.facets = cacheRecycler.objectIntMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector(this.matcher, this.excluded, this.script, this.facets.v());
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        if (this.facets.v().isEmpty()) {
            this.facets.close();
            return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, ImmutableList.of(), this.missing, this.total);
        }
        boolean[] states = this.facets.v().allocated;
        KType[] keys = this.facets.v().keys;
        int[] values = this.facets.v().values;
        if (this.shardSize < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.shardSize, this.comparatorType.comparator());
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                BytesRef key = (BytesRef)keys[i];
                ordered.insertWithOverflow(new InternalStringTermsFacet.TermEntry(key, values[i]));
            }
            InternalStringTermsFacet.TermEntry[] list = new InternalStringTermsFacet.TermEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalStringTermsFacet.TermEntry)ordered.pop();
            }
            this.facets.close();
            return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.shardSize);
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            BytesRef key = (BytesRef)keys[i];
            ordered.add(new InternalStringTermsFacet.TermEntry(key, values[i]));
        }
        this.facets.close();
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }

    class Collector
    extends FacetExecutor.Collector {
        private final Matcher matcher;
        private final ImmutableSet<BytesRef> excluded;
        private final SearchScript script;
        private final ObjectIntOpenHashMap<BytesRef> facets;
        long missing;
        long total;

        Collector(Matcher matcher, ImmutableSet<BytesRef> excluded, SearchScript script, ObjectIntOpenHashMap<BytesRef> facets) {
            this.matcher = matcher;
            this.excluded = excluded;
            this.script = script;
            this.facets = facets;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.script.setScorer(scorer);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.script.setNextReader(context);
        }

        public void collect(int doc) throws IOException {
            this.script.setNextDocId(doc);
            Object o = this.script.run();
            if (o == null) {
                ++this.missing;
                return;
            }
            if (o instanceof Iterable) {
                boolean found = false;
                for (Object o1 : (Iterable)o) {
                    String value = o1.toString();
                    if (!this.match(value)) continue;
                    found = true;
                    this.facets.addTo(new BytesRef((CharSequence)value), 1);
                    ++this.total;
                }
                if (!found) {
                    ++this.missing;
                }
            } else if (o instanceof Object[]) {
                boolean found = false;
                for (Object o1 : (Object[])o) {
                    String value = o1.toString();
                    if (!this.match(value)) continue;
                    found = true;
                    this.facets.addTo(new BytesRef((CharSequence)value), 1);
                    ++this.total;
                }
                if (!found) {
                    ++this.missing;
                }
            } else {
                String value = o.toString();
                if (this.match(value)) {
                    this.facets.addTo(new BytesRef((CharSequence)value), 1);
                    ++this.total;
                } else {
                    ++this.missing;
                }
            }
        }

        @Override
        public void postCollection() {
            ScriptTermsStringFieldFacetExecutor.this.missing = this.missing;
            ScriptTermsStringFieldFacetExecutor.this.total = this.total;
        }

        private boolean match(String value) {
            if (this.excluded != null && this.excluded.contains(new BytesRef((CharSequence)value))) {
                return false;
            }
            return this.matcher == null || this.matcher.reset(value).matches();
        }
    }
}

