/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.strings.HashedAggregator;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.strings.InternalTermsStatsStringFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsStringFacetExecutor
extends FacetExecutor {
    private final TermsStatsFacet.ComparatorType comparatorType;
    final IndexFieldData keyIndexFieldData;
    final IndexNumericFieldData valueIndexFieldData;
    final SearchScript script;
    private final int size;
    private final int shardSize;
    final Recycler.V<ObjectObjectOpenHashMap<HashedBytesRef, InternalTermsStatsStringFacet.StringEntry>> entries;
    long missing;

    public TermsStatsStringFacetExecutor(IndexFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, SearchScript valueScript, int size, int shardSize, TermsStatsFacet.ComparatorType comparatorType, SearchContext context) {
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.script = valueScript;
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.entries = context.cacheRecycler().hashMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalTermsStatsStringFacet.StringEntry value;
        if (this.entries.v().isEmpty()) {
            this.entries.close();
            return new InternalTermsStatsStringFacet(facetName, this.comparatorType, this.size, ImmutableList.of(), this.missing);
        }
        if (this.size == 0) {
            ArrayList<InternalTermsStatsStringFacet.StringEntry> stringEntries = new ArrayList<InternalTermsStatsStringFacet.StringEntry>();
            boolean[] states = this.entries.v().allocated;
            VType[] values = this.entries.v().values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                stringEntries.add((InternalTermsStatsStringFacet.StringEntry)values[i]);
            }
            return new InternalTermsStatsStringFacet(facetName, this.comparatorType, 0, stringEntries, this.missing);
        }
        VType[] values = this.entries.v().values;
        Arrays.sort(values, this.comparatorType.comparator());
        ArrayList<InternalTermsStatsStringFacet.StringEntry> ordered = Lists.newArrayList();
        int limit = this.shardSize;
        for (int i = 0; i < limit && (value = (InternalTermsStatsStringFacet.StringEntry)values[i]) != null; ++i) {
            ordered.add(value);
        }
        this.entries.close();
        return new InternalTermsStatsStringFacet(facetName, this.comparatorType, this.size, ordered, this.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(ObjectObjectOpenHashMap<HashedBytesRef, InternalTermsStatsStringFacet.StringEntry> entries, SearchScript script) {
            super(entries);
            this.script = script;
        }

        @Override
        public void onValue(int docId, BytesRef value, int hashCode, BytesValues values) {
            this.spare.reset(value, hashCode);
            InternalTermsStatsStringFacet.StringEntry stringEntry = (InternalTermsStatsStringFacet.StringEntry)this.entries.get(this.spare);
            if (stringEntry == null) {
                HashedBytesRef theValue = new HashedBytesRef(values.copyShared(), hashCode);
                stringEntry = new InternalTermsStatsStringFacet.StringEntry(theValue, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(theValue, stringEntry);
            } else {
                ++stringEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < stringEntry.min) {
                stringEntry.min = valueValue;
            }
            if (valueValue > stringEntry.max) {
                stringEntry.max = valueValue;
            }
            stringEntry.total += valueValue;
            ++stringEntry.totalCount;
        }
    }

    public static class Aggregator
    extends HashedAggregator {
        final ObjectObjectOpenHashMap<HashedBytesRef, InternalTermsStatsStringFacet.StringEntry> entries;
        final HashedBytesRef spare = new HashedBytesRef();
        int missing = 0;
        DoubleValues valueValues;
        ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(ObjectObjectOpenHashMap<HashedBytesRef, InternalTermsStatsStringFacet.StringEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, BytesRef value, int hashCode, BytesValues values) {
            this.spare.reset(value, hashCode);
            InternalTermsStatsStringFacet.StringEntry stringEntry = this.entries.get(this.spare);
            if (stringEntry == null) {
                HashedBytesRef theValue = new HashedBytesRef(values.copyShared(), hashCode);
                stringEntry = new InternalTermsStatsStringFacet.StringEntry(theValue, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(theValue, stringEntry);
            }
            ++stringEntry.count;
            this.valueAggregator.stringEntry = stringEntry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalTermsStatsStringFacet.StringEntry stringEntry;

            @Override
            public void onValue(int docId, double value) {
                if (value < this.stringEntry.min) {
                    this.stringEntry.min = value;
                }
                if (value > this.stringEntry.max) {
                    this.stringEntry.max = value;
                }
                this.stringEntry.total += value;
                ++this.stringEntry.totalCount;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final Aggregator aggregator;
        private BytesValues keyValues;

        public Collector() {
            this.aggregator = TermsStatsStringFacetExecutor.this.script != null ? new ScriptAggregator(TermsStatsStringFacetExecutor.this.entries.v(), TermsStatsStringFacetExecutor.this.script) : new Aggregator(TermsStatsStringFacetExecutor.this.entries.v());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsStatsStringFacetExecutor.this.script != null) {
                TermsStatsStringFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = TermsStatsStringFacetExecutor.this.keyIndexFieldData.load(context).getBytesValues(true);
            if (TermsStatsStringFacetExecutor.this.script != null) {
                TermsStatsStringFacetExecutor.this.script.setNextReader(context);
            } else {
                this.aggregator.valueValues = TermsStatsStringFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
            TermsStatsStringFacetExecutor.this.missing = this.aggregator.missing;
            this.aggregator.release();
        }
    }
}

