/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedqueries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedQueriesFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return !context.parsedQuery().namedFilters().isEmpty() || context.parsedPostFilter() != null && !context.parsedPostFilter().namedFilters().isEmpty();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        ArrayList<String> matchedQueries = Lists.newArrayListWithCapacity(2);
        this.addMatchedQueries(hitContext, context.parsedQuery().namedFilters(), matchedQueries);
        if (context.parsedPostFilter() != null) {
            this.addMatchedQueries(hitContext, context.parsedPostFilter().namedFilters(), matchedQueries);
        }
        hitContext.hit().matchedQueries(matchedQueries.toArray(new String[matchedQueries.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMatchedQueries(FetchSubPhase.HitContext hitContext, ImmutableMap<String, Filter> namedFiltersAndQueries, List<String> matchedQueries) {
        for (Map.Entry entry : namedFiltersAndQueries.entrySet()) {
            String name = (String)entry.getKey();
            Filter filter = (Filter)entry.getValue();
            try {
                DocIdSet docIdSet = filter.getDocIdSet(hitContext.readerContext(), null);
                if (DocIdSets.isEmpty(docIdSet)) continue;
                Bits bits = docIdSet.bits();
                if (bits != null) {
                    if (!bits.get(hitContext.docId())) continue;
                    matchedQueries.add(name);
                    continue;
                }
                DocIdSetIterator iterator = docIdSet.iterator();
                if (iterator == null || iterator.advance(hitContext.docId()) != hitContext.docId()) continue;
                matchedQueries.add(name);
            }
            catch (IOException e) {}
            continue;
            finally {
                SearchContext.current().clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
        }
    }
}

