/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.XAnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.XFuzzySuggester;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.PayloadProcessor;
import org.elasticsearch.search.suggest.context.ContextMapping;

public class AnalyzingCompletionLookupProvider
extends Completion090PostingsFormat.CompletionLookupProvider {
    public static final int SERIALIZE_PRESERVE_SEPERATORS = 1;
    public static final int SERIALIZE_HAS_PAYLOADS = 2;
    public static final int SERIALIZE_PRESERVE_POSITION_INCREMENTS = 4;
    private static final int MAX_SURFACE_FORMS_PER_ANALYZED_FORM = 256;
    private static final int MAX_GRAPH_EXPANSIONS = -1;
    public static final String CODEC_NAME = "analyzing";
    public static final int CODEC_VERSION_START = 1;
    public static final int CODEC_VERSION_SERIALIZED_LABELS = 2;
    public static final int CODEC_VERSION_CHECKSUMS = 3;
    public static final int CODEC_VERSION_LATEST = 3;
    private boolean preserveSep;
    private boolean preservePositionIncrements;
    private int maxSurfaceFormsPerAnalyzedForm;
    private int maxGraphExpansions;
    private boolean hasPayloads;
    private final XAnalyzingSuggester prototype;

    public AnalyzingCompletionLookupProvider(boolean preserveSep, boolean exactFirst, boolean preservePositionIncrements, boolean hasPayloads) {
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.hasPayloads = hasPayloads;
        this.maxSurfaceFormsPerAnalyzedForm = 256;
        this.maxGraphExpansions = -1;
        int options = preserveSep ? 2 : 0;
        this.prototype = new XAnalyzingSuggester(null, null, null, options, this.maxSurfaceFormsPerAnalyzedForm, this.maxGraphExpansions, preservePositionIncrements, null, false, 1, 31, 31, 0, 30);
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public FieldsConsumer consumer(final IndexOutput output) throws IOException {
        CodecUtil.writeHeader((DataOutput)output, (String)CODEC_NAME, (int)3);
        return new FieldsConsumer(){
            private Map<FieldInfo, Long> fieldOffsets = new HashMap<FieldInfo, Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    long pointer = output.getFilePointer();
                    output.writeVInt(this.fieldOffsets.size());
                    for (Map.Entry<FieldInfo, Long> entry : this.fieldOffsets.entrySet()) {
                        output.writeString(entry.getKey().name);
                        output.writeVLong(entry.getValue().longValue());
                    }
                    output.writeLong(pointer);
                    CodecUtil.writeFooter((IndexOutput)output);
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{output});
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{output});
            }

            public TermsConsumer addField(final FieldInfo field) throws IOException {
                return new TermsConsumer(){
                    final XAnalyzingSuggester.XBuilder builder;
                    final CompletionPostingsConsumer postingsConsumer;
                    {
                        this.builder = new XAnalyzingSuggester.XBuilder(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm, AnalyzingCompletionLookupProvider.this.hasPayloads, 31);
                        this.postingsConsumer = new CompletionPostingsConsumer(AnalyzingCompletionLookupProvider.this, this.builder);
                    }

                    public PostingsConsumer startTerm(BytesRef text) throws IOException {
                        this.builder.startTerm(text);
                        return this.postingsConsumer;
                    }

                    public Comparator<BytesRef> getComparator() throws IOException {
                        return BytesRef.getUTF8SortedAsUnicodeComparator();
                    }

                    public void finishTerm(BytesRef text, TermStats stats) throws IOException {
                        this.builder.finishTerm(stats.docFreq);
                    }

                    public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
                        FST<PairOutputs.Pair<Long, BytesRef>> build = this.builder.build();
                        assert (build != null || docCount == 0) : "the FST is null but docCount is != 0 actual value: [" + docCount + "]";
                        if (build != null) {
                            fieldOffsets.put(field, output.getFilePointer());
                            build.save((DataOutput)output);
                            output.writeVInt(this.postingsConsumer.getMaxAnalyzedPathsForOneInput());
                            output.writeVInt(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm);
                            output.writeInt(AnalyzingCompletionLookupProvider.this.maxGraphExpansions);
                            int options = 0;
                            options |= AnalyzingCompletionLookupProvider.this.preserveSep ? 1 : 0;
                            options |= AnalyzingCompletionLookupProvider.this.hasPayloads ? 2 : 0;
                            output.writeVInt(options |= AnalyzingCompletionLookupProvider.this.preservePositionIncrements ? 4 : 0);
                            output.writeVInt(31);
                            output.writeVInt(0);
                            output.writeVInt(31);
                            output.writeVInt(30);
                        }
                    }
                };
            }
        };
    }

    @Override
    public Completion090PostingsFormat.LookupFactory load(IndexInput input) throws IOException {
        long sizeInBytes = 0L;
        int version = CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)1, (int)3);
        if (version >= 3) {
            CodecUtil.checksumEntireFile((IndexInput)input);
        }
        long metaPointerPosition = input.length() - (long)(version >= 3 ? 8 + CodecUtil.footerLength() : 8);
        final HashMap lookupMap = new HashMap();
        input.seek(metaPointerPosition);
        long metaPointer = input.readLong();
        input.seek(metaPointer);
        int numFields = input.readVInt();
        TreeMap<Long, String> meta = new TreeMap<Long, String>();
        for (int i = 0; i < numFields; ++i) {
            String name = input.readString();
            long offset = input.readVLong();
            meta.put(offset, name);
        }
        for (Map.Entry entry : meta.entrySet()) {
            int holeCharacter;
            int endByte;
            int payloadSep;
            int sepLabel;
            input.seek(((Long)entry.getKey()).longValue());
            FST fst = new FST((DataInput)input, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
            int maxAnalyzedPathsForOneInput = input.readVInt();
            int maxSurfaceFormsPerAnalyzedForm = input.readVInt();
            int maxGraphExpansions = input.readInt();
            int options = input.readVInt();
            boolean preserveSep = (options & 1) != 0;
            boolean hasPayloads = (options & 2) != 0;
            boolean preservePositionIncrements = (options & 4) != 0;
            switch (version) {
                case 1: {
                    sepLabel = 255;
                    payloadSep = 31;
                    endByte = 0;
                    holeCharacter = 30;
                    break;
                }
                default: {
                    sepLabel = input.readVInt();
                    endByte = input.readVInt();
                    payloadSep = input.readVInt();
                    holeCharacter = input.readVInt();
                }
            }
            AnalyzingSuggestHolder holder = new AnalyzingSuggestHolder(preserveSep, preservePositionIncrements, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, hasPayloads, maxAnalyzedPathsForOneInput, (FST<PairOutputs.Pair<Long, BytesRef>>)fst, sepLabel, payloadSep, endByte, holeCharacter);
            sizeInBytes += fst.sizeInBytes();
            lookupMap.put(entry.getValue(), holder);
        }
        final long ramBytesUsed = sizeInBytes;
        return new Completion090PostingsFormat.LookupFactory(){

            @Override
            public Lookup getLookup(CompletionFieldMapper mapper, CompletionSuggestionContext suggestionContext) {
                AnalyzingSuggestHolder analyzingSuggestHolder = (AnalyzingSuggestHolder)lookupMap.get(mapper.names().indexName());
                if (analyzingSuggestHolder == null) {
                    return null;
                }
                int flags = analyzingSuggestHolder.getPreserveSeparator() ? 2 : 0;
                Automaton queryPrefix = mapper.requiresContext() ? ContextMapping.ContextQuery.toAutomaton(analyzingSuggestHolder.getPreserveSeparator(), suggestionContext.getContextQueries()) : null;
                XAnalyzingSuggester suggester = suggestionContext.isFuzzy() ? new XFuzzySuggester(mapper.indexAnalyzer(), queryPrefix, mapper.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, suggestionContext.getFuzzyEditDistance(), suggestionContext.isFuzzyTranspositions(), suggestionContext.getFuzzyPrefixLength(), suggestionContext.getFuzzyMinLength(), suggestionContext.isFuzzyUnicodeAware(), analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter) : new XAnalyzingSuggester(mapper.indexAnalyzer(), queryPrefix, mapper.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, analyzingSuggestHolder.preservePositionIncrements, analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter);
                return suggester;
            }

            @Override
            public CompletionStats stats(String ... fields) {
                long sizeInBytes = 0L;
                ObjectLongOpenHashMap<String> completionFields = null;
                if (fields != null && fields.length > 0) {
                    completionFields = new ObjectLongOpenHashMap<String>(fields.length);
                }
                for (Map.Entry entry : lookupMap.entrySet()) {
                    sizeInBytes += ((AnalyzingSuggestHolder)entry.getValue()).fst.sizeInBytes();
                    if (fields == null || fields.length == 0) continue;
                    for (String field : fields) {
                        if (!Regex.simpleMatch(field, (String)entry.getKey())) continue;
                        long fstSize = ((AnalyzingSuggestHolder)entry.getValue()).fst.sizeInBytes();
                        completionFields.addTo(field, fstSize);
                    }
                }
                return new CompletionStats(sizeInBytes, completionFields);
            }

            @Override
            AnalyzingSuggestHolder getAnalyzingSuggestHolder(CompletionFieldMapper mapper) {
                return (AnalyzingSuggestHolder)lookupMap.get(mapper.names().indexName());
            }

            @Override
            public long ramBytesUsed() {
                return ramBytesUsed;
            }
        };
    }

    @Override
    public Set<IntsRef> toFiniteStrings(TokenStream stream) throws IOException {
        return this.prototype.toFiniteStrings(this.prototype.getTokenStreamToAutomaton(), stream);
    }

    static class AnalyzingSuggestHolder {
        final boolean preserveSep;
        final boolean preservePositionIncrements;
        final int maxSurfaceFormsPerAnalyzedForm;
        final int maxGraphExpansions;
        final boolean hasPayloads;
        final int maxAnalyzedPathsForOneInput;
        final FST<PairOutputs.Pair<Long, BytesRef>> fst;
        final int sepLabel;
        final int payloadSep;
        final int endByte;
        final int holeCharacter;

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst) {
            this(preserveSep, preservePositionIncrements, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, hasPayloads, maxAnalyzedPathsForOneInput, fst, 31, 31, 0, 30);
        }

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
            this.preserveSep = preserveSep;
            this.preservePositionIncrements = preservePositionIncrements;
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.maxGraphExpansions = maxGraphExpansions;
            this.hasPayloads = hasPayloads;
            this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
            this.fst = fst;
            this.sepLabel = sepLabel;
            this.payloadSep = payloadSep;
            this.endByte = endByte;
            this.holeCharacter = holeCharacter;
        }

        public boolean getPreserveSeparator() {
            return this.preserveSep;
        }

        public boolean getPreservePositionIncrements() {
            return this.preservePositionIncrements;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }
    }

    private static final class CompletionPostingsConsumer
    extends PostingsConsumer {
        private final PayloadProcessor.SuggestPayload spare = new PayloadProcessor.SuggestPayload();
        private AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider;
        private XAnalyzingSuggester.XBuilder builder;
        private int maxAnalyzedPathsForOneInput = 0;

        public CompletionPostingsConsumer(AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider, XAnalyzingSuggester.XBuilder builder) {
            this.analyzingSuggestLookupProvider = analyzingSuggestLookupProvider;
            this.builder = builder;
        }

        public void startDoc(int docID, int freq) throws IOException {
        }

        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            this.analyzingSuggestLookupProvider.parsePayload(payload, this.spare);
            this.builder.addSurface(this.spare.surfaceForm, this.spare.payload, this.spare.weight);
            this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, position + 1);
        }

        public void finishDoc() throws IOException {
        }

        public int getMaxAnalyzedPathsForOneInput() {
            return this.maxAnalyzedPathsForOneInput;
        }
    }
}

