/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.search.suggest.completion.AnalyzingCompletionLookupProvider;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.CompletionTokenStream;
import org.elasticsearch.search.suggest.completion.PayloadProcessor;

public class Completion090PostingsFormat
extends PostingsFormat {
    public static final String CODEC_NAME = "completion090";
    public static final int SUGGEST_CODEC_VERSION = 1;
    public static final int SUGGEST_VERSION_CURRENT = 1;
    public static final String EXTENSION = "cmp";
    private static final ESLogger logger = Loggers.getLogger(Completion090PostingsFormat.class);
    private PostingsFormat delegatePostingsFormat;
    private static final Map<String, CompletionLookupProvider> providers;
    private CompletionLookupProvider writeProvider;

    public Completion090PostingsFormat(PostingsFormat delegatePostingsFormat, CompletionLookupProvider provider) {
        super(CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.writeProvider = provider;
        assert (delegatePostingsFormat != null && this.writeProvider != null);
    }

    public Completion090PostingsFormat() {
        super(CODEC_NAME);
    }

    public CompletionFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        assert (this.writeProvider != null);
        return new CompletionFieldsConsumer(state);
    }

    public CompletionFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(state);
    }

    public CompletionStats completionStats(IndexReader indexReader, String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        for (AtomicReaderContext atomicReaderContext : indexReader.leaves()) {
            AtomicReader atomicReader = atomicReaderContext.reader();
            try {
                for (String fieldName : atomicReader.fields()) {
                    Terms terms = atomicReader.fields().terms(fieldName);
                    if (!(terms instanceof CompletionTerms)) continue;
                    CompletionTerms completionTerms = (CompletionTerms)terms;
                    completionStats.add(completionTerms.stats(fields));
                }
            }
            catch (IOException e) {
                logger.error("Could not get completion stats: {}", e, e.getMessage());
            }
        }
        return completionStats;
    }

    static {
        AnalyzingCompletionLookupProvider provider = new AnalyzingCompletionLookupProvider(true, false, true, false);
        ImmutableMap.Builder<String, AnalyzingCompletionLookupProvider> builder = ImmutableMap.builder();
        providers = builder.put(((CompletionLookupProvider)provider).getName(), provider).build();
    }

    public static abstract class LookupFactory {
        public abstract Lookup getLookup(CompletionFieldMapper var1, CompletionSuggestionContext var2);

        public abstract CompletionStats stats(String ... var1);

        abstract AnalyzingCompletionLookupProvider.AnalyzingSuggestHolder getAnalyzingSuggestHolder(CompletionFieldMapper var1);

        public abstract long ramBytesUsed();
    }

    public static abstract class CompletionLookupProvider
    implements PayloadProcessor,
    CompletionTokenStream.ToFiniteStrings {
        public static final char UNIT_SEPARATOR = '\u001f';

        public abstract FieldsConsumer consumer(IndexOutput var1) throws IOException;

        public abstract String getName();

        public abstract LookupFactory load(IndexInput var1) throws IOException;

        @Override
        public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
            if (weight < -1L || weight > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("weight must be >= -1 && <= Integer.MAX_VALUE");
            }
            for (int i = 0; i < surfaceForm.length; ++i) {
                if (surfaceForm.bytes[i] != 31) continue;
                throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamDataOutput output = new OutputStreamDataOutput((OutputStream)byteArrayOutputStream);
            output.writeVLong(weight + 1L);
            output.writeVInt(surfaceForm.length);
            output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
            output.writeVInt(payload.length);
            output.writeBytes(payload.bytes, 0, payload.length);
            output.close();
            return new BytesRef(byteArrayOutputStream.toByteArray());
        }

        @Override
        public void parsePayload(BytesRef payload, PayloadProcessor.SuggestPayload ref) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payload.bytes, payload.offset, payload.length);
            InputStreamDataInput input = new InputStreamDataInput((InputStream)byteArrayInputStream);
            ref.weight = input.readVLong() - 1L;
            int len = input.readVInt();
            ref.surfaceForm.grow(len);
            ref.surfaceForm.length = len;
            input.readBytes(ref.surfaceForm.bytes, ref.surfaceForm.offset, ref.surfaceForm.length);
            len = input.readVInt();
            ref.payload.grow(len);
            ref.payload.length = len;
            input.readBytes(ref.payload.bytes, ref.payload.offset, ref.payload.length);
            input.close();
        }
    }

    public static final class CompletionTerms
    extends FilterAtomicReader.FilterTerms {
        private final LookupFactory lookup;

        public CompletionTerms(Terms delegate, LookupFactory lookup) {
            super(delegate);
            this.lookup = lookup;
        }

        public Lookup getLookup(CompletionFieldMapper mapper, CompletionSuggestionContext suggestionContext) {
            return this.lookup.getLookup(mapper, suggestionContext);
        }

        public CompletionStats stats(String ... fields) {
            return this.lookup.stats(fields);
        }
    }

    private static class CompletionFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer delegateProducer;
        private final LookupFactory lookupFactory;
        private final int version;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletionFieldsProducer(SegmentReadState state) throws IOException {
            block6: {
                IndexInput input;
                block5: {
                    String suggestFSTFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)Completion090PostingsFormat.EXTENSION);
                    input = state.directory.openInput(suggestFSTFile, state.context);
                    this.version = CodecUtil.checkHeader((DataInput)input, (String)Completion090PostingsFormat.CODEC_NAME, (int)1, (int)1);
                    FieldsProducer delegateProducer = null;
                    boolean success = false;
                    try {
                        PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)input.readString());
                        String providerName = input.readString();
                        CompletionLookupProvider completionLookupProvider = (CompletionLookupProvider)providers.get(providerName);
                        if (completionLookupProvider == null) {
                            throw new ElasticsearchIllegalStateException("no provider with name [" + providerName + "] registered");
                        }
                        delegateProducer = delegatePostingsFormat.fieldsProducer(state);
                        this.lookupFactory = state.context.context != IOContext.Context.MERGE ? completionLookupProvider.load(input) : null;
                        this.delegateProducer = delegateProducer;
                        success = true;
                        if (success) break block5;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{delegateProducer, input});
                        } else {
                            IOUtils.close((Closeable[])new Closeable[]{input});
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{delegateProducer, input});
                    break block6;
                }
                IOUtils.close((Closeable[])new Closeable[]{input});
            }
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.delegateProducer});
        }

        public Iterator<String> iterator() {
            return this.delegateProducer.iterator();
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.delegateProducer.terms(field);
            if (terms == null || this.lookupFactory == null) {
                return terms;
            }
            return new CompletionTerms(terms, this.lookupFactory);
        }

        public int size() {
            return this.delegateProducer.size();
        }

        public long ramBytesUsed() {
            return (this.lookupFactory == null ? 0L : this.lookupFactory.ramBytesUsed()) + this.delegateProducer.ramBytesUsed();
        }

        public void checkIntegrity() throws IOException {
            this.delegateProducer.checkIntegrity();
        }
    }

    private class GroupedPostingsConsumer
    extends PostingsConsumer {
        private TermsConsumer[] termsConsumers;
        private PostingsConsumer[] postingsConsumers;

        public GroupedPostingsConsumer(TermsConsumer ... termsConsumersArgs) {
            this.termsConsumers = termsConsumersArgs;
            this.postingsConsumers = new PostingsConsumer[termsConsumersArgs.length];
        }

        public void startDoc(int docID, int freq) throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.startDoc(docID, freq);
            }
        }

        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.addPosition(position, payload, startOffset, endOffset);
            }
        }

        public void finishDoc() throws IOException {
            for (PostingsConsumer postingsConsumer : this.postingsConsumers) {
                postingsConsumer.finishDoc();
            }
        }

        public void startTerm(BytesRef text) throws IOException {
            for (int i = 0; i < this.termsConsumers.length; ++i) {
                this.postingsConsumers[i] = this.termsConsumers[i].startTerm(text);
            }
        }
    }

    private class CompletionFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegatesFieldsConsumer;
        private FieldsConsumer suggestFieldsConsumer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CompletionFieldsConsumer(SegmentWriteState state) throws IOException {
            this.delegatesFieldsConsumer = Completion090PostingsFormat.this.delegatePostingsFormat.fieldsConsumer(state);
            String suggestFSTFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)Completion090PostingsFormat.EXTENSION);
            IndexOutput output = null;
            boolean success = false;
            try {
                output = state.directory.createOutput(suggestFSTFile, state.context);
                CodecUtil.writeHeader((DataOutput)output, (String)Completion090PostingsFormat.CODEC_NAME, (int)1);
                output.writeString(Completion090PostingsFormat.this.delegatePostingsFormat.getName());
                output.writeString(Completion090PostingsFormat.this.writeProvider.getName());
                this.suggestFieldsConsumer = Completion090PostingsFormat.this.writeProvider.consumer(output);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                throw throwable;
            }
        }

        public TermsConsumer addField(FieldInfo field) throws IOException {
            final TermsConsumer delegateConsumer = this.delegatesFieldsConsumer.addField(field);
            final TermsConsumer suggestTermConsumer = this.suggestFieldsConsumer.addField(field);
            final GroupedPostingsConsumer groupedPostingsConsumer = new GroupedPostingsConsumer(delegateConsumer, suggestTermConsumer);
            return new TermsConsumer(){

                public PostingsConsumer startTerm(BytesRef text) throws IOException {
                    groupedPostingsConsumer.startTerm(text);
                    return groupedPostingsConsumer;
                }

                public Comparator<BytesRef> getComparator() throws IOException {
                    return delegateConsumer.getComparator();
                }

                public void finishTerm(BytesRef text, TermStats stats) throws IOException {
                    suggestTermConsumer.finishTerm(text, stats);
                    delegateConsumer.finishTerm(text, stats);
                }

                public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
                    suggestTermConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
                    delegateConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
                }
            };
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.delegatesFieldsConsumer, this.suggestFieldsConsumer});
        }
    }
}

