/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.netty.NettyStaticSetup;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.ReleaseChannelFutureListener;
import org.elasticsearch.common.netty.bootstrap.ClientBootstrap;
import org.elasticsearch.common.netty.bootstrap.ServerBootstrap;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.CompositeChannelBuffer;
import org.elasticsearch.common.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioWorkerPool;
import org.elasticsearch.common.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.elasticsearch.common.netty.util.HashedWheelTimer;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.netty.NettyHeader;
import org.elasticsearch.transport.netty.SizeHeaderFrameDecoder;
import org.elasticsearch.transport.support.TransportStatus;

public class NettyTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    private final NetworkService networkService;
    final Version version;
    final int workerCount;
    final int bossCount;
    final boolean blockingServer;
    final boolean blockingClient;
    final String port;
    final String bindHost;
    final String publishHost;
    final int publishPort;
    final boolean compress;
    final TimeValue connectTimeout;
    final Boolean tcpNoDelay;
    final Boolean tcpKeepAlive;
    final Boolean reuseAddress;
    final ByteSizeValue tcpSendBufferSize;
    final ByteSizeValue tcpReceiveBufferSize;
    final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    final int connectionsPerNodeRecovery;
    final int connectionsPerNodeBulk;
    final int connectionsPerNodeReg;
    final int connectionsPerNodeState;
    final int connectionsPerNodePing;
    final ByteSizeValue maxCumulationBufferCapacity;
    final int maxCompositeBufferComponents;
    final BigArrays bigArrays;
    private final ThreadPool threadPool;
    private volatile OpenChannelsHandler serverOpenChannels;
    private volatile ClientBootstrap clientBootstrap;
    private volatile ServerBootstrap serverBootstrap;
    final ConcurrentMap<DiscoveryNode, NodeChannels> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private volatile Channel serverChannel;
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private final KeyedLock<String> connectionLock = new KeyedLock();
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();

    @Inject
    public NettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version) {
        super(settings);
        this.threadPool = threadPool;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.version = version;
        if (settings.getAsBoolean("netty.epollBugWorkaround", (Boolean)false).booleanValue()) {
            System.setProperty("org.elasticsearch.common.netty.epollBugWorkaround", "true");
        }
        this.workerCount = this.componentSettings.getAsInt("worker_count", (Integer)(EsExecutors.boundedNumberOfProcessors(settings) * 2));
        this.bossCount = this.componentSettings.getAsInt("boss_count", (Integer)1);
        this.blockingServer = settings.getAsBoolean("transport.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.blockingClient = settings.getAsBoolean("transport.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.port = this.componentSettings.get("port", settings.get("transport.tcp.port", "9300-9400"));
        this.bindHost = this.componentSettings.get("bind_host", settings.get("transport.bind_host", settings.get("transport.host")));
        this.publishHost = this.componentSettings.get("publish_host", settings.get("transport.publish_host", settings.get("transport.host")));
        this.publishPort = this.componentSettings.getAsInt("publish_port", settings.getAsInt("transport.publish_port", (Integer)0));
        this.compress = settings.getAsBoolean("transport.tcp.compress", (Boolean)false);
        this.connectTimeout = this.componentSettings.getAsTime("connect_timeout", settings.getAsTime("transport.tcp.connect_timeout", settings.getAsTime("network.tcp.connect_timeout", NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT)));
        this.tcpNoDelay = this.componentSettings.getAsBoolean("tcp_no_delay", settings.getAsBoolean("network.tcp.no_delay", (Boolean)true));
        this.tcpKeepAlive = this.componentSettings.getAsBoolean("tcp_keep_alive", settings.getAsBoolean("network.tcp.keep_alive", (Boolean)true));
        this.reuseAddress = this.componentSettings.getAsBoolean("reuse_address", settings.getAsBoolean("network.tcp.reuse_address", NetworkUtils.defaultReuseAddress()));
        this.tcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        this.tcpReceiveBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE));
        this.connectionsPerNodeRecovery = this.componentSettings.getAsInt("connections_per_node.recovery", settings.getAsInt("transport.connections_per_node.recovery", (Integer)2));
        this.connectionsPerNodeBulk = this.componentSettings.getAsInt("connections_per_node.bulk", settings.getAsInt("transport.connections_per_node.bulk", (Integer)3));
        this.connectionsPerNodeReg = this.componentSettings.getAsInt("connections_per_node.reg", settings.getAsInt("transport.connections_per_node.reg", (Integer)6));
        this.connectionsPerNodeState = this.componentSettings.getAsInt("connections_per_node.high", settings.getAsInt("transport.connections_per_node.state", (Integer)1));
        this.connectionsPerNodePing = this.componentSettings.getAsInt("connections_per_node.ping", settings.getAsInt("transport.connections_per_node.ping", (Integer)1));
        if (this.connectionsPerNodeReg == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.reg] to 0");
        }
        if (this.connectionsPerNodePing == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.ping] to 0");
        }
        if (this.connectionsPerNodeState == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.state] to 0");
        }
        this.maxCumulationBufferCapacity = this.componentSettings.getAsBytesSize("max_cumulation_buffer_capacity", null);
        this.maxCompositeBufferComponents = this.componentSettings.getAsInt("max_composite_buffer_components", (Integer)-1);
        long defaultReceiverPredictor = 524288L;
        if (JvmInfo.jvmInfo().mem().directMemoryMax().bytes() > 0L) {
            long l = (long)(0.3 * (double)JvmInfo.jvmInfo().mem().directMemoryMax().bytes() / (double)this.workerCount);
            defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
        }
        ByteSizeValue receivePredictorMin = this.componentSettings.getAsBytesSize("receive_predictor_min", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        ByteSizeValue receivePredictorMax = this.componentSettings.getAsBytesSize("receive_predictor_max", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receiveBufferSizePredictorFactory = receivePredictorMax.bytes() == receivePredictorMin.bytes() ? new FixedReceiveBufferSizePredictorFactory((int)receivePredictorMax.bytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)receivePredictorMin.bytes(), (int)receivePredictorMin.bytes(), (int)receivePredictorMax.bytes());
        this.logger.debug("using worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", this.workerCount, this.port, this.bindHost, this.publishHost, this.compress, this.connectTimeout, this.connectionsPerNodeRecovery, this.connectionsPerNodeBulk, this.connectionsPerNodeReg, this.connectionsPerNodeState, this.connectionsPerNodePing, receivePredictorMin, receivePredictorMax);
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter service) {
        this.transportServiceAdapter = service;
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        InetSocketAddress publishAddress;
        InetAddress hostAddressX;
        OpenChannelsHandler openChannels;
        this.clientBootstrap = this.blockingClient ? new ClientBootstrap(new OioClientSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")))) : new ClientBootstrap(new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_boss")), this.bossCount, new NioWorkerPool(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")), this.workerCount), new HashedWheelTimer(EsExecutors.daemonThreadFactory(this.settings, "transport_client_timer"))));
        ChannelPipelineFactory clientPipelineFactory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
                if (NettyTransport.this.maxCumulationBufferCapacity != null) {
                    if (NettyTransport.this.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                        sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                    } else {
                        sizeHeader.setMaxCumulationBufferCapacity((int)NettyTransport.this.maxCumulationBufferCapacity.bytes());
                    }
                }
                if (NettyTransport.this.maxCompositeBufferComponents != -1) {
                    sizeHeader.setMaxCumulationBufferComponents(NettyTransport.this.maxCompositeBufferComponents);
                }
                pipeline.addLast("size", sizeHeader);
                pipeline.addLast("dispatcher", new MessageChannelHandler(NettyTransport.this, NettyTransport.this.logger));
                return pipeline;
            }
        };
        this.clientBootstrap.setPipelineFactory(clientPipelineFactory);
        this.clientBootstrap.setOption("connectTimeoutMillis", this.connectTimeout.millis());
        if (this.tcpNoDelay != null) {
            this.clientBootstrap.setOption("tcpNoDelay", this.tcpNoDelay);
        }
        if (this.tcpKeepAlive != null) {
            this.clientBootstrap.setOption("keepAlive", this.tcpKeepAlive);
        }
        if (this.tcpSendBufferSize != null && this.tcpSendBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("sendBufferSize", this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null && this.tcpReceiveBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("receiveBufferSize", this.tcpReceiveBufferSize.bytes());
        }
        this.clientBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        if (this.reuseAddress != null) {
            this.clientBootstrap.setOption("reuseAddress", this.reuseAddress);
        }
        if (!this.settings.getAsBoolean("network.server", (Boolean)true).booleanValue()) {
            return;
        }
        this.serverOpenChannels = openChannels = new OpenChannelsHandler(this.logger);
        this.serverBootstrap = this.blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker")))) : new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker")), this.workerCount));
        ChannelPipelineFactory serverPipelineFactory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("openChannels", openChannels);
                SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
                if (NettyTransport.this.maxCumulationBufferCapacity != null) {
                    if (NettyTransport.this.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                        sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                    } else {
                        sizeHeader.setMaxCumulationBufferCapacity((int)NettyTransport.this.maxCumulationBufferCapacity.bytes());
                    }
                }
                if (NettyTransport.this.maxCompositeBufferComponents != -1) {
                    sizeHeader.setMaxCumulationBufferComponents(NettyTransport.this.maxCompositeBufferComponents);
                }
                pipeline.addLast("size", sizeHeader);
                pipeline.addLast("dispatcher", new MessageChannelHandler(NettyTransport.this, NettyTransport.this.logger));
                return pipeline;
            }
        };
        this.serverBootstrap.setPipelineFactory(serverPipelineFactory);
        if (this.tcpNoDelay != null) {
            this.serverBootstrap.setOption("child.tcpNoDelay", this.tcpNoDelay);
        }
        if (this.tcpKeepAlive != null) {
            this.serverBootstrap.setOption("child.keepAlive", this.tcpKeepAlive);
        }
        if (this.tcpSendBufferSize != null && this.tcpSendBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.sendBufferSize", this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null && this.tcpReceiveBufferSize.bytes() > 0L) {
            this.serverBootstrap.setOption("child.receiveBufferSize", this.tcpReceiveBufferSize.bytes());
        }
        this.serverBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        this.serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        if (this.reuseAddress != null) {
            this.serverBootstrap.setOption("reuseAddress", this.reuseAddress);
            this.serverBootstrap.setOption("child.reuseAddress", this.reuseAddress);
        }
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(this.bindHost);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host [" + this.bindHost + "]", e);
        }
        final InetAddress hostAddress = hostAddressX;
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    NettyTransport.this.serverChannel = NettyTransport.this.serverBootstrap.bind(new InetSocketAddress(hostAddress, portNumber));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindTransportException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        this.logger.debug("Bound to address [{}]", this.serverChannel.getLocalAddress());
        InetSocketAddress boundAddress = (InetSocketAddress)this.serverChannel.getLocalAddress();
        int publishPort = this.publishPort;
        if (0 == publishPort) {
            publishPort = boundAddress.getPort();
        }
        try {
            publishAddress = new InetSocketAddress(this.networkService.resolvePublishHostAddress(this.publishHost), publishPort);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        this.boundAddress = new BoundTransportAddress(new InetSocketTransportAddress(boundAddress), new InetSocketTransportAddress(publishAddress));
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.threadPool.generic().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NettyTransport.this.globalLock.writeLock().lock();
                try {
                    NodeChannels nodeChannels;
                    Iterator it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.serverChannel != null) {
                        try {
                            NettyTransport.this.serverChannel.close().awaitUninterruptibly();
                        }
                        finally {
                            NettyTransport.this.serverChannel = null;
                        }
                    }
                    if (NettyTransport.this.serverOpenChannels != null) {
                        NettyTransport.this.serverOpenChannels.close();
                        NettyTransport.this.serverOpenChannels = null;
                    }
                    if (NettyTransport.this.serverBootstrap != null) {
                        NettyTransport.this.serverBootstrap.releaseExternalResources();
                        NettyTransport.this.serverBootstrap = null;
                    }
                    it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.clientBootstrap != null) {
                        NettyTransport.this.clientBootstrap.releaseExternalResources();
                        NettyTransport.this.clientBootstrap = null;
                    }
                }
                finally {
                    NettyTransport.this.globalLock.writeLock().unlock();
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws Exception {
        int index = address.indexOf(91);
        if (index != -1) {
            String host = address.substring(0, index);
            Set<String> ports = Strings.commaDelimitedListToSet(address.substring(index + 1, address.indexOf(93)));
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            for (String port : ports) {
                int[] iPorts;
                for (int iPort : iPorts = new PortsRange(port).ports()) {
                    addresses.add(new InetSocketTransportAddress(host, iPort));
                }
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        index = address.lastIndexOf(58);
        if (index == -1) {
            int[] iPorts;
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            for (int iPort : iPorts = new PortsRange(this.port).ports()) {
                addresses.add(new InetSocketTransportAddress(address, iPort));
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        String host = address.substring(0, index);
        int port = Integer.parseInt(address.substring(index + 1));
        return new TransportAddress[]{new InetSocketTransportAddress(host, port)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return InetSocketTransportAddress.class.equals(address);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            // empty if block
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
            this.logger.trace("close connection exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (NetworkExceptionHelper.isConnectException(e.getCause())) {
            this.logger.trace("connect exception caught on transport layer [{}]", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (e.getCause() instanceof CancelledKeyException) {
            this.logger.trace("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else {
            this.logger.warn("exception caught on transport layer [{}], closing connection", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        }
    }

    TransportAddress wrapAddress(SocketAddress socketAddress) {
        return new InetSocketTransportAddress((InetSocketAddress)socketAddress);
    }

    @Override
    public long serverOpen() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        Channel targetChannel = this.nodeChannel(node, options);
        if (this.compress) {
            options.withCompress(true);
        }
        byte status = 0;
        status = TransportStatus.setRequest(status);
        ReleasableBytesStreamOutput bStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean addedReleaseListener = false;
        try {
            ChannelBuffer buffer;
            ReleasableBytesReference bytes;
            bStream.skip(19);
            StreamOutput stream = bStream;
            if (options.compress() && !(request instanceof BytesTransportRequest)) {
                status = TransportStatus.setCompress(status);
                stream = CompressorFactory.defaultCompressor().streamOutput(stream);
            }
            stream = new HandlesStreamOutput(stream);
            Version version = Version.smallest(this.version, node.version());
            stream.setVersion(version);
            stream.writeString(action);
            if (request instanceof BytesTransportRequest) {
                BytesTransportRequest bRequest = (BytesTransportRequest)request;
                assert (node.version().equals(bRequest.version()));
                bRequest.writeThin(stream);
                stream.close();
                bytes = bStream.bytes();
                ChannelBuffer headerBuffer = bytes.toChannelBuffer();
                ChannelBuffer contentBuffer = bRequest.bytes().toChannelBuffer();
                buffer = new CompositeChannelBuffer(headerBuffer.order(), ImmutableList.of(headerBuffer, contentBuffer), false);
            } else {
                request.writeTo(stream);
                stream.close();
                bytes = bStream.bytes();
                buffer = bytes.toChannelBuffer();
            }
            NettyHeader.writeHeader(buffer, requestId, status, version);
            ChannelFuture future = targetChannel.write(buffer);
            ReleaseChannelFutureListener listener = new ReleaseChannelFutureListener(bytes);
            future.addListener(listener);
            return;
        }
        catch (Throwable throwable) {
            if (addedReleaseListener) throw throwable;
            Releasables.close(bStream.bytes());
            throw throwable;
        }
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, true);
    }

    @Override
    public void connectToNode(DiscoveryNode node) {
        this.connectToNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToNode(DiscoveryNode node, boolean light) {
        if (!this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("can't add nodes to a stopped transport");
        }
        if (node == null) {
            throw new ConnectTransportException(null, "can't connect to a null node");
        }
        this.globalLock.readLock().lock();
        try {
            if (!this.lifecycle.started()) {
                throw new ElasticsearchIllegalStateException("can't add nodes to a stopped transport");
            }
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
            if (nodeChannels != null) {
                return;
            }
            this.connectionLock.acquire(node.id());
            try {
                if (!this.lifecycle.started()) {
                    throw new ElasticsearchIllegalStateException("can't add nodes to a stopped transport");
                }
                try {
                    if (light) {
                        nodeChannels = this.connectToChannelsLight(node);
                    } else {
                        nodeChannels = new NodeChannels(new Channel[this.connectionsPerNodeRecovery], new Channel[this.connectionsPerNodeBulk], new Channel[this.connectionsPerNodeReg], new Channel[this.connectionsPerNodeState], new Channel[this.connectionsPerNodePing]);
                        try {
                            this.connectToChannels(nodeChannels, node);
                        }
                        catch (Exception e) {
                            nodeChannels.close();
                            throw e;
                        }
                    }
                    NodeChannels existing = this.connectedNodes.putIfAbsent(node, nodeChannels);
                    if (existing != null) {
                        nodeChannels.close();
                    } else {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("connected to node [{}]", node);
                        }
                        this.transportServiceAdapter.raiseNodeConnected(node);
                    }
                }
                catch (ConnectTransportException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConnectTransportException(node, "General node connection failure", e);
                }
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private NodeChannels connectToChannelsLight(DiscoveryNode node) {
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        ChannelFuture connect = this.clientBootstrap.connect(address);
        connect.awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
        if (!connect.isSuccess()) {
            throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connect.getCause());
        }
        Channel[] channels = new Channel[]{connect.getChannel()};
        channels[0].getCloseFuture().addListener(new ChannelCloseListener(node));
        return new NodeChannels(channels, channels, channels, channels, channels);
    }

    private void connectToChannels(NodeChannels nodeChannels, DiscoveryNode node) {
        int i;
        Object[] connectRecovery = new ChannelFuture[nodeChannels.recovery.length];
        Object[] connectBulk = new ChannelFuture[nodeChannels.bulk.length];
        Object[] connectReg = new ChannelFuture[nodeChannels.reg.length];
        Object[] connectState = new ChannelFuture[nodeChannels.state.length];
        Object[] connectPing = new ChannelFuture[nodeChannels.ping.length];
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        for (i = 0; i < connectRecovery.length; ++i) {
            connectRecovery[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectBulk.length; ++i) {
            connectBulk[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectReg.length; ++i) {
            connectReg[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectState.length; ++i) {
            connectState[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectPing.length; ++i) {
            connectPing[i] = this.clientBootstrap.connect(address);
        }
        try {
            for (i = 0; i < connectRecovery.length; ++i) {
                connectRecovery[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectRecovery[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectRecovery[i].getCause());
                }
                ((NodeChannels)nodeChannels).recovery[i] = connectRecovery[i].getChannel();
                nodeChannels.recovery[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectBulk.length; ++i) {
                connectBulk[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectBulk[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectBulk[i].getCause());
                }
                ((NodeChannels)nodeChannels).bulk[i] = connectBulk[i].getChannel();
                nodeChannels.bulk[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectReg.length; ++i) {
                connectReg[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectReg[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectReg[i].getCause());
                }
                ((NodeChannels)nodeChannels).reg[i] = connectReg[i].getChannel();
                nodeChannels.reg[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectState.length; ++i) {
                connectState[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectState[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectState[i].getCause());
                }
                ((NodeChannels)nodeChannels).state[i] = connectState[i].getChannel();
                nodeChannels.state[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectPing.length; ++i) {
                connectPing[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectPing[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectPing[i].getCause());
                }
                ((NodeChannels)nodeChannels).ping[i] = connectPing[i].getChannel();
                nodeChannels.ping[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            if (nodeChannels.recovery.length == 0) {
                if (nodeChannels.bulk.length > 0) {
                    NodeChannels.access$802(nodeChannels, nodeChannels.bulk);
                } else {
                    NodeChannels.access$802(nodeChannels, nodeChannels.reg);
                }
            }
            if (nodeChannels.bulk.length == 0) {
                NodeChannels.access$902(nodeChannels, nodeChannels.reg);
            }
        }
        catch (RuntimeException e) {
            for (ChannelFuture future : ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(connectRecovery)).add(connectBulk)).add(connectReg)).add(connectState)).add(connectPing)).build()) {
                future.cancel();
                if (future.getChannel() == null || !future.getChannel().isOpen()) continue;
                try {
                    future.getChannel().close();
                }
                catch (Exception e1) {}
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            this.connectionLock.acquire(node.id());
            try {
                try {
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.debug("disconnected from [{}]", node);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.debug("disconnected from [{}]", node);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFromNode(DiscoveryNode node, Channel channel, String reason) {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels != null && nodeChannels.hasChannel(channel)) {
            this.connectionLock.acquire(node.id());
            if (!nodeChannels.hasChannel(channel)) {
                assert (!this.connectedNodes.containsKey(node));
            } else {
                try {
                    this.connectedNodes.remove(node);
                    try {
                        nodeChannels.close();
                    }
                    catch (Throwable throwable) {
                        this.logger.debug("disconnected from [{}], {}", node, reason);
                        this.transportServiceAdapter.raiseNodeDisconnected(node);
                        throw throwable;
                    }
                    this.logger.debug("disconnected from [{}], {}", node, reason);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                }
                finally {
                    this.connectionLock.release(node.id());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFromNodeChannel(Channel channel, Throwable failure) {
        for (DiscoveryNode node : this.connectedNodes.keySet()) {
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
            if (nodeChannels == null || !nodeChannels.hasChannel(channel)) continue;
            this.connectionLock.acquire(node.id());
            if (!nodeChannels.hasChannel(channel)) {
                assert (!this.connectedNodes.containsKey(node));
                continue;
            }
            try {
                this.connectedNodes.remove(node);
                try {
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.debug("disconnected from [{}] on channel failure", failure, node);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.debug("disconnected from [{}] on channel failure", failure, node);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
    }

    private Channel nodeChannel(DiscoveryNode node, TransportRequestOptions options) throws ConnectTransportException {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return nodeChannels.channel(options.type());
    }

    static {
        NettyStaticSetup.setup();
    }

    public static class NodeChannels {
        private Channel[] recovery;
        private final AtomicInteger recoveryCounter = new AtomicInteger();
        private Channel[] bulk;
        private final AtomicInteger bulkCounter = new AtomicInteger();
        private Channel[] reg;
        private final AtomicInteger regCounter = new AtomicInteger();
        private Channel[] state;
        private final AtomicInteger stateCounter = new AtomicInteger();
        private Channel[] ping;
        private final AtomicInteger pingCounter = new AtomicInteger();

        public NodeChannels(Channel[] recovery, Channel[] bulk, Channel[] reg, Channel[] state, Channel[] ping) {
            this.recovery = recovery;
            this.bulk = bulk;
            this.reg = reg;
            this.state = state;
            this.ping = ping;
        }

        public boolean hasChannel(Channel channel) {
            return this.hasChannel(channel, this.recovery) || this.hasChannel(channel, this.bulk) || this.hasChannel(channel, this.reg) || this.hasChannel(channel, this.state) || this.hasChannel(channel, this.ping);
        }

        private boolean hasChannel(Channel channel, Channel[] channels) {
            for (Channel channel1 : channels) {
                if (!channel.equals(channel1)) continue;
                return true;
            }
            return false;
        }

        public Channel channel(TransportRequestOptions.Type type) {
            if (type == TransportRequestOptions.Type.REG) {
                return this.reg[MathUtils.mod(this.regCounter.incrementAndGet(), this.reg.length)];
            }
            if (type == TransportRequestOptions.Type.STATE) {
                return this.state[MathUtils.mod(this.stateCounter.incrementAndGet(), this.state.length)];
            }
            if (type == TransportRequestOptions.Type.PING) {
                return this.ping[MathUtils.mod(this.pingCounter.incrementAndGet(), this.ping.length)];
            }
            if (type == TransportRequestOptions.Type.BULK) {
                return this.bulk[MathUtils.mod(this.bulkCounter.incrementAndGet(), this.bulk.length)];
            }
            if (type == TransportRequestOptions.Type.RECOVERY) {
                return this.recovery[MathUtils.mod(this.recoveryCounter.incrementAndGet(), this.recovery.length)];
            }
            throw new ElasticsearchIllegalArgumentException("no type channel for [" + (Object)((Object)type) + "]");
        }

        public synchronized void close() {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            this.closeChannelsAndWait(this.recovery, futures);
            this.closeChannelsAndWait(this.bulk, futures);
            this.closeChannelsAndWait(this.reg, futures);
            this.closeChannelsAndWait(this.state, futures);
            this.closeChannelsAndWait(this.ping, futures);
            for (ChannelFuture future : futures) {
                future.awaitUninterruptibly();
            }
        }

        private void closeChannelsAndWait(Channel[] channels, List<ChannelFuture> futures) {
            for (Channel channel : channels) {
                try {
                    if (channel == null || !channel.isOpen()) continue;
                    futures.add(channel.close());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Channel[] access$802(NodeChannels x0, Channel[] x1) {
            x0.recovery = x1;
            return x1;
        }

        static /* synthetic */ Channel[] access$902(NodeChannels x0, Channel[] x1) {
            x0.bulk = x1;
            return x1;
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            NettyTransport.this.disconnectFromNode(this.node, future.getChannel(), "channel closed event");
        }
    }
}

