/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IndexNameExpressionResolver
extends AbstractComponent {
    private final List<ExpressionResolver> expressionResolvers;
    private final DateMathExpressionResolver dateMathExpressionResolver;

    @Inject
    public IndexNameExpressionResolver(Settings settings) {
        super(settings);
        ExpressionResolver[] expressionResolverArray = new ExpressionResolver[2];
        this.dateMathExpressionResolver = new DateMathExpressionResolver(settings);
        expressionResolverArray[0] = this.dateMathExpressionResolver;
        expressionResolverArray[1] = new WildcardExpressionResolver();
        this.expressionResolvers = Arrays.asList(expressionResolverArray);
    }

    public String[] concreteIndices(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions());
        return this.concreteIndices(context, request.indices());
    }

    public String[] concreteIndices(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options);
        return this.concreteIndices(context, indexExpressions);
    }

    public String[] concreteIndices(ClusterState state, IndicesOptions options, long startTime, String ... indexExpressions) {
        Context context = new Context(state, options, startTime);
        return this.concreteIndices(context, indexExpressions);
    }

    String[] concreteIndices(Context context, String ... indexExpressions) {
        boolean failNoIndices;
        if (indexExpressions == null || indexExpressions.length == 0) {
            indexExpressions = new String[]{"_all"};
        }
        MetaData metaData = context.getState().metaData();
        IndicesOptions options = context.getOptions();
        boolean failClosed = options.forbidClosedIndices() && !options.ignoreUnavailable();
        boolean bl = failNoIndices = !options.ignoreUnavailable();
        if (indexExpressions.length == 1) {
            failNoIndices = !options.allowNoIndices();
        }
        List<String> expressions = Arrays.asList(indexExpressions);
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            expressions = expressionResolver.resolve(context, expressions);
        }
        if (expressions.isEmpty()) {
            if (!options.allowNoIndices()) {
                IndexNotFoundException infe = new IndexNotFoundException((String)null);
                infe.setResources("index_expression", indexExpressions);
                throw infe;
            }
            return Strings.EMPTY_ARRAY;
        }
        HashSet<String> concreteIndices = new HashSet<String>(expressions.size());
        for (String expression : expressions) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(expression);
            if (aliasOrIndex == null) {
                if (!failNoIndices) continue;
                IndexNotFoundException infe = new IndexNotFoundException(expression);
                infe.setResources("index_expression", expression);
                throw infe;
            }
            List<IndexMetaData> resolvedIndices = aliasOrIndex.getIndices();
            if (resolvedIndices.size() > 1 && !options.allowAliasesToMultipleIndices()) {
                Object[] indexNames = new String[resolvedIndices.size()];
                int i = 0;
                for (IndexMetaData indexMetaData : resolvedIndices) {
                    indexNames[i++] = indexMetaData.getIndex();
                }
                throw new IllegalArgumentException("Alias [" + expression + "] has more than one indices associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
            }
            for (IndexMetaData index : resolvedIndices) {
                if (index.getState() == IndexMetaData.State.CLOSE) {
                    if (failClosed) {
                        throw new IndexClosedException(new Index(index.getIndex()));
                    }
                    if (options.forbidClosedIndices()) continue;
                    concreteIndices.add(index.getIndex());
                    continue;
                }
                if (index.getState() == IndexMetaData.State.OPEN) {
                    concreteIndices.add(index.getIndex());
                    continue;
                }
                throw new IllegalStateException("index state [" + (Object)((Object)index.getState()) + "] not supported");
            }
        }
        if (!options.allowNoIndices() && concreteIndices.isEmpty()) {
            IndexNotFoundException infe = new IndexNotFoundException((String)null);
            infe.setResources("index_expression", indexExpressions);
            throw infe;
        }
        return concreteIndices.toArray(new String[concreteIndices.size()]);
    }

    public String concreteSingleIndex(ClusterState state, IndicesRequest request) {
        String indexExpression = request.indices() != null && request.indices().length > 0 ? request.indices()[0] : null;
        String[] indices = this.concreteIndices(state, request.indicesOptions(), indexExpression);
        if (indices.length != 1) {
            throw new IllegalArgumentException("unable to return a single index as the index and options provided got resolved to multiple indices");
        }
        return indices[0];
    }

    public boolean hasIndexOrAlias(String aliasOrIndex, ClusterState state) {
        Context context = new Context(state, IndicesOptions.lenientExpandOpen());
        String resolvedAliasOrIndex = this.dateMathExpressionResolver.resolveExpression(aliasOrIndex, context);
        return state.metaData().getAliasAndIndexLookup().containsKey(resolvedAliasOrIndex);
    }

    public String resolveDateMathExpression(String dateExpression) {
        return this.dateMathExpressionResolver.resolveExpression(dateExpression, new Context(null, null));
    }

    public String[] filteringAliases(ClusterState state, String index, String ... expressions) {
        List<String> resolvedExpressions = expressions != null ? Arrays.asList(expressions) : Collections.emptyList();
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), true);
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            resolvedExpressions = expressionResolver.resolve(context, resolvedExpressions);
        }
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return null;
        }
        if (resolvedExpressions.size() == 1) {
            boolean filteringRequired;
            String alias = resolvedExpressions.get(0);
            IndexMetaData indexMetaData = state.metaData().getIndices().get(index);
            if (indexMetaData == null) {
                throw new IndexNotFoundException(index);
            }
            AliasMetaData aliasMetaData = indexMetaData.getAliases().get(alias);
            boolean bl = filteringRequired = aliasMetaData != null && aliasMetaData.filteringRequired();
            if (!filteringRequired) {
                return null;
            }
            return new String[]{alias};
        }
        ArrayList<String> filteringAliases = null;
        for (String alias : resolvedExpressions) {
            if (alias.equals(index)) {
                return null;
            }
            IndexMetaData indexMetaData = state.metaData().getIndices().get(index);
            if (indexMetaData == null) {
                throw new IndexNotFoundException(index);
            }
            AliasMetaData aliasMetaData = indexMetaData.getAliases().get(alias);
            if (aliasMetaData == null) continue;
            boolean filteringRequired = aliasMetaData.filteringRequired();
            if (filteringRequired) {
                if (filteringAliases == null) {
                    filteringAliases = new ArrayList<String>();
                }
                filteringAliases.add(alias);
                continue;
            }
            return null;
        }
        if (filteringAliases == null) {
            return null;
        }
        return filteringAliases.toArray(new String[filteringAliases.size()]);
    }

    public Map<String, Set<String>> resolveSearchRouting(ClusterState state, @Nullable String routing, String ... expressions) {
        List<String> resolvedExpressions = expressions != null ? Arrays.asList(expressions) : Collections.emptyList();
        Context context = new Context(state, IndicesOptions.lenientExpandOpen());
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            resolvedExpressions = expressionResolver.resolve(context, resolvedExpressions);
        }
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return this.resolveSearchRoutingAllIndices(state.metaData(), routing);
        }
        Map routings = null;
        Set<String> paramRouting = null;
        HashSet<String> norouting = new HashSet<String>();
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        for (String expression : resolvedExpressions) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)state.metaData().getAliasAndIndexLookup().get(expression);
            if (aliasOrIndex != null && aliasOrIndex.isAlias()) {
                AliasOrIndex.Alias alias = (AliasOrIndex.Alias)aliasOrIndex;
                for (Tuple<String, AliasMetaData> item : alias.getConcreteIndexAndAliasMetaDatas()) {
                    HashSet<Object> r;
                    String concreteIndex = item.v1();
                    AliasMetaData aliasMetaData = item.v2();
                    if (norouting.contains(concreteIndex)) continue;
                    if (!aliasMetaData.searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        if ((r = (HashSet<String>)routings.get(concreteIndex)) == null) {
                            r = new HashSet<String>();
                            routings.put(concreteIndex, r);
                        }
                        r.addAll(aliasMetaData.searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(concreteIndex);
                        continue;
                    }
                    if (norouting.contains(concreteIndex)) continue;
                    norouting.add(concreteIndex);
                    if (paramRouting != null) {
                        r = new HashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        routings.put(concreteIndex, r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(concreteIndex);
                }
                continue;
            }
            if (norouting.contains(expression)) continue;
            norouting.add(expression);
            if (paramRouting != null) {
                HashSet<String> r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put(expression, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(expression);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingAllIndices(MetaData metaData, String routing) {
        if (routing != null) {
            String[] concreteIndices;
            Set<String> r = Strings.splitStringByCommaToSet(routing);
            HashMap routings = Maps.newHashMap();
            for (String index : concreteIndices = metaData.concreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public static boolean isAllIndices(List<String> aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.isEmpty() || IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices);
    }

    static boolean isExplicitAllPattern(List<String> aliasesOrIndices) {
        return aliasesOrIndices != null && aliasesOrIndices.size() == 1 && "_all".equals(aliasesOrIndices.get(0));
    }

    boolean isPatternMatchingAllIndices(MetaData metaData, String[] indicesOrAliases, String[] concreteIndices) {
        if (concreteIndices.length == metaData.concreteAllIndices().length && indicesOrAliases.length > 0) {
            if (indicesOrAliases[0].charAt(0) == '-') {
                return true;
            }
            for (String indexOrAlias : indicesOrAliases) {
                if (!Regex.isSimpleMatchPattern(indexOrAlias)) continue;
                return true;
            }
        }
        return false;
    }

    static final class DateMathExpressionResolver
    implements ExpressionResolver {
        private static final String EXPRESSION_LEFT_BOUND = "<";
        private static final String EXPRESSION_RIGHT_BOUND = ">";
        private static final char LEFT_BOUND = '{';
        private static final char RIGHT_BOUND = '}';
        private static final char ESCAPE_CHAR = '\\';
        private static final char TIME_ZONE_BOUND = '|';
        private final DateTimeZone defaultTimeZone;
        private final String defaultDateFormatterPattern;
        private final DateTimeFormatter defaultDateFormatter;

        public DateMathExpressionResolver(Settings settings) {
            String defaultTimeZoneId = settings.get("date_math_expression_resolver.default_time_zone", "UTC");
            this.defaultTimeZone = DateTimeZone.forID((String)defaultTimeZoneId);
            this.defaultDateFormatterPattern = settings.get("date_math_expression_resolver.default_date_format", "YYYY.MM.dd");
            this.defaultDateFormatter = DateTimeFormat.forPattern((String)this.defaultDateFormatterPattern);
        }

        @Override
        public List<String> resolve(Context context, List<String> expressions) {
            ArrayList<String> result = new ArrayList<String>(expressions.size());
            for (String expression : expressions) {
                result.add(this.resolveExpression(expression, context));
            }
            return result;
        }

        String resolveExpression(String expression, final Context context) {
            if (!expression.startsWith(EXPRESSION_LEFT_BOUND) || !expression.endsWith(EXPRESSION_RIGHT_BOUND)) {
                return expression;
            }
            boolean escape = false;
            boolean inDateFormat = false;
            boolean inPlaceHolder = false;
            StringBuilder beforePlaceHolderSb = new StringBuilder();
            StringBuilder inPlaceHolderSb = new StringBuilder();
            char[] text = expression.toCharArray();
            boolean from = true;
            int length = text.length - 1;
            block8: for (int i = 1; i < length; ++i) {
                char c;
                boolean escapedChar = escape;
                if (escape) {
                    escape = false;
                }
                if ((c = text[i]) == '\\') {
                    if (escapedChar) {
                        beforePlaceHolderSb.append(c);
                        escape = false;
                        continue;
                    }
                    escape = true;
                    continue;
                }
                if (inPlaceHolder) {
                    switch (c) {
                        case '{': {
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (!inDateFormat) {
                                inDateFormat = true;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character in placeholder at position [{}]", new String(text, 1, length), i);
                        }
                        case '}': {
                            DateTimeZone timeZone;
                            DateTimeFormatter dateFormatter;
                            String dateFormatterPattern;
                            String mathExpression;
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (inDateFormat) {
                                inDateFormat = false;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            String inPlaceHolderString = inPlaceHolderSb.toString();
                            int dateTimeFormatLeftBoundIndex = inPlaceHolderString.indexOf(123);
                            if (dateTimeFormatLeftBoundIndex < 0) {
                                mathExpression = inPlaceHolderString;
                                dateFormatterPattern = this.defaultDateFormatterPattern;
                                dateFormatter = this.defaultDateFormatter;
                                timeZone = this.defaultTimeZone;
                            } else {
                                if (inPlaceHolderString.lastIndexOf(125) != inPlaceHolderString.length() - 1) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing closing `}` for date math format", inPlaceHolderString);
                                }
                                if (dateTimeFormatLeftBoundIndex == inPlaceHolderString.length() - 2) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing date format", inPlaceHolderString);
                                }
                                mathExpression = inPlaceHolderString.substring(0, dateTimeFormatLeftBoundIndex);
                                String dateFormatterPatternAndTimeZoneId = inPlaceHolderString.substring(dateTimeFormatLeftBoundIndex + 1, inPlaceHolderString.length() - 1);
                                int formatPatternTimeZoneSeparatorIndex = dateFormatterPatternAndTimeZoneId.indexOf(124);
                                if (formatPatternTimeZoneSeparatorIndex != -1) {
                                    dateFormatterPattern = dateFormatterPatternAndTimeZoneId.substring(0, formatPatternTimeZoneSeparatorIndex);
                                    timeZone = DateTimeZone.forID((String)dateFormatterPatternAndTimeZoneId.substring(formatPatternTimeZoneSeparatorIndex + 1));
                                } else {
                                    dateFormatterPattern = dateFormatterPatternAndTimeZoneId;
                                    timeZone = this.defaultTimeZone;
                                }
                                dateFormatter = DateTimeFormat.forPattern((String)dateFormatterPattern);
                            }
                            DateTimeFormatter parser = dateFormatter.withZone(timeZone);
                            FormatDateTimeFormatter formatter = new FormatDateTimeFormatter(dateFormatterPattern, parser, Locale.ROOT);
                            DateMathParser dateMathParser = new DateMathParser(formatter);
                            long millis = dateMathParser.parse(mathExpression, new Callable<Long>(){

                                @Override
                                public Long call() throws Exception {
                                    return context.getStartTime();
                                }
                            }, false, timeZone);
                            String time = formatter.printer().print(millis);
                            beforePlaceHolderSb.append(time);
                            inPlaceHolderSb = new StringBuilder();
                            inPlaceHolder = false;
                            break;
                        }
                        default: {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '{': {
                        if (escapedChar) {
                            beforePlaceHolderSb.append(c);
                            continue block8;
                        }
                        inPlaceHolder = true;
                        continue block8;
                    }
                    case '}': {
                        if (!escapedChar) {
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character at position [{}]. `{` and `}` are reserved characters and should be escaped when used as part of the index name using `\\` (e.g. `\\{text\\}`)", new String(text, 1, length), i);
                        }
                    }
                    default: {
                        beforePlaceHolderSb.append(c);
                    }
                }
            }
            if (inPlaceHolder) {
                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. date math placeholder is open ended", new String(text, 1, length));
            }
            if (beforePlaceHolderSb.length() == 0) {
                throw new ElasticsearchParseException("nothing captured", new Object[0]);
            }
            return beforePlaceHolderSb.toString();
        }
    }

    static final class WildcardExpressionResolver
    implements ExpressionResolver {
        WildcardExpressionResolver() {
        }

        @Override
        public List<String> resolve(Context context, List<String> expressions) {
            IndicesOptions options = context.getOptions();
            MetaData metaData = context.getState().metaData();
            if (!options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                return expressions;
            }
            if (expressions.isEmpty() || expressions.size() == 1 && ("_all".equals(expressions.get(0)) || Regex.isMatchAllPattern(expressions.get(0)))) {
                if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                    return Arrays.asList(metaData.concreteAllIndices());
                }
                if (options.expandWildcardsOpen()) {
                    return Arrays.asList(metaData.concreteAllOpenIndices());
                }
                if (options.expandWildcardsClosed()) {
                    return Arrays.asList(metaData.concreteAllClosedIndices());
                }
                return Collections.emptyList();
            }
            HashSet<Object> result = null;
            boolean wildcardSeen = false;
            for (int i = 0; i < expressions.size(); ++i) {
                SortedMap<String, AliasOrIndex> matches;
                IndexMetaData.State excludeState;
                String expression = expressions.get(i);
                if (metaData.getAliasAndIndexLookup().containsKey(expression)) {
                    if (result == null) continue;
                    result.add(expression);
                    continue;
                }
                if (Strings.isEmpty(expression)) {
                    throw new IndexNotFoundException(expression);
                }
                boolean add = true;
                if (expression.charAt(0) == '+') {
                    if (i == 0) {
                        result = new HashSet<String>();
                    }
                    add = true;
                    expression = expression.substring(1);
                } else if (expression.charAt(0) == '-') {
                    if (wildcardSeen) {
                        add = false;
                        expression = expression.substring(1);
                    } else {
                        add = true;
                    }
                }
                if (result == null) {
                    result = new HashSet<String>(expressions.subList(0, i));
                }
                if (!Regex.isSimpleMatchPattern(expression)) {
                    if (!options.ignoreUnavailable() && !metaData.getAliasAndIndexLookup().containsKey(expression)) {
                        IndexNotFoundException infe = new IndexNotFoundException(expression);
                        infe.setResources("index_or_alias", expression);
                        throw infe;
                    }
                    if (add) {
                        result.add(expression);
                        continue;
                    }
                    result.remove(expression);
                    continue;
                }
                if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                    excludeState = null;
                } else if (options.expandWildcardsOpen() && !options.expandWildcardsClosed()) {
                    excludeState = IndexMetaData.State.CLOSE;
                } else if (options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                    excludeState = IndexMetaData.State.OPEN;
                } else {
                    assert (false) : "this shouldn't get called if wildcards expand to none";
                    excludeState = null;
                }
                if (Regex.isMatchAllPattern(expression)) {
                    matches = metaData.getAliasAndIndexLookup();
                } else if (expression.indexOf("*") == expression.length() - 1) {
                    assert (expression.length() >= 2) : "expression [" + expression + "] should have at least a length of 2";
                    String fromPrefix = expression.substring(0, expression.length() - 1);
                    char[] toPrefixCharArr = fromPrefix.toCharArray();
                    int n = toPrefixCharArr.length - 1;
                    toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
                    String toPrefix = new String(toPrefixCharArr);
                    matches = metaData.getAliasAndIndexLookup().subMap(fromPrefix, toPrefix);
                } else {
                    final String pattern = expression;
                    matches = Maps.filterEntries(metaData.getAliasAndIndexLookup(), (Predicate)new Predicate<Map.Entry<String, AliasOrIndex>>(){

                        public boolean apply(@Nullable Map.Entry<String, AliasOrIndex> input) {
                            return Regex.simpleMatch(pattern, input.getKey());
                        }
                    });
                }
                HashSet<Object> expand = new HashSet<Object>();
                for (Map.Entry entry : matches.entrySet()) {
                    AliasOrIndex aliasOrIndex = (AliasOrIndex)entry.getValue();
                    if (context.isPreserveAliases() && aliasOrIndex.isAlias()) {
                        expand.add(entry.getKey());
                        continue;
                    }
                    for (IndexMetaData meta : aliasOrIndex.getIndices()) {
                        if (excludeState != null && meta.getState() == excludeState) continue;
                        expand.add(meta.getIndex());
                    }
                }
                if (add) {
                    result.addAll(expand);
                } else {
                    result.removeAll(expand);
                }
                if (matches.isEmpty() && !options.allowNoIndices()) {
                    IndexNotFoundException infe = new IndexNotFoundException(expression);
                    infe.setResources("index_or_alias", expression);
                    throw infe;
                }
                if (!Regex.isSimpleMatchPattern(expression)) continue;
                wildcardSeen = true;
            }
            if (result == null) {
                return expressions;
            }
            if (result.isEmpty() && !options.allowNoIndices()) {
                IndexNotFoundException infe = new IndexNotFoundException((String)null);
                infe.setResources("index_or_alias", expressions.toArray(new String[0]));
                throw infe;
            }
            return new ArrayList<String>(result);
        }
    }

    private static interface ExpressionResolver {
        public List<String> resolve(Context var1, List<String> var2);
    }

    static final class Context {
        private final ClusterState state;
        private final IndicesOptions options;
        private final long startTime;
        private final boolean preserveAliases;

        Context(ClusterState state, IndicesOptions options) {
            this(state, options, System.currentTimeMillis());
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases) {
            this(state, options, System.currentTimeMillis(), preserveAliases);
        }

        public Context(ClusterState state, IndicesOptions options, long startTime) {
            this(state, options, startTime, false);
        }

        public Context(ClusterState state, IndicesOptions options, long startTime, boolean preserveAliases) {
            this.state = state;
            this.options = options;
            this.startTime = startTime;
            this.preserveAliases = preserveAliases;
        }

        public ClusterState getState() {
            return this.state;
        }

        public IndicesOptions getOptions() {
            return this.options;
        }

        public long getStartTime() {
            return this.startTime;
        }

        boolean isPreserveAliases() {
            return this.preserveAliases;
        }
    }
}

