/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.google.common.collect.ImmutableMap;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public class ParsedQuery {
    private final Query query;
    private final ImmutableMap<String, Query> namedFilters;

    public ParsedQuery(Query query, ImmutableMap<String, Query> namedFilters) {
        this.query = query;
        this.namedFilters = namedFilters;
    }

    public ParsedQuery(Query query, ParsedQuery parsedQuery) {
        this.query = query;
        this.namedFilters = parsedQuery.namedFilters;
    }

    public ParsedQuery(Query query) {
        this.query = query;
        this.namedFilters = ImmutableMap.of();
    }

    public Query query() {
        return this.query;
    }

    public ImmutableMap<String, Query> namedFilters() {
        return this.namedFilters;
    }

    public static ParsedQuery parsedMatchAllQuery() {
        return new ParsedQuery(Queries.newMatchAllQuery(), (ImmutableMap<String, Query>)ImmutableMap.of());
    }
}

