/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import com.google.common.collect.Maps;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;

public class LeafDocLookup
implements Map {
    private final Map<String, ScriptDocValues> localCacheFieldData = Maps.newHashMapWithExpectedSize((int)4);
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    @Nullable
    private final String[] types;
    private final LeafReaderContext reader;
    private int docId = -1;

    LeafDocLookup(MapperService mapperService, IndexFieldDataService fieldDataService, @Nullable String[] types, LeafReaderContext reader) {
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
        this.types = types;
        this.reader = reader;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexFieldDataService fieldDataService() {
        return this.fieldDataService;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    public Object get(Object key) {
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        if (scriptValues == null) {
            final MappedFieldType fieldType = this.mapperService.smartNameFieldType(fieldName, this.types);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping with types " + Arrays.toString(this.types) + "");
            }
            scriptValues = AccessController.doPrivileged(new PrivilegedAction<ScriptDocValues>(){

                @Override
                public ScriptDocValues run() {
                    return LeafDocLookup.this.fieldDataService.getForField(fieldType).load(LeafDocLookup.this.reader).getScriptValues();
                }
            });
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        scriptValues.setNextDocId(this.docId);
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        MappedFieldType fieldType;
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || (fieldType = this.mapperService.smartNameFieldType(fieldName, this.types)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }
}

