/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.LocalMapStatsImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MapMaxSizePolicy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NearCache;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.VersionedBackupOp;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.concurrentmap.LFUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.LRUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.MapStoreWrapper;
import com.hazelcast.impl.concurrentmap.MultiData;
import com.hazelcast.logging.ILogger;
import com.hazelcast.merge.MergePolicy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.query.Expression;
import com.hazelcast.query.MapIndexService;
import com.hazelcast.util.SortedHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private static final Comparator<MapEntry> LRU_COMPARATOR = new LRUMapEntryComparator();
    private static final Comparator<MapEntry> LFU_COMPARATOR = new LFUMapEntryComparator();
    final ILogger logger;
    final ConcurrentMapManager concurrentMapManager;
    final Node node;
    final int PARTITION_COUNT;
    final Block[] blocks;
    final Address thisAddress;
    final ConcurrentMap<Data, Record> mapRecords = new ConcurrentHashMap<Data, Record>(10000, 0.75f, 1);
    final String name;
    final Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>(1);
    final int backupCount;
    final EvictionPolicy evictionPolicy;
    final Comparator<MapEntry> evictionComparator;
    final MapMaxSizePolicy maxSizePolicy;
    final float evictionRate;
    final long ttl;
    final long maxIdle;
    final Instance.InstanceType instanceType;
    final MapLoader loader;
    final MapStore store;
    final MergePolicy mergePolicy;
    final long writeDelayMillis;
    final long removeDelayMillis;
    final long evictionDelayMillis;
    final MapIndexService mapIndexService;
    final NearCache nearCache;
    final long creationTime;
    final boolean readBackupData;
    final boolean cacheValue;
    final boolean mapForQueue;
    volatile boolean ttlPerRecord = false;
    volatile long lastEvictionTime = 0L;
    DistributedLock lockEntireMap = null;
    CleanupState cleanupState = CleanupState.NONE;
    volatile boolean initialized = false;
    final Object initLock = new Object();

    CMap(ConcurrentMapManager concurrentMapManager, String name) {
        MergePolicyConfig mergePolicyConfig;
        this.concurrentMapManager = concurrentMapManager;
        this.logger = concurrentMapManager.node.getLogger(CMap.class.getName());
        this.PARTITION_COUNT = concurrentMapManager.PARTITION_COUNT;
        this.blocks = concurrentMapManager.blocks;
        this.node = concurrentMapManager.node;
        this.thisAddress = concurrentMapManager.thisAddress;
        this.name = name;
        this.mapForQueue = name.startsWith("c:q:");
        this.instanceType = ConcurrentMapManager.getInstanceType(name);
        MapConfig mapConfig = null;
        String mapConfigName = name.substring(2);
        if (this.isMultiMap() || mapConfigName.startsWith("__hz_") || mapConfigName.startsWith("l:") || mapConfigName.startsWith("s:")) {
            mapConfig = new MapConfig();
        } else if (this.mapForQueue) {
            String queueShortName = name.substring(4);
            QueueConfig qConfig = this.node.getConfig().findMatchingQueueConfig(queueShortName);
            mapConfig = this.node.getConfig().findMatchingMapConfig(qConfig.getBackingMapRef());
        } else {
            mapConfig = this.node.getConfig().findMatchingMapConfig(mapConfigName);
        }
        this.mapIndexService = new MapIndexService(mapConfig.isValueIndexed());
        this.backupCount = mapConfig.getBackupCount();
        this.ttl = (long)mapConfig.getTimeToLiveSeconds() * 1000L;
        this.evictionDelayMillis = (long)mapConfig.getEvictionDelaySeconds() * 1000L;
        this.maxIdle = (long)mapConfig.getMaxIdleSeconds() * 1000L;
        this.evictionPolicy = EvictionPolicy.valueOf(mapConfig.getEvictionPolicy());
        this.readBackupData = mapConfig.isReadBackupData();
        this.cacheValue = mapConfig.isCacheValue();
        MaxSizeConfig maxSizeConfig = mapConfig.getMaxSizeConfig();
        this.maxSizePolicy = "map_size_per_jvm".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizePerJVMPolicy(maxSizeConfig) : ("cluster_wide_map_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeClusterWidePolicy(maxSizeConfig) : ("partitions_wide_map_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizePartitionsWidePolicy(maxSizeConfig) : ("used_heap_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeHeapPolicy(maxSizeConfig) : ("used_heap_percentage".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeHeapPercentagePolicy(maxSizeConfig) : null))));
        this.evictionComparator = this.evictionPolicy == EvictionPolicy.NONE ? null : (this.evictionPolicy == EvictionPolicy.LRU ? new ComparatorWrapper(LRU_COMPARATOR) : new ComparatorWrapper(LFU_COMPARATOR));
        this.evictionRate = (float)mapConfig.getEvictionPercentage() / 100.0f;
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        MapStoreWrapper mapStoreWrapper = null;
        int writeDelaySeconds = -1;
        if (!this.node.isSuperClient() && mapStoreConfig != null && mapStoreConfig.isEnabled()) {
            try {
                Object storeInstance = mapStoreConfig.getImplementation();
                if (storeInstance == null) {
                    String mapStoreClassName = mapStoreConfig.getClassName();
                    storeInstance = Serializer.classForName(this.node.getConfig().getClassLoader(), mapStoreClassName).newInstance();
                }
                if (!(mapStoreWrapper = new MapStoreWrapper(storeInstance, this.node.factory.getHazelcastInstanceProxy(), mapStoreConfig.getProperties(), mapConfigName)).isMapLoader() && !mapStoreWrapper.isMapStore()) {
                    throw new Exception("MapStore class [" + storeInstance.getClass().getName() + "] should implement either MapLoader or MapStore!");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
        }
        this.writeDelayMillis = writeDelaySeconds == -1 ? -1L : (long)writeDelaySeconds * 1000L;
        this.removeDelayMillis = writeDelaySeconds > 0 ? concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS + (long)writeDelaySeconds : concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS;
        this.loader = mapStoreWrapper == null || !mapStoreWrapper.isMapLoader() ? null : mapStoreWrapper;
        this.store = mapStoreWrapper == null || !mapStoreWrapper.isMapStore() ? null : mapStoreWrapper;
        NearCacheConfig nearCacheConfig = mapConfig.getNearCacheConfig();
        if (nearCacheConfig == null) {
            this.nearCache = null;
        } else {
            NearCache nearCache = new NearCache(this, SortedHashMap.getOrderingTypeByName(nearCacheConfig.getEvictionPolicy()), nearCacheConfig.getMaxSize(), (long)nearCacheConfig.getTimeToLiveSeconds() * 1000L, (long)nearCacheConfig.getMaxIdleSeconds() * 1000L, nearCacheConfig.isInvalidateOnChange());
            NearCache anotherNearCache = concurrentMapManager.mapCaches.putIfAbsent(name, nearCache);
            if (anotherNearCache != null) {
                nearCache = anotherNearCache;
            }
            this.nearCache = nearCache;
        }
        MergePolicy mergePolicyTemp = null;
        String mergePolicyName = mapConfig.getMergePolicy();
        if (mergePolicyName != null && !"hz.NO_MERGE".equalsIgnoreCase(mergePolicyName) && (mergePolicyConfig = this.node.getConfig().getMergePolicyConfig(mapConfig.getMergePolicy())) != null && (mergePolicyTemp = mergePolicyConfig.getImplementation()) == null) {
            String mergeClassName = mergePolicyConfig.getClassName();
            try {
                mergePolicyTemp = (MergePolicy)Serializer.classForName(this.node.getConfig().getClassLoader(), mergeClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.mergePolicy = mergePolicyTemp;
        this.creationTime = System.currentTimeMillis();
    }

    public Object getInitLock() {
        return this.initLock;
    }

    boolean isUserMap() {
        return !this.name.startsWith("c:__hz_");
    }

    final boolean isNotLocked(Request request) {
        boolean result;
        boolean bl = result = this.lockEntireMap == null || !this.lockEntireMap.isLocked() || this.lockEntireMap.isLockedBy(request.lockAddress, request.lockThreadId);
        if (!result) {
            System.out.println(this.thisAddress + " and caller is " + request.caller);
            System.out.println(this.lockEntireMap + " LOCKED !! " + (Object)((Object)request.operation));
        }
        return result;
    }

    final boolean overCapacity(Request request) {
        if (this.maxSizePolicy.overCapacity()) {
            Record record;
            boolean addOp;
            boolean bl = addOp = request.operation == ClusterOperation.CONCURRENT_MAP_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT;
            if (addOp && (record = this.getRecord(request)) == null) {
                if (this.cleanupState == CleanupState.NONE) {
                    this.cleanupState = CleanupState.SHOULD_CLEAN;
                }
                return true;
            }
        }
        return false;
    }

    public void lockMap(Request request) {
        if (request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_MAP) {
            if (this.lockEntireMap == null) {
                this.lockEntireMap = new DistributedLock();
            }
            if (!this.lockEntireMap.isLockedBy(request.lockAddress, request.lockThreadId)) {
                this.lockEntireMap.lock(request.lockAddress, request.lockThreadId);
            }
            request.clearForResponse();
            request.response = Boolean.TRUE;
        } else if (request.operation == ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP) {
            request.response = this.lockEntireMap != null ? Boolean.valueOf(this.lockEntireMap.unlock(request.lockAddress, request.lockThreadId)) : Boolean.TRUE;
        }
    }

    public void addIndex(Expression expression, boolean ordered, int attributeIndex) {
        this.mapIndexService.addIndex(expression, ordered, attributeIndex);
    }

    public Record getRecord(Data key) {
        return (Record)this.mapRecords.get(key);
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public void own(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Key cannot be null " + req.key);
        }
        if (req.value == null && (this.isSet() || this.isList())) {
            req.value = new Data();
        }
        Record record = this.toRecord(req);
        if (req.ttl <= 0L || req.timeout <= 0L) {
            record.setInvalid();
        } else {
            record.setExpirationTime(req.ttl);
            record.setMaxIdle(req.timeout);
        }
        this.markAsActive(record);
        if (this.store != null && this.writeDelayMillis > 0L) {
            this.markAsDirty(record);
        }
        if (req.value != null) {
            this.updateIndexes(record);
        }
        record.setVersion(req.version);
    }

    public boolean isMultiMap() {
        return this.instanceType == Instance.InstanceType.MULTIMAP;
    }

    public boolean isSet() {
        return this.instanceType == Instance.InstanceType.SET;
    }

    public boolean isList() {
        return this.instanceType == Instance.InstanceType.LIST;
    }

    public boolean isMap() {
        return this.instanceType == Instance.InstanceType.MAP;
    }

    public boolean backup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be 0: " + req.key);
        }
        if (this.isMap() || this.isSet()) {
            return this.backupOneValue(req);
        }
        return this.backupMultiValue(req);
    }

    private boolean backupOneValue(Request req) {
        Record record = this.getRecord(req);
        if (record != null && record.isActive() && req.version < record.getVersion()) {
            return false;
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
        }
        return true;
    }

    private boolean backupMultiValue(Request req) {
        Record record = this.getRecord(req);
        if (record != null) {
            record.setActive();
            if (req.version > record.getVersion() + 1L) {
                Request reqCopy = req.hardCopy();
                record.addBackupOp(new VersionedBackupOp(this, reqCopy));
                return true;
            }
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
            record.runBackupOps();
        }
        return true;
    }

    public void doBackup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be zero! " + req.key);
        }
        if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_PUT) {
            Record record = this.toRecord(req);
            this.markAsActive(record);
            record.setVersion(req.version);
            if (req.indexes != null) {
                if (req.indexTypes == null) {
                    throw new RuntimeException("index types cannot be null!");
                }
                if (req.indexes.length != req.indexTypes.length) {
                    throw new RuntimeException("index and type lengths do not match");
                }
                record.setIndexes(req.indexes, req.indexTypes);
            }
            if (req.ttl > 0L && req.ttl < Long.MAX_VALUE) {
                record.setExpirationTime(req.ttl);
                this.ttlPerRecord = true;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE) {
            Record record = this.getRecord(req);
            if (record != null && record.isActive()) {
                if (record.getCopyCount() > 0) {
                    record.decrementCopyCount();
                }
                this.markAsEvicted(record);
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK) {
            Record rec = this.toRecord(req);
            if (rec.getVersion() == 0L) {
                rec.setVersion(req.version);
            }
            if (rec.getLockCount() == 0 && rec.valueCount() == 0) {
                this.markAsEvicted(rec);
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_ADD) {
            this.add(req, true);
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI) {
            Record record = this.getRecord(req);
            if (record != null) {
                if (req.value == null) {
                    this.markAsEvicted(record);
                } else {
                    Set<Data> multiValues;
                    if (record.containsValue(req.value) && (multiValues = record.getMultiValues()) != null) {
                        multiValues.remove(req.value);
                    }
                    if (record.valueCount() == 0) {
                        this.markAsEvicted(record);
                    }
                }
            }
        } else {
            this.logger.log(Level.SEVERE, "Unknown backup operation " + (Object)((Object)req.operation));
        }
    }

    private void purgeIfNotOwnedOrBackup(Collection<Record> records) {
        HashMap<Address, Integer> mapMemberDistances = new HashMap<Address, Integer>();
        for (Record record : records) {
            int distance;
            Address owner;
            Block block = this.blocks[record.getBlockId()];
            boolean owned = this.thisAddress.equals(block.getOwner());
            if (owned || block.isMigrating() || (owner = block.isMigrating() ? block.getMigrationAddress() : block.getOwner()) == null || this.thisAddress.equals(owner)) continue;
            Integer d = (Integer)mapMemberDistances.get(owner);
            if (d == null) {
                distance = this.concurrentMapManager.getDistance(owner, this.thisAddress);
                mapMemberDistances.put(owner, distance);
            } else {
                distance = d;
            }
            if (distance <= this.getBackupCount()) continue;
            this.mapRecords.remove(record.getKeyData());
        }
    }

    Record getOwnedRecord(Data key) {
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(this.concurrentMapManager.getBlockId(key));
        Member ownerNow = partition.getOwner();
        if (ownerNow != null && !partition.isMigrating() && ownerNow.localMember()) {
            return this.getRecord(key);
        }
        return null;
    }

    boolean isBackup(Record record) {
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
        Member ownerNow = partition.getOwner();
        Member ownerEventual = partition.getEventualOwner();
        if (ownerEventual != null && ownerNow != null && !ownerNow.localMember()) {
            int distance = this.node.getClusterImpl().getDistanceFrom(ownerEventual);
            return distance != -1 && distance <= this.getBackupCount();
        }
        return false;
    }

    public int size() {
        if (this.maxIdle > 0L || this.ttl > 0L || this.ttlPerRecord || this.isList() || this.isMultiMap()) {
            long now = System.currentTimeMillis();
            int size = 0;
            Collection<Record> records = this.mapIndexService.getOwnedRecords();
            for (Record record : records) {
                if (!record.isActive() || !record.isValid(now)) continue;
                size += record.valueCount();
            }
            return size;
        }
        return this.mapIndexService.size();
    }

    public boolean hasOwned(long blockId) {
        Collection records = this.mapRecords.values();
        for (Record record : records) {
            if ((long)record.getBlockId() != blockId || !record.isActive()) continue;
            return true;
        }
        return false;
    }

    public int valueCount(Data key) {
        long now = System.currentTimeMillis();
        int count = 0;
        Record record = (Record)this.mapRecords.get(key);
        if (record != null && record.isValid(now)) {
            count = record.valueCount();
        }
        return count;
    }

    public boolean contains(Request req) {
        Data key = req.key;
        Data value = req.value;
        if (key != null) {
            Record record = this.getRecord(req);
            if (record == null) {
                return false;
            }
            if (record.isActive() && record.isValid()) {
                if (value == null) {
                    return record.valueCount() > 0;
                }
                return record.containsValue(value);
            }
        } else {
            Collection records = this.mapRecords.values();
            for (Record record : records) {
                Block block;
                long now = System.currentTimeMillis();
                if (!record.isActive() || !record.isValid(now) || !this.thisAddress.equals((block = this.blocks[record.getBlockId()]).getOwner()) || !record.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    public void containsValue(Request request) {
        if (this.isMultiMap()) {
            boolean found = false;
            Collection records = this.mapRecords.values();
            for (Record record : records) {
                Block block;
                long now = System.currentTimeMillis();
                if (!record.isActive() || !record.isValid(now) || !this.thisAddress.equals((block = this.blocks[record.getBlockId()]).getOwner()) || !record.containsValue(request.value)) continue;
                found = true;
            }
            request.response = found;
        } else {
            request.response = this.mapIndexService.containsValue(request.value);
        }
    }

    public CMapEntry getMapEntry(Request req) {
        Record record = this.getRecord(req);
        if (record == null || !record.isActive() || !record.isValid()) {
            return null;
        }
        return new CMapEntry(record.getCost(), record.getExpirationTime(), record.getLastAccessTime(), record.getLastUpdateTime(), record.getCreationTime(), record.getLastStoredTime(), record.getVersion(), record.getHits(), true);
    }

    public Data get(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return null;
        }
        if (!record.isActive()) {
            return null;
        }
        if (!record.isValid() && record.isEvictable()) {
            return null;
        }
        record.setLastAccessed();
        Data data = record.getValueData();
        Data returnValue = null;
        if (data != null) {
            returnValue = data;
        } else if (record.getMultiValues() != null && record.getMultiValues().size() > 0) {
            Values values = new Values(record.getMultiValues());
            returnValue = IOUtil.toData(values);
        }
        return returnValue;
    }

    public boolean add(Request req, boolean backup) {
        Record record = this.getRecord(req);
        if (record == null) {
            record = this.toRecord(req);
        } else if (record.isActive() && req.operation == ClusterOperation.CONCURRENT_MAP_ADD_TO_SET) {
            return false;
        }
        record.setActive(true);
        record.incrementVersion();
        record.incrementCopyCount();
        if (!backup) {
            this.updateIndexes(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_ADDED, null, record, req.caller);
        }
        return true;
    }

    void lock(Request request) {
        Data reqValue = request.value;
        request.value = null;
        Record rec = this.concurrentMapManager.ensureRecord(request);
        if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET) {
            if (reqValue == null) {
                request.value = rec.getValueData();
                if (rec.getMultiValues() != null) {
                    Values values = new Values(rec.getMultiValues());
                    request.value = IOUtil.toData(values);
                }
            } else {
                request.value = !rec.containsValue(reqValue) ? null : reqValue;
            }
        }
        rec.lock(request.lockThreadId, request.lockAddress);
        rec.incrementVersion();
        request.version = rec.getVersion();
        request.lockCount = rec.getLockCount();
        this.markAsActive(rec);
        request.response = Boolean.TRUE;
    }

    void unlock(Record record) {
        record.clearLock();
        this.fireScheduledActions(record);
    }

    void fireScheduledActions(Record record) {
        this.concurrentMapManager.checkServiceThread();
        if (record.getLockCount() == 0) {
            record.clearLock();
            while (record.hasScheduledAction()) {
                ScheduledAction sa = record.getScheduledActions().remove(0);
                this.node.clusterManager.deregisterScheduledAction(sa);
                if (!sa.expired()) {
                    sa.consume();
                    if (!record.isLocked()) continue;
                    return;
                }
                sa.onExpire();
            }
        }
    }

    public void onMigrate(Record record) {
        if (record == null) {
            return;
        }
        List<ScheduledAction> lsScheduledActions = record.getScheduledActions();
        if (lsScheduledActions != null && lsScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = lsScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (sa.isValid() && !sa.expired()) {
                    sa.onMigrate();
                }
                sa.setValid(false);
                this.node.clusterManager.deregisterScheduledAction(sa);
                it.remove();
            }
        }
    }

    public void onDisconnect(Address deadAddress) {
        if (deadAddress == null) {
            return;
        }
        if (this.lockEntireMap != null && deadAddress.equals(this.lockEntireMap.getLockAddress())) {
            this.lockEntireMap = null;
        }
    }

    public void onDisconnect(Record record, Address deadAddress) {
        if (record == null || deadAddress == null) {
            return;
        }
        List<ScheduledAction> lsScheduledActions = record.getScheduledActions();
        if (lsScheduledActions != null && lsScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = lsScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (!deadAddress.equals(sa.getRequest().caller)) continue;
                this.node.clusterManager.deregisterScheduledAction(sa);
                sa.setValid(false);
                it.remove();
            }
        }
        if (record.getLockCount() > 0 && deadAddress.equals(record.getLockAddress())) {
            this.unlock(record);
        }
    }

    public boolean removeMulti(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return false;
        }
        boolean removed = false;
        if (req.value == null) {
            removed = true;
            this.markAsRemoved(record);
        } else if (record.containsValue(req.value) && record.getMultiValues() != null) {
            removed = record.getMultiValues().remove(req.value);
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        if (removed) {
            record.incrementVersion();
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKeyData(), null, req.value, record.getListeners(), req.caller);
            this.logger.log(Level.FINEST, record.getValueData() + " RemoveMulti " + record.getMultiValues());
        }
        req.version = record.getVersion();
        if (record.valueCount() == 0) {
            this.markAsRemoved(record);
        }
        return removed;
    }

    public boolean putMulti(Request req) {
        Record record = this.getRecord(req);
        boolean added = true;
        if (record == null) {
            record = this.toRecord(req);
        } else {
            if (!record.isActive()) {
                this.markAsActive(record);
            }
            if (record.containsValue(req.value)) {
                added = false;
            }
        }
        if (added) {
            Data value = req.value;
            this.updateIndexes(record);
            record.addValue(value);
            record.incrementVersion();
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_ADDED, record.getKeyData(), null, value, record.getListeners(), req.caller);
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        req.clearForResponse();
        req.version = record.getVersion();
        return added;
    }

    public void doAtomic(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            record = this.createNewRecord(req.key, IOUtil.toData(0L));
            this.mapRecords.put(req.key, record);
        } else if (record.getValue() == null) {
            record.setValue(IOUtil.toData(0L));
        }
        if (req.operation == ClusterOperation.ATOMIC_NUMBER_GET_AND_SET) {
            req.response = record.getValueData();
            record.setValue(IOUtil.toData(req.longValue));
        } else if (req.operation == ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET) {
            record.setValue(IOUtil.addDelta(record.getValueData(), req.longValue));
            req.response = record.getValueData();
        } else if (req.operation == ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD) {
            req.response = record.getValueData();
            record.setValue(IOUtil.addDelta(record.getValueData(), req.longValue));
        } else if (req.operation == ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET) {
            if (record.getValueData().equals(req.value)) {
                record.setValue(IOUtil.toData(req.longValue));
                req.response = Boolean.TRUE;
            } else {
                req.response = Boolean.FALSE;
            }
            req.value = null;
        }
    }

    public void doSemaphore(Request request) {
        Record record = this.getRecord(request);
        if (record == null) {
            record = this.createNewRecord(request.key, IOUtil.toData(1));
            this.mapRecords.put(request.key, record);
        }
        Integer total = (Integer)IOUtil.toObject(request.value);
        Integer available = (Integer)IOUtil.toObject(record.getValueData());
        if (request.operation == ClusterOperation.SEMAPHORE_ACQUIRE) {
            while (total > 0) {
                while (available <= 0) {
                    available = (Integer)IOUtil.toObject(record.getValueData());
                    if (total <= 0 || available != 0) continue;
                    request.response = total;
                    return;
                }
                record.setValue(IOUtil.addDelta(record.getValueData(), -1));
                available = (Integer)IOUtil.toObject(record.getValueData());
                Integer n = total;
                Integer n2 = total = Integer.valueOf(total - 1);
                request.response = 0;
            }
        } else if (request.operation == ClusterOperation.SEMAPHORE_RELEASE) {
            while (total > 0) {
                record.setValue(IOUtil.addDelta(record.getValueData(), 1));
                available = (Integer)IOUtil.toObject(record.getValueData());
                Integer n = total;
                Integer n3 = total = Integer.valueOf(total - 1);
            }
            request.response = available;
        } else if (request.operation == ClusterOperation.SEMAPHORE_AVAILABLE_PERIMITS) {
            request.response = available;
        } else if (request.operation == ClusterOperation.SEMAPHORE_DRAIN_PERIMITS) {
            while (available > 0) {
                record.setValue(IOUtil.addDelta(record.getValueData(), -1));
                available = (Integer)IOUtil.toObject(record.getValueData());
            }
            request.response = Boolean.TRUE;
        }
    }

    public void put(Request req) {
        Record record;
        long now = System.currentTimeMillis();
        boolean sendEvictEvent = false;
        Record evictedRecord = null;
        if (req.value == null) {
            req.value = new Data();
        }
        if ((record = this.getRecord(req)) != null && !record.isValid(now)) {
            if (record.isActive() && record.isEvictable()) {
                sendEvictEvent = true;
                evictedRecord = this.createNewRecord(record.getKeyData(), record.getValueData());
            }
            record.setValue(null);
            record.setMultiValues(null);
        }
        if (req.operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT) {
            if (record != null && record.isActive() && record.isValid(now) && record.getValueData() != null) {
                req.clearForResponse();
                req.response = record.getValueData();
                return;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL) {
            if (record == null || !record.isActive() || !record.isValid(now) || record.getValueData() == null) {
                return;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME) {
            if (record == null || !record.isActive() || !record.isValid(now)) {
                req.response = Boolean.FALSE;
                return;
            }
            MultiData multiData = (MultiData)IOUtil.toObject(req.value);
            if (multiData == null || multiData.size() != 2) {
                throw new RuntimeException("Illegal replaceIfSame argument: " + multiData);
            }
            Data expectedOldValue = multiData.getData(0);
            req.value = multiData.getData(1);
            if (!expectedOldValue.equals(record.getValueData())) {
                req.response = Boolean.FALSE;
                return;
            }
        }
        Data oldValue = null;
        if (record == null) {
            record = this.createNewRecord(req.key, req.value);
            this.mapRecords.put(req.key, record);
        } else {
            this.markAsActive(record);
            oldValue = record.isValid(now) ? record.getValueData() : null;
            record.setValue(req.value);
            record.incrementVersion();
            record.setLastUpdated();
        }
        if (req.ttl > 0L && req.ttl < Long.MAX_VALUE) {
            record.setExpirationTime(req.ttl);
            this.ttlPerRecord = true;
        }
        if (sendEvictEvent) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_EVICTED, null, evictedRecord, req.caller);
        }
        if (oldValue == null) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_ADDED, null, record, req.caller);
        } else {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_UPDATED, oldValue, record, req.caller);
        }
        if (req.txnId != -1L || req.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
            this.unlock(record);
        }
        record.setIndexes(req.indexes, req.indexTypes);
        this.updateIndexes(record);
        this.markAsDirty(record);
        req.clearForResponse();
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        req.response = req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME || req.operation == ClusterOperation.CONCURRENT_MAP_SET ? Boolean.TRUE : oldValue;
    }

    boolean isMapForQueue() {
        return this.mapForQueue;
    }

    void sendKeyToMaster(Data key) {
        String queueName = this.name.substring(2);
        if (this.concurrentMapManager.isMaster()) {
            this.node.blockingQueueManager.doAddKey(queueName, key, Integer.MAX_VALUE);
        } else {
            Packet packet = this.concurrentMapManager.obtainPacket();
            packet.name = queueName;
            packet.setKey(key);
            packet.operation = ClusterOperation.BLOCKING_OFFER_KEY;
            boolean sent = this.concurrentMapManager.send(packet, this.concurrentMapManager.getMasterAddress());
        }
    }

    private void executeStoreUpdate(final Set<Record> dirtyRecords) {
        if (dirtyRecords.size() > 0) {
            this.concurrentMapManager.storeExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        HashSet<Object> keysToDelete = new HashSet<Object>();
                        HashSet<Record> toStore = new HashSet<Record>();
                        HashMap<Object, Object> updates = new HashMap<Object, Object>();
                        for (Record dirtyRecord : dirtyRecords) {
                            if (!dirtyRecord.isActive()) {
                                keysToDelete.add(dirtyRecord.getKey());
                                continue;
                            }
                            toStore.add(dirtyRecord);
                            updates.put(dirtyRecord.getKey(), dirtyRecord.getValue());
                        }
                        if (keysToDelete.size() == 1) {
                            CMap.this.store.delete(keysToDelete.iterator().next());
                        } else if (keysToDelete.size() > 1) {
                            CMap.this.store.deleteAll(keysToDelete);
                        }
                        if (updates.size() == 1) {
                            Map.Entry entry = updates.entrySet().iterator().next();
                            CMap.this.store.store(entry.getKey(), entry.getValue());
                        } else if (updates.size() > 1) {
                            CMap.this.store.storeAll(updates);
                        }
                        for (Record stored : toStore) {
                            stored.setLastStoredTime(System.currentTimeMillis());
                        }
                    }
                    catch (Exception e) {
                        for (Record dirtyRecord : dirtyRecords) {
                            dirtyRecord.setDirty(true);
                        }
                    }
                }
            });
        }
    }

    LocalMapStatsImpl getLocalMapStats() {
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        long now = System.currentTimeMillis();
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long markedAsRemovedEntryCount = 0L;
        long dirtyCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryMemoryCost = 0L;
        long markedAsRemovedMemoryCost = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        long lockWaitCount = 0L;
        ClusterImpl clusterImpl = this.node.getClusterImpl();
        Collection records = this.mapRecords.values();
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        for (Record record : records) {
            if (!record.isActive() || !record.isValid(now)) {
                ++markedAsRemovedEntryCount;
                markedAsRemovedMemoryCost += record.getCost();
                continue;
            }
            PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
            Member owner = partition.getOwner();
            if (owner == null || partition.isMigrating()) continue;
            boolean owned = owner.localMember();
            if (owned) {
                if (record.getLastStoredTime() < Math.max(record.getLastUpdateTime(), record.getCreationTime())) {
                    ++dirtyCount;
                }
                ownedEntryCount += (long)record.valueCount();
                ownedEntryMemoryCost += record.getCost();
                localMapStats.setLastAccessTime(record.getLastAccessTime());
                localMapStats.setLastUpdateTime(record.getLastUpdateTime());
                hits += (long)record.getHits();
                if (!record.isLocked()) continue;
                ++lockedEntryCount;
                lockWaitCount += (long)record.getScheduledActionCount();
                continue;
            }
            Member ownerEventual = partition.getEventualOwner();
            boolean backup = false;
            if (ownerEventual != null && !owner.localMember()) {
                int distance = this.node.getClusterImpl().getDistanceFrom(ownerEventual, true);
                boolean bl = backup = distance != -1 && distance <= this.getBackupCount();
            }
            if (backup && !this.shouldPurgeRecord(record, now)) {
                backupEntryCount += (long)record.valueCount();
                backupEntryMemoryCost += record.getCost();
                continue;
            }
            ++markedAsRemovedEntryCount;
            markedAsRemovedMemoryCost += record.getCost();
        }
        localMapStats.setDirtyEntryCount(CMap.zeroOrPositive(dirtyCount));
        localMapStats.setMarkedAsRemovedEntryCount(CMap.zeroOrPositive(markedAsRemovedEntryCount));
        localMapStats.setMarkedAsRemovedMemoryCost(CMap.zeroOrPositive(markedAsRemovedMemoryCost));
        localMapStats.setLockWaitCount(CMap.zeroOrPositive(lockWaitCount));
        localMapStats.setLockedEntryCount(CMap.zeroOrPositive(lockedEntryCount));
        localMapStats.setHits(CMap.zeroOrPositive(hits));
        localMapStats.setOwnedEntryCount(CMap.zeroOrPositive(ownedEntryCount));
        localMapStats.setBackupEntryCount(CMap.zeroOrPositive(backupEntryCount));
        localMapStats.setOwnedEntryMemoryCost(CMap.zeroOrPositive(ownedEntryMemoryCost));
        localMapStats.setBackupEntryMemoryCost(CMap.zeroOrPositive(backupEntryMemoryCost));
        localMapStats.setLastEvictionTime(CMap.zeroOrPositive(clusterImpl.getClusterTimeFor(this.lastEvictionTime)));
        localMapStats.setCreationTime(CMap.zeroOrPositive(clusterImpl.getClusterTimeFor(this.creationTime)));
        return localMapStats;
    }

    private static long zeroOrPositive(long value) {
        return value > 0L ? value : 0L;
    }

    void evict(int percentage) {
        long now = System.currentTimeMillis();
        Collection records = this.mapRecords.values();
        ComparatorWrapper comparator = this.evictionComparator;
        if (comparator == null) {
            comparator = new ComparatorWrapper(LRU_COMPARATOR);
        }
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        TreeSet<MapEntry> sortedRecords = new TreeSet<MapEntry>(new ComparatorWrapper(comparator));
        HashSet<Record> recordsToEvict = new HashSet<Record>();
        for (Record record : records) {
            boolean owned;
            PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
            Member member = partition.getOwner();
            if (member == null || partition.isMigrating() || !(owned = member.localMember()) || this.store != null && this.writeDelayMillis > 0L && record.isDirty() || this.shouldPurgeRecord(record, now)) continue;
            if (record.isActive() && !record.isValid(now)) {
                recordsToEvict.add(record);
                continue;
            }
            if (!record.isActive() || !record.isEvictable()) continue;
            sortedRecords.add(record);
        }
        int numberOfRecordsToEvict = sortedRecords.size() * percentage / 100;
        int evictedCount = 0;
        for (Record record : sortedRecords) {
            recordsToEvict.add(record);
            if (++evictedCount < numberOfRecordsToEvict) continue;
            break;
        }
        this.executeEviction(recordsToEvict);
    }

    void startCleanup(boolean forced) {
        long now = System.currentTimeMillis();
        if (this.nearCache != null) {
            this.nearCache.evict(now, false);
        }
        HashSet<Record> recordsDirty = new HashSet<Record>();
        HashSet<Record> recordsUnknown = new HashSet<Record>();
        HashSet<Record> recordsToPurge = new HashSet<Record>();
        HashSet<Record> recordsToEvict = new HashSet<Record>();
        TreeSet<MapEntry> sortedRecords = new TreeSet<MapEntry>(new ComparatorWrapper(this.evictionComparator));
        Collection records = this.mapRecords.values();
        boolean overCapacity = this.maxSizePolicy.overCapacity();
        boolean evictionAware = this.evictionComparator != null && overCapacity;
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionManager.partitionServiceImpl;
        int recordsStillOwned = 0;
        int backupPurgeCount = 0;
        for (Record record : records) {
            PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
            Member member = partition.getOwner();
            if (member == null || partition.isMigrating()) continue;
            boolean owned = member.localMember();
            if (owned) {
                if (this.store != null && this.writeDelayMillis > 0L && record.isDirty()) {
                    if (now <= record.getWriteTime()) continue;
                    recordsDirty.add(record);
                    record.setDirty(false);
                    continue;
                }
                if (this.shouldPurgeRecord(record, now)) {
                    recordsToPurge.add(record);
                    continue;
                }
                if (record.isActive() && !record.isValid(now)) {
                    recordsToEvict.add(record);
                    continue;
                }
                if (evictionAware && record.isActive() && record.isEvictable()) {
                    sortedRecords.add(record);
                    ++recordsStillOwned;
                    continue;
                }
                ++recordsStillOwned;
                continue;
            }
            Member ownerEventual = partition.getEventualOwner();
            boolean backup = false;
            if (ownerEventual != null && member != null && !member.localMember()) {
                int distance = this.node.getClusterImpl().getDistanceFrom(ownerEventual, true);
                boolean bl = backup = distance != -1 && distance <= this.getBackupCount();
            }
            if (backup) {
                if (!this.shouldPurgeRecord(record, now)) continue;
                recordsToPurge.add(record);
                ++backupPurgeCount;
                continue;
            }
            recordsUnknown.add(record);
        }
        if (evictionAware && (forced || overCapacity)) {
            int numberOfRecordsToEvict = (int)((float)recordsStillOwned * this.evictionRate);
            int evictedCount = 0;
            for (Record record : sortedRecords) {
                if (!record.isActive() || !record.isEvictable()) continue;
                recordsToEvict.add(record);
                if (++evictedCount < numberOfRecordsToEvict) continue;
                break;
            }
        }
        Level levelLog = this.concurrentMapManager.LOG_STATE ? Level.INFO : Level.FINEST;
        this.logger.log(levelLog, this.name + " Cleanup " + ", dirty:" + recordsDirty.size() + ", purge:" + recordsToPurge.size() + ", evict:" + recordsToEvict.size() + ", unknown:" + recordsUnknown.size() + ", stillOwned:" + recordsStillOwned + ", backupPurge:" + backupPurgeCount);
        this.executeStoreUpdate(recordsDirty);
        this.executeEviction(recordsToEvict);
        this.executePurge(recordsToPurge);
        this.executePurgeUnknowns(recordsUnknown);
    }

    private void executePurgeUnknowns(final Set<Record> recordsUnknown) {
        if (recordsUnknown.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    CMap.this.purgeIfNotOwnedOrBackup(recordsUnknown);
                }
            });
        }
    }

    private void executePurge(final Set<Record> recordsToPurge) {
        if (recordsToPurge.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    long now = System.currentTimeMillis();
                    for (Record recordToPurge : recordsToPurge) {
                        if (!CMap.this.shouldPurgeRecord(recordToPurge, now)) continue;
                        CMap.this.removeAndPurgeRecord(recordToPurge);
                    }
                }
            });
        }
    }

    boolean shouldPurgeRecord(Record record, long now) {
        return !record.isActive() && this.shouldRemove(record, now);
    }

    private void executeEviction(Collection<Record> lsRecordsToEvict) {
        if (lsRecordsToEvict != null && lsRecordsToEvict.size() > 0) {
            this.logger.log(Level.FINEST, lsRecordsToEvict.size() + " evicting");
            for (Record recordToEvict : lsRecordsToEvict) {
                this.concurrentMapManager.evictAsync(this.name, recordToEvict.getKeyData());
            }
        }
    }

    void fireInvalidation(Record record) {
        if (this.nearCache != null && this.nearCache.shouldInvalidateOnChange()) {
            for (MemberImpl member : this.concurrentMapManager.lsMembers) {
                if (member.localMember() || member.getAddress() == null) continue;
                Packet packet = this.concurrentMapManager.obtainPacket();
                packet.name = this.getName();
                packet.setKey(record.getKeyData());
                packet.operation = ClusterOperation.CONCURRENT_MAP_INVALIDATE;
                boolean sent = this.concurrentMapManager.send(packet, member.getAddress());
                if (sent) continue;
                this.concurrentMapManager.releasePacket(packet);
            }
            this.nearCache.invalidate(record.getKeyData());
        }
    }

    Record getRecord(Request req) {
        if (req.record == null || !req.record.isActive()) {
            req.record = (Record)this.mapRecords.get(req.key);
        }
        return req.record;
    }

    Record toRecord(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            if (this.isMultiMap()) {
                record = this.createNewRecord(req.key, null);
                if (req.value != null) {
                    record.addValue(req.value);
                }
            } else {
                record = this.createNewRecord(req.key, req.value);
            }
            this.mapRecords.put(req.key, record);
        } else if (req.value != null) {
            if (this.isMultiMap()) {
                record.addValue(req.value);
            } else {
                record.setValue(req.value);
            }
        }
        record.setIndexes(req.indexes, req.indexTypes);
        record.setCopyCount((int)req.longValue);
        if (req.lockCount >= 0) {
            DistributedLock lock = new DistributedLock(req.lockAddress, req.lockThreadId, req.lockCount);
            record.setLock(lock);
        }
        return record;
    }

    public boolean removeItem(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return false;
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        boolean removed = false;
        if (record.getCopyCount() > 0) {
            record.decrementCopyCount();
            removed = true;
        } else if (record.getValueData() != null) {
            removed = true;
        } else if (record.getMultiValues() != null) {
            removed = true;
        }
        if (removed) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_REMOVED, null, record, req.caller);
            record.incrementVersion();
        }
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        this.markAsRemoved(record);
        return true;
    }

    boolean evict(Request req) {
        Record record = this.getRecord(req.key);
        long now = System.currentTimeMillis();
        if (record != null && record.isActive() && record.valueCount() > 0) {
            this.concurrentMapManager.checkServiceThread();
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_EVICTED, null, record, req.caller);
            record.incrementVersion();
            this.markAsEvicted(record);
            req.clearForResponse();
            req.version = record.getVersion();
            req.longValue = record.getCopyCount();
            this.lastEvictionTime = now;
            return true;
        }
        return false;
    }

    public void remove(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            req.clearForResponse();
            return;
        }
        if (req.txnId != -1L) {
            this.unlock(record);
        }
        if (!record.isActive()) {
            return;
        }
        if (!record.isValid() && record.isEvictable()) {
            return;
        }
        if (req.value != null && record.getValueData() != null && !record.getValueData().equals(req.value)) {
            return;
        }
        Data oldValue = record.getValueData();
        if (oldValue == null && record.getMultiValues() != null && record.getMultiValues().size() > 0) {
            Values values = new Values(record.getMultiValues());
            oldValue = IOUtil.toData(values);
        }
        if (oldValue != null) {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKeyData(), null, oldValue, record.getListeners(), req.caller);
            record.incrementVersion();
        }
        this.markAsRemoved(record);
        req.clearForResponse();
        req.version = record.getVersion();
        req.longValue = record.getCopyCount();
        req.response = oldValue;
    }

    void reset() {
        for (Record record : this.mapRecords.values()) {
            List<ScheduledAction> lsScheduledActions;
            if (!record.hasScheduledAction() || (lsScheduledActions = record.getScheduledActions()) == null) continue;
            for (ScheduledAction scheduledAction : lsScheduledActions) {
                scheduledAction.setValid(false);
            }
        }
        if (this.nearCache != null) {
            this.nearCache.reset();
        }
        this.mapRecords.clear();
        this.mapIndexService.clear();
        if (this.store != null && this.store instanceof MapStoreWrapper) {
            try {
                ((MapStoreWrapper)this.store).destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void markAsDirty(Record record) {
        if (!record.isDirty()) {
            record.setDirty(true);
            if (this.writeDelayMillis > 0L) {
                record.setWriteTime(System.currentTimeMillis() + this.writeDelayMillis);
            }
        }
    }

    void markAsActive(Record record) {
        long now = System.currentTimeMillis();
        if (!record.isActive() || !record.isValid(now)) {
            record.setActive();
            record.setCreationTime(now);
            record.setExpirationTime(this.ttl);
        }
    }

    boolean shouldRemove(Record record, long now) {
        return record.isRemovable() && now - record.getRemoveTime() > this.removeDelayMillis;
    }

    void markAsRemoved(Record record) {
        if (record.isActive()) {
            record.markRemoved();
        }
        record.setValue(null);
        record.setMultiValues(null);
        this.updateIndexes(record);
        this.markAsDirty(record);
    }

    void markAsEvicted(Record record) {
        if (record.isActive()) {
            record.markRemoved();
        }
        record.setValue(null);
        record.setMultiValues(null);
        this.updateIndexes(record);
    }

    void removeAndPurgeRecord(Record record) {
        this.mapRecords.remove(record.getKeyData());
        this.mapIndexService.remove(record);
    }

    void updateIndexes(Record record) {
        this.mapIndexService.index(record);
    }

    Record createNewRecord(Data key, Data value) {
        if (key == null || key.size() == 0) {
            throw new RuntimeException("Cannot create record from a 0 size key: " + key);
        }
        int blockId = this.concurrentMapManager.getBlockId(key);
        return new Record(this, blockId, key, value, this.ttl, this.maxIdle, this.concurrentMapManager.newRecordId());
    }

    public void addListener(Data key, Address address, boolean includeValue) {
        if (key == null || key.size() == 0) {
            this.mapListeners.put(address, includeValue);
        } else {
            Record rec = this.getRecord(key);
            if (rec == null) {
                rec = this.createNewRecord(key, null);
                this.mapRecords.put(key, rec);
            }
            rec.addListener(address, includeValue);
        }
    }

    public void removeListener(Data key, Address address) {
        if (key == null || key.size() == 0) {
            this.mapListeners.remove(address);
        } else {
            Record rec = this.getRecord(key);
            if (rec != null) {
                rec.removeListener(address);
            }
        }
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nCMap [");
        sbState.append(this.name);
        sbState.append("] r:");
        sbState.append(this.mapRecords.size());
        if (this.nearCache != null) {
            this.nearCache.appendState(sbState);
        }
        this.mapIndexService.appendState(sbState);
        for (Record record : this.mapRecords.values()) {
            if (!record.isLocked()) continue;
            sbState.append("\nLocked Record by " + record.getLock());
        }
    }

    public String toString() {
        return "CMap [" + this.getName() + "] size=" + this.size();
    }

    public String getName() {
        return this.name;
    }

    public MapIndexService getMapIndexService() {
        return this.mapIndexService;
    }

    public static class CMapEntry
    implements HazelcastInstanceAware,
    MapEntry,
    DataSerializable {
        private long cost = 0L;
        private long expirationTime = 0L;
        private long lastAccessTime = 0L;
        private long lastUpdateTime = 0L;
        private long lastStoredTime = 0L;
        private long creationTime = 0L;
        private long version = 0L;
        private int hits = 0;
        private boolean valid = true;
        private String name = null;
        private Object key = null;
        private Object value = null;
        private HazelcastInstance hazelcastInstance = null;

        public CMapEntry() {
        }

        public CMapEntry(long cost, long expirationTime, long lastAccessTime, long lastUpdateTime, long creationTime, long lastStoredTime, long version, int hits, boolean valid) {
            this.cost = cost;
            this.expirationTime = expirationTime;
            this.lastAccessTime = lastAccessTime;
            this.lastUpdateTime = lastUpdateTime;
            this.creationTime = creationTime;
            this.lastStoredTime = lastStoredTime;
            this.version = version;
            this.hits = hits;
            this.valid = valid;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeLong(this.cost);
            out.writeLong(this.expirationTime);
            out.writeLong(this.lastAccessTime);
            out.writeLong(this.lastUpdateTime);
            out.writeLong(this.creationTime);
            out.writeLong(this.lastStoredTime);
            out.writeLong(this.version);
            out.writeInt(this.hits);
            out.writeBoolean(this.valid);
        }

        public void readData(DataInput in) throws IOException {
            this.cost = in.readLong();
            this.expirationTime = in.readLong();
            this.lastAccessTime = in.readLong();
            this.lastUpdateTime = in.readLong();
            this.creationTime = in.readLong();
            this.lastStoredTime = in.readLong();
            this.version = in.readLong();
            this.hits = in.readInt();
            this.valid = in.readBoolean();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public void set(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public long getCost() {
            return this.cost;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public int getHits() {
            return this.hits;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getLastStoredTime() {
            return this.lastStoredTime;
        }

        public long getVersion() {
            return this.version;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            if (this.value == null) {
                FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
                this.value = ((MProxy)factory.getOrCreateProxyByName(this.name)).get(this.key);
            }
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
            ((MProxy)factory.getOrCreateProxyByName(this.name)).put(this.key, value);
            return oldValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CMapEntry cMapEntry = (CMapEntry)o;
            return !(this.key == null ? cMapEntry.key != null : !this.key.equals(cMapEntry.key)) && !(this.name == null ? cMapEntry.name != null : !this.name.equals(cMapEntry.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MapEntry");
            sb.append("{key=").append(this.key);
            sb.append(", valid=").append(this.valid);
            sb.append(", hits=").append(this.hits);
            sb.append(", version=").append(this.version);
            sb.append(", creationTime=").append(this.creationTime);
            sb.append(", lastUpdateTime=").append(this.lastUpdateTime);
            sb.append(", lastAccessTime=").append(this.lastAccessTime);
            sb.append(", expirationTime=").append(this.expirationTime);
            sb.append(", cost=").append(this.cost);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values
    implements Collection,
    DataSerializable {
        Collection<Data> lsValues = null;

        public Values() {
        }

        public Values(Collection<Data> values) {
            if (values != null) {
                this.lsValues = new ArrayList<Data>(values.size());
                for (Data data : values) {
                    if (data == null) continue;
                    this.lsValues.add(data);
                }
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Contains cannot have null argument.");
            }
            for (Object v : this) {
                if (!o.equals(v)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator(this.lsValues.iterator());
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.lsValues == null ? 0 : this.lsValues.size();
        }

        @Override
        public Object[] toArray() {
            if (this.size() == 0) {
                return null;
            }
            return this.toArray(new Object[this.size()]);
        }

        public Object[] toArray(Object[] a) {
            int size = this.size();
            if (size == 0) {
                return null;
            }
            if (a == null || a.length < size) {
                a = new Object[size];
            }
            Iterator<Data> it = this.lsValues.iterator();
            int index = 0;
            while (it.hasNext()) {
                a[index++] = IOUtil.toObject(it.next());
            }
            return a;
        }

        @Override
        public void readData(DataInput in) throws IOException {
            int size = in.readInt();
            this.lsValues = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = new Data();
                data.readData(in);
                this.lsValues.add(data);
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            int size = this.lsValues == null ? 0 : this.lsValues.size();
            out.writeInt(size);
            if (size > 0) {
                for (Data data : this.lsValues) {
                    data.writeData(out);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ValueIterator
        implements Iterator {
            final Iterator<Data> it;

            public ValueIterator(Iterator<Data> it) {
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Data value = this.it.next();
                return IOUtil.toObject(value);
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        }
    }

    class MaxSizePartitionsWidePolicy
    extends MaxSizePerJVMPolicy {
        MaxSizePartitionsWidePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
        }

        public int getMaxSize() {
            int maxSize = this.maxSizeConfig.getSize();
            if (maxSize == Integer.MAX_VALUE || maxSize == 0) {
                return Integer.MAX_VALUE;
            }
            if (CMap.this.node.getClusterImpl().getMembers().size() < 2) {
                return maxSize;
            }
            PartitionServiceImpl partitionService = CMap.this.concurrentMapManager.partitionManager.partitionServiceImpl;
            int partitionCount = partitionService.getPartitions().size();
            int ownedPartitionCount = partitionService.getOwnedPartitionCount();
            if (partitionCount < 1 || ownedPartitionCount < 1) {
                return maxSize;
            }
            return maxSize * ownedPartitionCount / partitionCount;
        }
    }

    class MaxSizeClusterWidePolicy
    extends MaxSizePerJVMPolicy {
        MaxSizeClusterWidePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
        }

        public int getMaxSize() {
            int maxSize = this.maxSizeConfig.getSize();
            int clusterMemberSize = CMap.this.node.getClusterImpl().getMembers().size();
            int memberCount = clusterMemberSize == 0 ? 1 : clusterMemberSize;
            return maxSize / memberCount;
        }
    }

    class MaxSizeHeapPercentagePolicy
    extends MaxSizePerJVMPolicy {
        MaxSizeHeapPercentagePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
        }

        public boolean overCapacity() {
            boolean over;
            long free;
            long total = Runtime.getRuntime().totalMemory();
            int usedPercentage = (int)((double)((total - (free = Runtime.getRuntime().freeMemory())) / total) * 100.0);
            boolean bl = over = usedPercentage > this.maxSizeConfig.getSize();
            if (over) {
                Runtime.getRuntime().gc();
            }
            return over;
        }
    }

    class MaxSizeHeapPolicy
    extends MaxSizePerJVMPolicy {
        long memoryLimit;

        MaxSizeHeapPolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
            this.memoryLimit = 0L;
            this.memoryLimit = maxSizeConfig.getSize() * 1000 * 1000;
        }

        public boolean overCapacity() {
            boolean over;
            boolean bl = over = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() > this.memoryLimit;
            if (over) {
                Runtime.getRuntime().gc();
            }
            return over;
        }
    }

    class MaxSizePerJVMPolicy
    implements MapMaxSizePolicy {
        protected final MaxSizeConfig maxSizeConfig;

        MaxSizePerJVMPolicy(MaxSizeConfig maxSizeConfig) {
            this.maxSizeConfig = maxSizeConfig;
        }

        public int getMaxSize() {
            return this.maxSizeConfig.getSize();
        }

        public boolean overCapacity() {
            return this.getMaxSize() <= CMap.this.mapIndexService.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComparatorWrapper
    implements Comparator<MapEntry> {
        final Comparator<MapEntry> comparator;

        ComparatorWrapper(Comparator<MapEntry> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(MapEntry o1, MapEntry o2) {
            int result = this.comparator.compare(o1, o2);
            if (result == 0) {
                Record r1 = (Record)o1;
                Record r2 = (Record)o2;
                return r1.getId() > r2.getId() ? 1 : -1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CleanupState {
        NONE,
        SHOULD_CLEAN,
        CLEANING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EvictionPolicy {
        LRU,
        LFU,
        NONE;

    }
}

