/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.mockito.Mockito;

@Ignore
public class TestUtil {
    public static boolean migratePartition(int partitionId, HazelcastInstance oldest, HazelcastInstance to) throws Exception {
        MemberImpl toMember;
        MemberImpl currentOwnerMember = (MemberImpl)TestUtil.getPartitionById(oldest.getPartitionService(), partitionId).getOwner();
        if (currentOwnerMember.equals(toMember = (MemberImpl)to.getCluster().getLocalMember())) {
            return false;
        }
        final ConcurrentMapManager concurrentMapManagerOldest = TestUtil.getConcurrentMapManager(oldest);
        final Address addressCurrentOwner = currentOwnerMember.getAddress();
        final Address addressNewOwner = toMember.getAddress();
        final int blockId = TestUtil.getPartitionById(oldest.getPartitionService(), partitionId).getPartitionId();
        final CountDownLatch migrationLatch = new CountDownLatch(2);
        MigrationListener migrationListener = new MigrationListener(){

            public void migrationCompleted(MigrationEvent migrationEvent) {
                if (migrationEvent.getPartitionId() == blockId && toMember.equals(migrationEvent.getNewOwner())) {
                    migrationLatch.countDown();
                }
            }

            public void migrationStarted(MigrationEvent migrationEvent) {
            }
        };
        oldest.getPartitionService().addMigrationListener(migrationListener);
        to.getPartitionService().addMigrationListener(migrationListener);
        concurrentMapManagerOldest.enqueueAndReturn(new Processable(){

            public void process() {
                Block blockToMigrate = new Block(blockId, addressCurrentOwner, addressNewOwner);
                concurrentMapManagerOldest.partitionManager.lsBlocksToMigrate.add(blockToMigrate);
                concurrentMapManagerOldest.partitionManager.initiateMigration();
            }
        });
        if (!migrationLatch.await(30L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Migration should get completed in 30 seconds!!");
        }
        junit.framework.Assert.assertEquals((Object)toMember, (Object)TestUtil.getPartitionById(oldest.getPartitionService(), partitionId).getOwner());
        junit.framework.Assert.assertEquals((Object)toMember, (Object)TestUtil.getPartitionById(to.getPartitionService(), partitionId).getOwner());
        return true;
    }

    public static boolean initiateMigration(int partitionId, final int completeWaitSeconds, HazelcastInstance oldest, HazelcastInstance from, HazelcastInstance to) throws Exception {
        MemberImpl toMember;
        MemberImpl currentOwnerMember = (MemberImpl)TestUtil.getPartitionById(oldest.getPartitionService(), partitionId).getOwner();
        if (currentOwnerMember.equals(toMember = (MemberImpl)to.getCluster().getLocalMember())) {
            return false;
        }
        final ConcurrentMapManager concurrentMapManagerOldest = TestUtil.getConcurrentMapManager(oldest);
        final ConcurrentMapManager concurrentMapManagerFrom = TestUtil.getConcurrentMapManager(from);
        final Address addressCurrentOwner = currentOwnerMember.getAddress();
        final Address addressNewOwner = toMember.getAddress();
        final int blockId = TestUtil.getPartitionById(oldest.getPartitionService(), partitionId).getPartitionId();
        final CountDownLatch migrationLatch = new CountDownLatch(2);
        MigrationListener migrationListener = new MigrationListener(){

            public void migrationCompleted(MigrationEvent migrationEvent) {
            }

            public void migrationStarted(MigrationEvent migrationEvent) {
                migrationLatch.countDown();
            }
        };
        from.getPartitionService().addMigrationListener(migrationListener);
        to.getPartitionService().addMigrationListener(migrationListener);
        concurrentMapManagerFrom.enqueueAndReturn(new Processable(){

            public void process() {
                concurrentMapManagerFrom.partitionManager.MIGRATION_COMPLETE_WAIT_SECONDS = completeWaitSeconds;
            }
        });
        concurrentMapManagerOldest.enqueueAndReturn(new Processable(){

            public void process() {
                Block blockToMigrate = new Block(blockId, addressCurrentOwner, addressNewOwner);
                concurrentMapManagerOldest.partitionManager.lsBlocksToMigrate.clear();
                concurrentMapManagerOldest.partitionManager.lsBlocksToMigrate.add(blockToMigrate);
                concurrentMapManagerOldest.partitionManager.initiateMigration();
            }
        });
        if (!migrationLatch.await(20L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Migration should get started in 20 seconds!!");
        }
        return true;
    }

    public static boolean migrateKey(Object key, HazelcastInstance oldest, HazelcastInstance to) throws Exception {
        MemberImpl toMember;
        MemberImpl currentOwnerMember = (MemberImpl)oldest.getPartitionService().getPartition(key).getOwner();
        if (currentOwnerMember.equals(toMember = (MemberImpl)to.getCluster().getLocalMember())) {
            return false;
        }
        final ConcurrentMapManager concurrentMapManagerOldest = TestUtil.getConcurrentMapManager(oldest);
        final Address addressCurrentOwner = currentOwnerMember.getAddress();
        final Address addressNewOwner = toMember.getAddress();
        final int blockId = oldest.getPartitionService().getPartition(key).getPartitionId();
        final CountDownLatch migrationLatch = new CountDownLatch(2);
        MigrationListener migrationListener = new MigrationListener(){

            public void migrationCompleted(MigrationEvent migrationEvent) {
                if (migrationEvent.getPartitionId() == blockId && migrationEvent.getNewOwner().equals(toMember)) {
                    migrationLatch.countDown();
                }
            }

            public void migrationStarted(MigrationEvent migrationEvent) {
            }
        };
        oldest.getPartitionService().addMigrationListener(migrationListener);
        to.getPartitionService().addMigrationListener(migrationListener);
        concurrentMapManagerOldest.enqueueAndReturn(new Processable(){

            public void process() {
                Block blockToMigrate = new Block(blockId, addressCurrentOwner, addressNewOwner);
                concurrentMapManagerOldest.partitionManager.lsBlocksToMigrate.add(blockToMigrate);
                concurrentMapManagerOldest.partitionManager.initiateMigration();
            }
        });
        if (!migrationLatch.await(20L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Migration should get completed in 20 seconds!!");
        }
        junit.framework.Assert.assertEquals((Object)toMember, (Object)oldest.getPartitionService().getPartition(key).getOwner());
        junit.framework.Assert.assertEquals((Object)toMember, (Object)to.getPartitionService().getPartition(key).getOwner());
        return true;
    }

    public static Node getNode(HazelcastInstance h) {
        FactoryImpl.HazelcastInstanceProxy hiProxy = (FactoryImpl.HazelcastInstanceProxy)h;
        return hiProxy.getFactory().node;
    }

    public static ConcurrentMapManager getConcurrentMapManager(HazelcastInstance h) {
        return TestUtil.getNode((HazelcastInstance)h).concurrentMapManager;
    }

    public static CMap mockCMap(String name) {
        FactoryImpl mockFactory = (FactoryImpl)Mockito.mock(FactoryImpl.class);
        Node node = new Node(mockFactory, new Config());
        node.serviceThread = Thread.currentThread();
        return new CMap(node.concurrentMapManager, "c:" + name);
    }

    public static CMap getCMap(HazelcastInstance h, String name) {
        ConcurrentMapManager concurrentMapManager = TestUtil.getConcurrentMapManager(h);
        String fullName = "c:" + name;
        return concurrentMapManager.getMap(fullName);
    }

    public static Partition getPartitionById(PartitionService partitionService, int partitionId) {
        for (Partition partition : partitionService.getPartitions()) {
            if (partition.getPartitionId() != partitionId) continue;
            return partition;
        }
        return null;
    }

    public static Record newRecord(CMap cmap, long recordId, Data key, Data value) {
        return new Record(cmap, 1, key, value, 0L, 0L, recordId);
    }

    public static Record newRecord(long recordId, Data key, Data value) {
        CMap cmap = (CMap)Mockito.mock(CMap.class);
        return TestUtil.newRecord(cmap, recordId, key, value);
    }

    public static Record newRecord(CMap cmap, long recordId, Object key, Object value) {
        return TestUtil.newRecord(cmap, recordId, IOUtil.toData(key), IOUtil.toData(value));
    }

    public static Record newRecord(long recordId, Object key, Object value) {
        return TestUtil.newRecord(recordId, IOUtil.toData(key), IOUtil.toData(value));
    }

    public static Record newRecord(long recordId) {
        return TestUtil.newRecord(recordId, null, null);
    }

    public static Request newPutRequest(Data key, Data value) {
        return TestUtil.newPutRequest(key, value, -1L);
    }

    public static Request newPutRequest(Data key, Data value, long ttl) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_PUT, key, value, ttl);
    }

    public static Request newRequest(ClusterOperation operation, Data key, Data value, long ttl) {
        Request request = new Request();
        request.setLocal(operation, null, key, value, -1, -1L, ttl, null);
        return request;
    }

    public static Request newRemoveRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_REMOVE, key, null, -1L);
    }

    public static Request newEvictRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_EVICT, key, null, -1L);
    }

    public static Request newGetRequest(Data key) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_GET, key, null, -1L);
    }

    public static Request newContainsRequest(Data key, Data value) {
        return TestUtil.newRequest(ClusterOperation.CONCURRENT_MAP_CONTAINS, key, value, -1L);
    }

    @Ignore
    public static class Employee
    implements Serializable {
        long id;
        String name;
        String city;
        int age;
        boolean active;
        double salary;

        public Employee(long id, String name, int age, boolean live, double price) {
            this(id, name, null, age, live, price);
        }

        public Employee(String name, int age, boolean live, double price) {
            this(-1L, name, age, live, price);
        }

        public Employee(long id, String name, String city, int age, boolean live, double price) {
            this.id = id;
            this.name = name;
            this.city = city;
            this.age = age;
            this.active = live;
            this.salary = price;
        }

        public Employee() {
        }

        public String getName() {
            return this.name;
        }

        public String getCity() {
            return this.city;
        }

        public int getAge() {
            return this.age;
        }

        public double getSalary() {
            return this.salary;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Employee employee = (Employee)o;
            if (this.active != employee.active) {
                return false;
            }
            if (this.age != employee.age) {
                return false;
            }
            if (Double.compare(employee.salary, this.salary) != 0) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(employee.name) : employee.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.age;
            result = 31 * result + (this.active ? 1 : 0);
            long temp = this.salary != 0.0 ? Double.doubleToLongBits(this.salary) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Employee");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", city=").append(this.city);
            sb.append(", age=").append(this.age);
            sb.append(", active=").append(this.active);
            sb.append(", salary=").append(this.salary);
            sb.append('}');
            return sb.toString();
        }
    }

    @Ignore
    public static class EmptyMapEntry
    implements MapEntry {
        private long cost;
        private long creationTime;
        private long expirationTime;
        private int hits;
        private long lastAccessTime;
        private long lastUpdateTime;
        private long lastStoredTime;
        private int version;
        private boolean valid;
        private Object key;
        private Object value;
        private long id;

        public EmptyMapEntry(long id) {
            this.id = id;
        }

        public long getCost() {
            return this.cost;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public int getHits() {
            return this.hits;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getLastStoredTime() {
            return this.lastStoredTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public long getVersion() {
            return this.version;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public void setCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        public void setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
        }

        public void setHits(int hits) {
            this.hits = hits;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public void setLastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmptyMapEntry that = (EmptyMapEntry)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public String toString() {
            return "EmptyMapEntry{id=" + this.id + ", expirationTime=" + this.expirationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", key=" + this.key + ", value=" + this.value + ", valid=" + this.valid + ", creationTime=" + this.creationTime + ", cost=" + this.cost + ", version=" + this.version + '}';
        }
    }

    @Ignore
    public static class Value
    extends AbstractValue
    implements Serializable {
        ValueType type;
        int index;

        public Value(String name, ValueType type, int index) {
            super(name);
            this.type = type;
            this.index = index;
        }

        public Value(String name) {
            this(name, null, 0);
        }

        public Value() {
            super("unknown");
        }

        public ValueType getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }
    }

    @Ignore
    public static abstract class AbstractValue
    implements Serializable {
        public String name;

        public AbstractValue(String name) {
            this.name = name;
        }

        protected AbstractValue() {
        }
    }

    @Ignore
    public static class ValueType
    implements Serializable {
        String typeName;

        public ValueType(String typeName) {
            this.typeName = typeName;
        }

        public ValueType() {
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    public static abstract class MigrationProcess {
        public abstract boolean prepare() throws Exception;

        public abstract boolean finish() throws Exception;
    }
}

