/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class BaseHandler
extends DefaultHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final EntityResolver entityResolver;

    BaseHandler(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.entityResolver != null) {
            try {
                return this.entityResolver.resolveEntity(string, string2);
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (IOException iOException) {
                throw new SAXException("I/O error has occurred - " + iOException, iOException);
            }
        }
        this.log.warn((Object)("ignoring publicId=" + string + " and systemId=" + string2));
        return null;
    }

    public void warning(SAXParseException sAXParseException) {
        this.log.warn((Object)"non-fatal error while parsing XML document", (Throwable)sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.entityResolver != null) {
            this.log.error((Object)"failed parsing XML resource in validating mode", (Throwable)sAXParseException);
            throw sAXParseException;
        }
        this.log.warn((Object)"ignoring parse error", (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.log.fatal((Object)"failed parsing XML resource", (Throwable)sAXParseException);
        throw sAXParseException;
    }
}

