/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPluginClassLoader
extends PluginClassLoader {
    static Log log = LogFactory.getLog(StandardPluginClassLoader.class);
    private static File libCacheFolder;
    private static boolean libCacheFolderInitialized;
    private PluginDescriptor[] publicImports;
    private PluginDescriptor[] privateImports;
    private PluginDescriptor[] reverseLookups;
    private PluginResourceLoader resourceLoader;
    private Map<String, ResourceFilter> resourceFilters;
    private Map<String, File> libraryCache;
    private boolean probeParentLoaderLast;

    private static URL getClassBaseUrl(Class<?> clazz) {
        CodeSource codeSource;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
            return codeSource.getLocation();
        }
        return null;
    }

    private static URL[] getUrls(PluginManager pluginManager, PluginDescriptor pluginDescriptor) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (Library object : pluginDescriptor.getLibraries()) {
            if (!object.isCodeLibrary()) continue;
            linkedList.add(pluginManager.getPathResolver().resolvePath(object, object.getPath()));
        }
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Code URL's populated for plug-in " + pluginDescriptor + ":\r\n");
            for (URL uRL : linkedList) {
                stringBuilder.append("\t");
                stringBuilder.append(uRL);
                stringBuilder.append("\r\n");
            }
            log.debug((Object)stringBuilder.toString());
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    private static URL[] getUrls(PluginManager pluginManager, PluginDescriptor pluginDescriptor, URL[] uRLArray) {
        List<URL> list = Arrays.asList(uRLArray);
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (Library library : pluginDescriptor.getLibraries()) {
            URL uRL;
            if (!library.isCodeLibrary() || list.contains(uRL = pluginManager.getPathResolver().resolvePath(library, library.getPath()))) continue;
            linkedList.add(uRL);
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLibCacheFolder() {
        if (libCacheFolder != null) {
            return libCacheFolderInitialized ? libCacheFolder : null;
        }
        Class<StandardPluginClassLoader> clazz = StandardPluginClassLoader.class;
        synchronized (StandardPluginClassLoader.class) {
            libCacheFolder = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + ".jpf-lib-cache");
            log.debug((Object)("libraries cache folder is " + libCacheFolder));
            File file = new File(libCacheFolder, "lock");
            if (file.exists()) {
                log.error((Object)("can't initialize libraries cache folder " + libCacheFolder + " as lock file indicates that it" + " is owned by another JPF instance"));
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (libCacheFolder.exists()) {
                IoUtil.emptyFolder(libCacheFolder);
            } else {
                libCacheFolder.mkdirs();
            }
            try {
                if (!file.createNewFile()) {
                    log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder));
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            catch (IOException iOException) {
                log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder), (Throwable)iOException);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            file.deleteOnExit();
            libCacheFolder.deleteOnExit();
            libCacheFolderInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return libCacheFolder;
        }
    }

    public StandardPluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader classLoader) {
        super(pluginManager, pluginDescriptor, StandardPluginClassLoader.getUrls(pluginManager, pluginDescriptor), classLoader);
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(pluginManager, pluginDescriptor);
        this.collectFilters();
        this.libraryCache = new HashMap<String, File>();
    }

    protected void collectImports() {
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginDescriptor> hashMap2 = new HashMap<String, PluginDescriptor>();
        PluginRegistry pluginRegistry = this.getPluginDescriptor().getRegistry();
        for (PluginPrerequisite object : this.getPluginDescriptor().getPrerequisites()) {
            if (!object.matches()) continue;
            PluginDescriptor pluginDescriptor = pluginRegistry.getPluginDescriptor(object.getPluginId());
            if (object.isExported()) {
                hashMap.put(pluginDescriptor.getId(), pluginDescriptor);
                continue;
            }
            hashMap2.put(pluginDescriptor.getId(), pluginDescriptor);
        }
        this.publicImports = hashMap.values().toArray(new PluginDescriptor[hashMap.size()]);
        this.privateImports = hashMap2.values().toArray(new PluginDescriptor[hashMap2.size()]);
        HashMap hashMap3 = new HashMap();
        block1: for (PluginDescriptor pluginDescriptor : pluginRegistry.getPluginDescriptors()) {
            if (pluginDescriptor.equals(this.getPluginDescriptor()) || hashMap.containsKey(pluginDescriptor.getId()) || hashMap2.containsKey(pluginDescriptor.getId())) continue;
            for (PluginPrerequisite pluginPrerequisite : pluginDescriptor.getPrerequisites()) {
                if (!pluginPrerequisite.getPluginId().equals(this.getPluginDescriptor().getId()) || !pluginPrerequisite.isReverseLookup() || !pluginPrerequisite.matches()) continue;
                hashMap3.put(pluginDescriptor.getId(), pluginDescriptor);
                continue block1;
            }
        }
        this.reverseLookups = hashMap3.values().toArray(new PluginDescriptor[hashMap3.size()]);
    }

    protected void collectFilters() {
        if (this.resourceFilters == null) {
            this.resourceFilters = new HashMap<String, ResourceFilter>();
        } else {
            this.resourceFilters.clear();
        }
        for (Library library : this.getPluginDescriptor().getLibraries()) {
            this.resourceFilters.put(this.getPluginManager().getPathResolver().resolvePath(library, library.getPath()).toExternalForm(), new ResourceFilter(library));
        }
    }

    @Override
    protected void pluginsSetChanged() {
        Object object;
        URL[] uRLArray = StandardPluginClassLoader.getUrls(this.getPluginManager(), this.getPluginDescriptor(), this.getURLs());
        for (URL uRL : uRLArray) {
            this.addURL(uRL);
        }
        if (log.isDebugEnabled()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("New code URL's populated for plug-in " + this.getPluginDescriptor() + ":\r\n");
            for (URL uRL : uRLArray) {
                ((StringBuilder)object).append("\t");
                ((StringBuilder)object).append(uRL);
                ((StringBuilder)object).append("\r\n");
            }
            log.debug((Object)((StringBuilder)object).toString());
        }
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(this.getPluginManager(), this.getPluginDescriptor());
        this.collectFilters();
        object = this.libraryCache.entrySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            if (((Map.Entry)iterator.next()).getValue() != null) continue;
            iterator.remove();
        }
    }

    @Override
    protected void dispose() {
        for (File file : this.libraryCache.values()) {
            file.delete();
        }
        this.libraryCache.clear();
        this.resourceFilters.clear();
        this.privateImports = null;
        this.publicImports = null;
        this.resourceLoader = null;
    }

    protected void setProbeParentLoaderLast(boolean bl) {
        this.probeParentLoaderLast = bl;
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.probeParentLoaderLast) {
            try {
                clazz = this.loadClass(string, bl, this, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.getParent().loadClass(string);
            }
            if (clazz == null) {
                clazz = this.getParent().loadClass(string);
            }
        } else {
            try {
                clazz = this.getParent().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.loadClass(string, bl, this, null);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String string, boolean bl, StandardPluginClassLoader standardPluginClassLoader, Set<String> set) throws ClassNotFoundException {
        Set<String> set2 = set;
        if (set2 != null && set2.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        if (this != standardPluginClassLoader && !this.getPluginManager().isPluginActivated(this.getPluginDescriptor()) && !this.getPluginManager().isPluginActivating(this.getPluginDescriptor())) {
            String string2 = "can't load class " + string + ", plug-in " + this.getPluginDescriptor() + " is not activated yet";
            log.warn((Object)string2);
            throw new ClassNotFoundException(string2);
        }
        Class<?> clazz = null;
        boolean bl2 = log.isDebugEnabled();
        PluginDescriptor[] pluginDescriptorArray = this;
        synchronized (this) {
            clazz = this.findLoadedClass(string);
            if (clazz != null) {
                if (bl2) {
                    log.debug((Object)("loadClass(...): found loaded class, class=" + clazz + ", this=" + this + ", requestor=" + standardPluginClassLoader));
                }
                this.checkClassVisibility(clazz, standardPluginClassLoader);
                // ** MonitorExit[var8_9] (shouldn't be in output)
                return clazz;
            }
            try {
                clazz = this.findClass(string);
            }
            catch (LinkageError linkageError) {
                if (bl2) {
                    log.debug((Object)("loadClass(...): class loading failed, name=" + string + ", this=" + this + ", requestor=" + standardPluginClassLoader), (Throwable)linkageError);
                }
                throw linkageError;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                if (bl2) {
                    log.debug((Object)("loadClass(...): found class, class=" + clazz + ", this=" + this + ", requestor=" + standardPluginClassLoader));
                }
                this.checkClassVisibility(clazz, standardPluginClassLoader);
                if (bl) {
                    this.resolveClass(clazz);
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
                return clazz;
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            if (set2 == null) {
                set2 = new HashSet<String>();
            }
            if (bl2) {
                log.debug((Object)("loadClass(...): class not found, name=" + string + ", this=" + this + ", requestor=" + standardPluginClassLoader));
            }
            set2.add(this.getPluginDescriptor().getId());
            for (PluginDescriptor pluginDescriptor : this.publicImports) {
                if (!set2.contains(pluginDescriptor.getId()) && (clazz = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).loadClass(string, bl, standardPluginClassLoader, set2)) != null) break;
            }
            if (this == standardPluginClassLoader && clazz == null) {
                for (PluginDescriptor pluginDescriptor : this.privateImports) {
                    if (!set2.contains(pluginDescriptor.getId()) && (clazz = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).loadClass(string, bl, standardPluginClassLoader, set2)) != null) break;
                }
            }
            if (clazz == null) {
                for (PluginDescriptor pluginDescriptor : this.reverseLookups) {
                    if (!set2.contains(pluginDescriptor.getId()) && (this.getPluginManager().isPluginActivated(pluginDescriptor) || this.getPluginManager().isPluginActivating(pluginDescriptor)) && (clazz = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).loadClass(string, bl, standardPluginClassLoader, set2)) != null) break;
                }
            }
            return clazz;
        }
    }

    protected void checkClassVisibility(Class<?> clazz, StandardPluginClassLoader standardPluginClassLoader) throws ClassNotFoundException {
        if (this == standardPluginClassLoader) {
            return;
        }
        URL uRL = StandardPluginClassLoader.getClassBaseUrl(clazz);
        if (uRL == null) {
            return;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (!(classLoader instanceof StandardPluginClassLoader)) {
            return;
        }
        if (classLoader != this) {
            ((StandardPluginClassLoader)classLoader).checkClassVisibility(clazz, standardPluginClassLoader);
        } else {
            ResourceFilter resourceFilter = this.resourceFilters.get(uRL.toExternalForm());
            if (resourceFilter == null) {
                log.warn((Object)("class not visible, no class filter found, lib=" + uRL + ", class=" + clazz + ", this=" + this + ", requestor=" + standardPluginClassLoader));
                throw new ClassNotFoundException("class " + clazz.getName() + " is not visible for plug-in " + standardPluginClassLoader.getPluginDescriptor().getId() + ", no filter found for library " + uRL);
            }
            if (!resourceFilter.isClassVisible(clazz.getName())) {
                log.warn((Object)("class not visible, lib=" + uRL + ", class=" + clazz + ", this=" + this + ", requestor=" + standardPluginClassLoader));
                throw new ClassNotFoundException("class " + clazz.getName() + " is not visible for plug-in " + standardPluginClassLoader.getPluginDescriptor().getId());
            }
        }
    }

    @Override
    protected String findLibrary(String string) {
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + string + ", this=" + this));
        }
        String string2 = System.mapLibraryName(string);
        String string3 = null;
        PathResolver pathResolver = this.getPluginManager().getPathResolver();
        for (Library library : this.getPluginDescriptor().getLibraries()) {
            File file;
            if (library.isCodeLibrary()) continue;
            URL uRL = pathResolver.resolvePath(library, library.getPath() + string2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("findLibrary(String): trying URL " + uRL));
            }
            if ((file = IoUtil.url2file(uRL)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findLibrary(String): URL " + uRL + " resolved as local file " + file));
                }
                if (!file.isFile()) continue;
                string3 = file.getAbsolutePath();
                break;
            }
            String string4 = uRL.toExternalForm();
            file = this.libraryCache.get(string4);
            if (file != null) {
                if (file.isFile()) {
                    string3 = file.getAbsolutePath();
                    break;
                }
                this.libraryCache.remove(string4);
            }
            if (this.libraryCache.containsKey(string4)) break;
            file = this.cacheLibrary(uRL, string2);
            if (file == null) continue;
            string3 = file.getAbsolutePath();
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + string + ", libname=" + string2 + ", result=" + string3 + ", this=" + this));
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File cacheLibrary(URL uRL, String string) {
        String string2 = uRL.toExternalForm();
        File file = this.libraryCache.get(string2);
        if (file != null) {
            return file;
        }
        try {
            File file2 = StandardPluginClassLoader.getLibCacheFolder();
            if (file2 == null) {
                throw new IOException("can't initialize libraries cache folder");
            }
            File file3 = new File(file2, this.getPluginDescriptor().getUniqueId());
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("can't create cache folder " + file3);
            }
            file = new File(file3, string);
            InputStream inputStream = IoUtil.getResourceInputStream(uRL);
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    IoUtil.copyStream(inputStream, bufferedOutputStream, 512);
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("library " + string + " successfully cached from URL " + uRL + " and saved to local file " + file));
            }
        }
        catch (IOException iOException) {
            log.error((Object)("can't cache library " + string + " from URL " + uRL), (Throwable)iOException);
            file = null;
        }
        this.libraryCache.put(string2, file);
        return file;
    }

    @Override
    public URL findResource(String string) {
        URL uRL = this.findResource(string, this, null);
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        this.findResources(linkedList, string, this, null);
        return Collections.enumeration(linkedList);
    }

    protected URL findResource(String string, StandardPluginClassLoader standardPluginClassLoader, Set<String> set) {
        Set<String> set2 = set;
        if (set2 != null && set2.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        URL uRL = super.findResource(string);
        if (uRL != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResource(...): resource found in classpath, name=" + string + " URL=" + uRL + ", this=" + this + ", requestor=" + standardPluginClassLoader));
            }
            if (this.isResourceVisible(string, uRL, standardPluginClassLoader)) {
                return uRL;
            }
            return null;
        }
        if (this.resourceLoader != null && (uRL = this.resourceLoader.findResource(string)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResource(...): resource found in libraries, name=" + string + ", URL=" + uRL + ", this=" + this + ", requestor=" + standardPluginClassLoader));
            }
            if (this.isResourceVisible(string, uRL, standardPluginClassLoader)) {
                return uRL;
            }
            return null;
        }
        if (set2 == null) {
            set2 = new HashSet<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findResource(...): resource not found, name=" + string + ", this=" + this + ", requestor=" + standardPluginClassLoader));
        }
        set2.add(this.getPluginDescriptor().getId());
        for (PluginDescriptor pluginDescriptor : this.publicImports) {
            if (!set2.contains(pluginDescriptor.getId()) && (uRL = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResource(string, standardPluginClassLoader, set2)) != null) break;
        }
        if (this == standardPluginClassLoader && uRL == null) {
            for (PluginDescriptor pluginDescriptor : this.privateImports) {
                if (!set2.contains(pluginDescriptor.getId()) && (uRL = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResource(string, standardPluginClassLoader, set2)) != null) break;
            }
        }
        if (uRL == null) {
            for (PluginDescriptor pluginDescriptor : this.reverseLookups) {
                if (!set2.contains(pluginDescriptor.getId()) && (uRL = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResource(string, standardPluginClassLoader, set2)) != null) break;
            }
        }
        return uRL;
    }

    protected void findResources(List<URL> list, String string, StandardPluginClassLoader standardPluginClassLoader, Set<String> set) throws IOException {
        URL uRL;
        Set<String> set2 = set;
        if (set2 != null && set2.contains(this.getPluginDescriptor().getId())) {
            return;
        }
        PluginDescriptor[] pluginDescriptorArray = super.findResources(string);
        while (pluginDescriptorArray.hasMoreElements()) {
            uRL = pluginDescriptorArray.nextElement();
            if (!this.isResourceVisible(string, uRL, standardPluginClassLoader)) continue;
            list.add(uRL);
        }
        if (this.resourceLoader != null) {
            pluginDescriptorArray = this.resourceLoader.findResources(string);
            while (pluginDescriptorArray.hasMoreElements()) {
                uRL = pluginDescriptorArray.nextElement();
                if (!this.isResourceVisible(string, uRL, standardPluginClassLoader)) continue;
                list.add(uRL);
            }
        }
        if (set2 == null) {
            set2 = new HashSet<String>();
        }
        set2.add(this.getPluginDescriptor().getId());
        for (PluginDescriptor pluginDescriptor : this.publicImports) {
            if (set2.contains(pluginDescriptor.getId())) continue;
            ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResources(list, string, standardPluginClassLoader, set2);
        }
        if (this == standardPluginClassLoader) {
            for (PluginDescriptor pluginDescriptor : this.privateImports) {
                if (set2.contains(pluginDescriptor.getId())) continue;
                ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResources(list, string, standardPluginClassLoader, set2);
            }
        }
        for (PluginDescriptor pluginDescriptor : this.reverseLookups) {
            if (set2.contains(pluginDescriptor.getId())) continue;
            ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(pluginDescriptor)).findResources(list, string, standardPluginClassLoader, set2);
        }
    }

    protected boolean isResourceVisible(String string, URL uRL, StandardPluginClassLoader standardPluginClassLoader) {
        URL uRL2;
        Object object;
        if (this == standardPluginClassLoader) {
            return true;
        }
        try {
            object = uRL.getFile();
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), ((String)object).substring(0, ((String)object).length() - string.length()));
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)"can't get resource library URL", (Throwable)malformedURLException);
            return false;
        }
        object = this.resourceFilters.get(uRL2.toExternalForm());
        if (object == null) {
            log.warn((Object)("no resource filter found for library " + uRL2 + ", name=" + string + ", URL=" + uRL + ", this=" + this + ", requestor=" + standardPluginClassLoader));
            return false;
        }
        if (!((ResourceFilter)object).isResourceVisible(string)) {
            log.warn((Object)("resource not visible, name=" + string + ", URL=" + uRL + ", this=" + this + ", requestor=" + standardPluginClassLoader));
            return false;
        }
        return true;
    }

    static {
        libCacheFolderInitialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PluginResourceLoader
    extends URLClassLoader {
        private static Log logger = LogFactory.getLog(PluginResourceLoader.class);

        static PluginResourceLoader get(PluginManager pluginManager, PluginDescriptor pluginDescriptor) {
            final LinkedList<URL> linkedList = new LinkedList<URL>();
            for (Library object : pluginDescriptor.getLibraries()) {
                if (object.isCodeLibrary()) continue;
                linkedList.add(pluginManager.getPathResolver().resolvePath(object, object.getPath()));
            }
            if (logger.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Resource URL's populated for plug-in " + pluginDescriptor + ":\r\n");
                for (URL uRL : linkedList) {
                    stringBuilder.append("\t");
                    stringBuilder.append(uRL);
                    stringBuilder.append("\r\n");
                }
                logger.trace((Object)stringBuilder.toString());
            }
            if (linkedList.isEmpty()) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<PluginResourceLoader>(){

                @Override
                public PluginResourceLoader run() {
                    return new PluginResourceLoader(linkedList.toArray(new URL[linkedList.size()]));
                }
            });
        }

        PluginResourceLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            throw new ClassNotFoundException(string);
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            throw new ClassNotFoundException(string);
        }
    }

    protected static final class ResourceFilter {
        private boolean isPublic;
        private final Set<String> entries = new HashSet<String>();

        protected ResourceFilter(Library library) {
            for (String string : library.getExports()) {
                if ("*".equals(string)) {
                    this.isPublic = true;
                    this.entries.clear();
                    break;
                }
                if (!library.isCodeLibrary() && (string = string.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                    string = string.substring(1);
                }
                this.entries.add(string);
            }
        }

        protected boolean isClassVisible(String string) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            if (this.entries.contains(string)) {
                return true;
            }
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            return this.entries.contains(string.substring(0, n) + ".*");
        }

        protected boolean isResourceVisible(String string) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            String string2 = string.replace('\\', '.').replace('/', '.');
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return this.isClassVisible(string2);
        }
    }
}

