/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.boot.Boot;
import org.java.plugin.boot.ServiceApplication;

final class ControlThread
extends Thread {
    private Log log = LogFactory.getLog(this.getClass());
    private ServerSocket serverSocket;
    private final ServiceApplication application;
    private boolean appRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isApplicationRunning(InetAddress inetAddress, int n) {
        try {
            Socket socket = new Socket(inetAddress, n);
            try {
                socket.setKeepAlive(true);
                String string = "" + System.currentTimeMillis();
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = null;
                try {
                    int n2;
                    System.out.println("found running control service on " + inetAddress + ":" + n);
                    outputStream.write(("PING " + string).getBytes());
                    outputStream.flush();
                    socket.shutdownOutput();
                    inputStream = socket.getInputStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    byte[] byArray = new byte[16];
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        stringBuilder.append(new String(byArray, 0, n2));
                    }
                    socket.shutdownInput();
                    if (stringBuilder.toString().startsWith("OK") && stringBuilder.toString().indexOf(string) != -1) {
                        System.out.println("PING command succeed");
                        boolean bl = true;
                        return bl;
                    }
                    System.out.println("PING command failed");
                    return false;
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                socket.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("seems that there is no control service running on " + inetAddress + ":" + n);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean stopRunningApplication(InetAddress inetAddress, int n) {
        boolean bl = false;
        try {
            Socket socket = new Socket(inetAddress, n);
            try {
                socket.setKeepAlive(true);
                OutputStream outputStream = socket.getOutputStream();
                InputStream inputStream = null;
                try {
                    int n2;
                    System.out.println("found running control service on " + inetAddress + ":" + n);
                    outputStream.write("STOP".getBytes());
                    outputStream.flush();
                    socket.shutdownOutput();
                    inputStream = socket.getInputStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    byte[] byArray = new byte[16];
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        stringBuilder.append(new String(byArray, 0, n2));
                    }
                    socket.shutdownInput();
                    if (stringBuilder.toString().startsWith("OK")) {
                        System.out.println("STOP command succeed");
                        bl = true;
                    } else {
                        System.out.println("STOP command failed");
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                socket.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("seems that there is no control service running on " + inetAddress + ":" + n);
        }
        if (bl) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    ControlThread(InetAddress inetAddress, int n, ServiceApplication serviceApplication) throws Exception {
        this.application = serviceApplication;
        this.serverSocket = new ServerSocket(n, 1, inetAddress);
        this.appRunning = true;
        this.setName("jpf-application-control-thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            while (true) {
                try {
                    try {
                        Socket socket = this.serverSocket.accept();
                        try {
                            if (!this.handleRequest(socket)) continue;
                            break block24;
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        this.warn("error on server socket", exception);
                        break block24;
                    }
                }
                catch (Exception exception) {
                    this.error(exception);
                    break block24;
                }
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    this.warn("error closing server socket", iOException);
                }
                if (this.appRunning) {
                    this.stopApplication();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean handleRequest(Socket socket) {
        this.debug("handling control request");
        if (!this.isValidRemoteHost(socket.getInetAddress())) {
            this.warn("incoming connection to control socket registered from REMOTE address " + socket.getInetAddress() + ", attempt to execute command was IGNORED");
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        this.debug("processing control request");
        boolean bl = false;
        try {
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = null;
            try {
                String string;
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                byte[] byArray = new byte[16];
                while ((n = inputStream.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n));
                }
                socket.shutdownInput();
                this.debug("got command - " + stringBuilder);
                if ("STOP".equals(stringBuilder.toString())) {
                    this.stopApplication();
                    bl = true;
                    string = "OK: stop done";
                } else {
                    string = stringBuilder.toString().startsWith("PING") ? "OK: " + stringBuilder.substring("PING".length()) : "ERROR: unknown command";
                }
                outputStream = socket.getOutputStream();
                outputStream.write(string.getBytes());
                outputStream.flush();
                socket.shutdownOutput();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            this.error("error processing control request", iOException);
        }
        return bl;
    }

    private void stopApplication() {
        if (!this.appRunning) {
            this.debug("application not running");
            return;
        }
        this.appRunning = false;
        this.debug("stopping application");
        try {
            Boot.stopApplication(this.application);
            this.log = null;
        }
        catch (Exception exception) {
            this.error("an error has occurred while stopping application", exception);
        }
        this.debug("application stopped from control thread");
    }

    private boolean isValidRemoteHost(InetAddress inetAddress) {
        byte[] byArray;
        byte[] byArray2 = this.serverSocket.getInetAddress().getAddress();
        if (byArray2.length != (byArray = inetAddress.getAddress()).length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private void debug(String string) {
        if (this.log != null) {
            this.log.debug((Object)string);
        } else {
            System.out.println(string);
        }
    }

    private void warn(String string) {
        if (this.log != null) {
            this.log.warn((Object)string);
        } else {
            System.out.println(string);
        }
    }

    private void warn(String string, Exception exception) {
        if (this.log != null) {
            this.log.warn((Object)string, (Throwable)exception);
        } else {
            System.out.println(string);
            exception.printStackTrace();
        }
    }

    private void error(String string, Exception exception) {
        if (this.log != null) {
            this.log.error((Object)string, (Throwable)exception);
        } else {
            System.err.println(string);
            exception.printStackTrace();
        }
    }

    private void error(Exception exception) {
        if (this.log != null) {
            this.log.error((Object)exception);
        } else {
            exception.printStackTrace();
        }
    }
}

