/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.sql.AbstractSQLBuilder;
import com.tandbergtv.metadatamanager.sql.DeleteBuilder;
import com.tandbergtv.metadatamanager.sql.InsertBuilder;
import com.tandbergtv.metadatamanager.sql.SelectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class PgQueryBuilder {
    public static AbstractSQLBuilder getAssetUniquenessQuery(SearchCriteria criteria) {
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.column("1");
        selectBuilder.from(IdDAO.assetKeyTable);
        selectBuilder.where(criteria);
        return selectBuilder;
    }

    public static AbstractSQLBuilder getDocumentIdQuery(SearchCriteria criteria) {
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.column(IdDAO.documentIdColumn);
        selectBuilder.from(IdDAO.assetKeyTable);
        selectBuilder.where(criteria);
        return selectBuilder;
    }

    public static AbstractSQLBuilder getFullDocumentQuery(SearchCriteria criteria) {
        String keysAlias = "k";
        String mdmAlias = "mdm";
        SelectBuilder subQuery = new SelectBuilder();
        subQuery.column(keysAlias + "." + IdDAO.documentIdColumn);
        subQuery.from(IdDAO.assetKeyTable + " " + keysAlias);
        subQuery.where(criteria);
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.column("XMLSERIALIZE(content " + mdmAlias + ".document as text) \r\n");
        selectBuilder.from("mdm_metadata " + mdmAlias + "\r\n");
        selectBuilder.where(mdmAlias + ".document_id in (" + subQuery.toString() + ")");
        return selectBuilder;
    }

    public static AbstractSQLBuilder getInsertAssetKeyQuery() {
        InsertBuilder insertBuilder = new InsertBuilder();
        insertBuilder.table(IdDAO.assetKeyTable);
        insertBuilder.column(IdDAO.documentIdColumn);
        insertBuilder.column(IdDAO.assetIdColumn);
        insertBuilder.column(IdDAO.keysJsonColumn);
        return insertBuilder;
    }

    public static AbstractSQLBuilder getDeleteAssetKeyByDocumentIdQuery() {
        DeleteBuilder deleteBuilder = new DeleteBuilder();
        deleteBuilder.from(IdDAO.assetKeyTable);
        deleteBuilder.where(IdDAO.documentIdColumn + " = ?");
        return deleteBuilder;
    }

    public static AbstractSQLBuilder getDeleteAssetKeyByAssetIdQuery() {
        DeleteBuilder deleteBuilder = new DeleteBuilder();
        deleteBuilder.from(IdDAO.assetKeyTable);
        deleteBuilder.where(IdDAO.assetIdColumn + " = ?");
        return deleteBuilder;
    }

    public static AbstractSQLBuilder getDuplicateAssetIdQuery(Collection<String> ttvPaths) {
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.column("array_agg(asset_id)");
        selectBuilder.column("count(*)");
        selectBuilder.from(IdDAO.assetKeyTable);
        selectBuilder.having("count(*) > 1");
        for (String xpath : ttvPaths) {
            String JsonPath = PgQueryBuilder.getJsonPath(xpath);
            selectBuilder.groupBy(JsonPath);
            selectBuilder.having(JsonPath + " != ''");
        }
        return selectBuilder;
    }

    private static String encodeField(String value, boolean isForSql) {
        return isForSql ? "''" + value + "''" : "'" + value + "'";
    }

    public static String getJsonPath(String xpath) {
        return PgQueryBuilder.getJsonPath(xpath, false);
    }

    public static String getJsonPath(String xpath, boolean isForSql) {
        StringBuilder sb = new StringBuilder();
        String[] toks = xpath.split("/");
        int i = 0;
        sb.append(IdDAO.keysJsonColumn);
        sb.append("->");
        for (String tok : toks) {
            if (tok.trim().isEmpty()) continue;
            sb.append(PgQueryBuilder.encodeField(tok, isForSql));
            if (i < toks.length - 3) {
                sb.append("->");
            } else if (i == toks.length - 3) {
                sb.append("->>");
            }
            ++i;
        }
        return sb.toString();
    }

    public static AbstractSQLBuilder getTitleIdFromAssetIdQuery() {
        SelectBuilder selectBuilder = new SelectBuilder();
        selectBuilder.column("t.id");
        selectBuilder.from("pmm_title t");
        selectBuilder.from("mdm_asset_identifier f");
        selectBuilder.where("t.mdmdocid = f.document_id");
        selectBuilder.where("f.asset_id = ?");
        return selectBuilder;
    }

    public static String getCreateUniqueIndexOnIdentifiersQuery(String indexName, Collection<String> ttvPaths) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FUNC_CREATE_MDM_AI_IDX ( ");
        sb.append("'" + indexName + "', '");
        ArrayList<String> jsonList = new ArrayList<String>();
        for (String ttvPath : ttvPaths) {
            String jsonString = "(" + PgQueryBuilder.getJsonPath(ttvPath, true) + ")";
            jsonList.add(jsonString);
        }
        sb.append(StringUtils.join(jsonList, (String)","));
        sb.append("');");
        return sb.toString();
    }
}

