/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.oracle;

import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.search.MDMTable;
import com.tandbergtv.metadatamanager.util.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.hibernate.jdbc.Work;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;

public class InsertMetadata
implements Work {
    protected Document ecmfDoc;
    protected boolean isOriginal;
    protected String strXml;
    protected static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);

    public InsertMetadata(boolean isOriginal, Document ecmfDoc) throws MetadataException {
        this.ecmfDoc = ecmfDoc;
        this.isOriginal = isOriginal;
        this.strXml = Utils.serialize(ecmfDoc);
        if (!StringUtils.hasText((String)this.strXml)) {
            throw new MetadataException("Error: Empty Document");
        }
    }

    protected String getSql() {
        StringBuilder s = new StringBuilder("INSERT into ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" VALUES (?)");
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection con) throws SQLException {
        Statement st = null;
        SQLXML xmlObj = null;
        try {
            String sql = this.getSql();
            logger.debug((Object)sql);
            st = con.prepareStatement(sql);
            xmlObj = con.createSQLXML();
            xmlObj.setString(this.strXml);
            st.setSQLXML(1, xmlObj);
            st.execute();
        }
        finally {
            if (xmlObj != null) {
                xmlObj.free();
            }
            st.close();
        }
    }

    public String getXMLString() {
        return this.strXml;
    }
}

