/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.oracle;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.SearchColumn;
import com.tandbergtv.metadatamanager.search.ConditionBuilderFactory;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DBTypeEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AssetSearchQueryBuilder {
    public static final String SPACEY_ON = "\r\nON (";
    protected static final String MDM_ALIAS = "mdm";
    public static final String DOCID_ALIAS = "docId";
    private static final String COL_ALIAS = "mdm_col";
    protected SearchSchemaHelper searchSchemaHelper;
    private ConditionBuilderFactory conditionBuilderFactory;

    public AssetSearchQueryBuilder(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }

    public void setSearchSchemaHelper(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }

    public void setConditionBuilderFactory(ConditionBuilderFactory conditionBuilderFactory) {
        this.conditionBuilderFactory = conditionBuilderFactory;
    }

    public ConditionBuilderFactory getConditionBuilderFactory() {
        return this.conditionBuilderFactory;
    }

    public String buildQuery(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        return this.buildQuery(condition, new ArrayList<SearchColumn>(), onlyOriginals, generalConditions);
    }

    public String buildQuery(ExpNode condition, List<SearchColumn> resultColumns, boolean onlyOriginals, ExpNode generalConditions) {
        StringBuffer query = new StringBuffer();
        this.buildSelect(query, resultColumns);
        query.append("from mdm_metadata ");
        query.append(MDM_ALIAS);
        query.append("\r\n");
        query.append(this.buildWhere(condition, onlyOriginals, generalConditions));
        return query.toString();
    }

    protected String buildWhere(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        StringBuffer conditionStr = new StringBuffer();
        if (generalConditions != null && (generalConditions instanceof ExpValue || !((ExpList)generalConditions).isEmpty())) {
            this.buildOtherConditions(generalConditions, conditionStr);
        }
        if (onlyOriginals) {
            if (conditionStr.length() > 0) {
                conditionStr.append(" AND ");
            }
            conditionStr.append(this.getOnlyOriginals());
        }
        if (condition != null) {
            if (conditionStr.length() > 0) {
                conditionStr.append(" AND ");
            }
            this.buildCombinedCondition(conditionStr, condition);
        }
        if (conditionStr.length() > 0) {
            return "where " + conditionStr.toString();
        }
        return "";
    }

    public String buildExistenceQuery(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        StringBuffer query = new StringBuffer();
        query.append("select 1 from mdm_metadata ");
        query.append(MDM_ALIAS);
        query.append("\r\n");
        query.append(this.buildWhere(condition, onlyOriginals, generalConditions));
        return query.toString();
    }

    public String buildGetFieldValuesQuery(String path, Long documentId, String tableName) {
        StringBuffer query = new StringBuffer("select value from ");
        query.append(tableName);
        query.append(" mdm, xmltable('for $i in /");
        query.append(path);
        query.append(" \r\nreturn <ROW><value>{$i}</value></ROW>'");
        query.append("passing sys_nc_rowinfo$ ");
        query.append("columns value varchar(2000) path '/ROW/value')  xtab ");
        query.append("where xmlexists('$p/ECMFSpec[@documentId = ");
        query.append(documentId);
        query.append(" ]' passing sys_nc_rowinfo$ as \"p\")");
        return query.toString();
    }

    private void buildOtherConditions(ExpNode condition, StringBuffer query) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            query.append(this.getCondition(predicate));
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            if (nodes.isEmpty()) {
                return;
            }
            String listOperator = list.getSqlOperator();
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildOtherConditions(node, query);
            }
            query.append(")");
        }
    }

    public String buildQueryForFullDoc(ExpNode condition, boolean onlyOriginals) {
        StringBuffer query = new StringBuffer();
        query.append("select XMLSERIALIZE(content mdm.OBJECT_VALUE as clob no indent) \r\n");
        query.append("from mdm_metadata mdm\r\n");
        query.append(this.buildWhere(condition, onlyOriginals, null));
        return query.toString();
    }

    private String getOnlyOriginals() {
        LogicalOperator operator = LogicalOperator.ISNULL;
        Predicate origAssetCond = new Predicate("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, operator, Boolean.valueOf(false));
        return this.getCondition(origAssetCond);
    }

    private void buildSelect(StringBuffer query, List<SearchColumn> resultColumns) {
        query.append("Select ");
        boolean appendedDocId = false;
        for (int i = 0; i < resultColumns.size(); ++i) {
            SearchColumn sc = resultColumns.get(i);
            if (i > 0) {
                query.append(", ");
            }
            if (sc.getFieldName().equals("@documentId")) {
                appendedDocId = true;
                query.append(this.getExtractValue("ECMFSpec", "/@documentId"));
                query.append(" as ");
                query.append(DOCID_ALIAS);
                continue;
            }
            query.append(this.getExtractValue(sc.getSectionType(), sc.getFieldName()));
            query.append(" as ");
            query.append(COL_ALIAS + i);
        }
        if (!appendedDocId) {
            if (resultColumns.size() > 0) {
                query.append(", ");
            }
            query.append(this.getExtractValue("ECMFSpec", "/@documentId"));
            query.append(" as ");
            query.append(DOCID_ALIAS);
        }
        query.append("\r\n");
    }

    protected void buildCombinedCondition(StringBuffer query, ExpNode condition) {
        query.append(" xmlexists('$p");
        this.appendCombinedConditionPath(query, condition);
        query.append("passing sys_nc_rowinfo$ AS \"p\")");
    }

    protected void appendCombinedConditionPath(StringBuffer query, ExpNode condition) {
        HashSet<String> assetTypes = new HashSet<String>();
        this.findAllAssetTypes(condition, assetTypes);
        boolean containsWildCard = false;
        boolean containsCardinalityKinda1 = false;
        boolean containsOtherAssetTyes = false;
        String other = null;
        for (String assetType : assetTypes) {
            if (assetType.isEmpty() || assetType.equals("/") || assetType.equals("//")) {
                containsWildCard = true;
                continue;
            }
            if (SearchSchemaHelper.assetTypeIsKindaHasCardinality1(assetType)) {
                containsCardinalityKinda1 = true;
                continue;
            }
            containsOtherAssetTyes = true;
            if (other == null) {
                other = assetType;
                continue;
            }
            if (other.equals(assetType)) continue;
            throw new RuntimeException("Unsupported list of assets in condition: " + ((Object)assetTypes).toString());
        }
        if (containsWildCard && containsCardinalityKinda1 && containsOtherAssetTyes || !(containsWildCard ^ containsCardinalityKinda1 ^ containsOtherAssetTyes)) {
            throw new RuntimeException("Unsupported list of assets in condition: " + ((Object)assetTypes).toString());
        }
        if (containsWildCard) {
            query.append("//*");
        } else if (containsOtherAssetTyes) {
            query.append(this.searchSchemaHelper.getEcmfComplientSectionType(other, true));
        } else {
            query.append("/ECMFSpec");
        }
        query.append("[");
        this.buildCombinedConditionRec(query, condition);
        query.append(" ]' ");
    }

    private void findAllAssetTypes(ExpNode condition, Set<String> assetTypes) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            assetTypes.add(predicate.getFieldLeftSectionType());
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                this.findAllAssetTypes(node, assetTypes);
            }
        }
    }

    private void buildCombinedConditionRec(StringBuffer query, ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            query.append(this.getAssetCondition(predicate));
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            String listOperator = list.getOperator() == "AND" ? " and " : " or ";
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildCombinedConditionRec(query, node);
            }
            query.append(")");
        }
    }

    protected void appendCustomFieldSelectPath(StringBuffer sb, String assetType, String xpath) {
        sb.append(this.searchSchemaHelper.getEcmfComplientSectionTypeWIndices(assetType, true));
        String custXpath = CustomFieldXPathConverter.getActualXpath(xpath);
        int lastSlash = custXpath.lastIndexOf("/");
        custXpath = custXpath.substring(0, lastSlash) + "[1]" + custXpath.substring(lastSlash);
        sb.append(custXpath);
    }

    protected String getCustmFieldSelect(String assetType, String xpath) {
        StringBuffer sb = new StringBuffer();
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        sb.append("xmlcast(XMLQuery('");
        this.appendCustomFieldSelectPath(sb, assetType, xpath);
        sb.append("' PASSING mdm.OBJECT_VALUE RETURNING CONTENT) AS ");
        if (dataType.equals("date")) {
            sb.append("TIMESTAMP)");
        } else {
            sb.append("VARCHAR2(2000))");
        }
        return sb.toString();
    }

    protected String getFieldSelectWithCond(String assetType, String xpath) {
        StringBuffer result = new StringBuffer();
        result.append("xmlcast(XMLQuery('");
        this.appendFieldWithCond(assetType, xpath, result);
        result.append("' PASSING mdm.OBJECT_VALUE RETURNING CONTENT) AS VARCHAR2(2000))");
        return result.toString();
    }

    protected void appendFieldWithCond(String assetType, String xpath, StringBuffer result) {
        StringBuffer sb = new StringBuffer();
        boolean inCondition = false;
        StringBuffer currentNode = new StringBuffer();
        StringBuffer currentCondition = new StringBuffer();
        ArrayList<String> conditions = new ArrayList<String>();
        for (char c : xpath.toCharArray()) {
            if (c == '/' && !inCondition) {
                currentNode = new StringBuffer();
                conditions.add(currentCondition.toString());
                currentCondition = new StringBuffer();
                sb.append(c);
                continue;
            }
            if (c == '[' && !currentNode.toString().equals("CustomField")) {
                inCondition = true;
                continue;
            }
            if (c == ']' && inCondition) {
                inCondition = false;
                continue;
            }
            if (inCondition) continue;
            currentNode.append(c);
            sb.append(c);
        }
        String field = sb.toString();
        if (SearchSchemaHelper.isCustomField(field)) {
            field = CustomFieldXPathConverter.getActualXpath(field);
        }
        inCondition = false;
        Iterator condIterator = conditions.iterator();
        result.append(this.searchSchemaHelper.getEcmfComplientSectionTypeWIndices(assetType, true).replace("File[1]", "File"));
        for (char c : field.toCharArray()) {
            if (c == '/') {
                result.append((String)condIterator.next());
                result.append(c);
                continue;
            }
            if (inCondition) continue;
            currentNode.append(c);
            result.append(c);
        }
    }

    public String getMultiValueSelect(String assetType, String xpath) {
        StringBuffer sb = new StringBuffer();
        sb.append("XMLCAST(XMLQuery('string-join($p");
        if (!xpath.startsWith("/")) {
            sb.append("*");
        }
        sb.append(this.searchSchemaHelper.getEcmfComplientSectionTypeWIndices(assetType, true));
        if (SearchSchemaHelper.isCustomField(xpath)) {
            sb.append(CustomFieldXPathConverter.getActualXpath(xpath));
        } else {
            sb.append(xpath);
        }
        sb.append(", \",\")' PASSING sys_nc_rowinfo$ AS \"p\" RETURNING CONTENT) as varchar2(2000))");
        return sb.toString();
    }

    public String getExtractValue(String assetType, String xpath) {
        if (SearchSchemaHelper.isCustomField(xpath)) {
            return this.getCustmFieldSelect(assetType, xpath);
        }
        if (xpath.contains("[")) {
            return this.getFieldSelectWithCond(assetType, xpath);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("extractvalue(sys_nc_rowinfo$, '");
        sb.append(this.getDisplayXpath(assetType, xpath));
        sb.append("')");
        return sb.toString();
    }

    protected String getDisplayXpath(String assetType, String xpath) {
        if (assetType.endsWith("ECMFSpec")) {
            String result = assetType + xpath;
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            return result;
        }
        return this.searchSchemaHelper.prepareSelectXpath(assetType, xpath);
    }

    protected String getCondition(Predicate predicate) {
        return this.getConditionBuilderFactory().getCondition(DBTypeEnum.ORACLE, predicate);
    }

    protected String getAssetCondition(Predicate predicate) {
        return this.getConditionBuilderFactory().getAssetCondition(DBTypeEnum.ORACLE, predicate);
    }

    public void joinOntoMdm(StringBuffer query) {
        query.append(" \r\n");
        query.append("JOIN mdm_metadata ");
        query.append(MDM_ALIAS);
        query.append(SPACEY_ON);
        query.append(" t.mdmdocid   = extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId'))");
    }
}

