/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.RuleManagerDAO;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Rule;
import com.tandbergtv.metadatamanager.model.RuleSet;
import com.tandbergtv.metadatamanager.spec.IRuleManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RuleManagerBase
implements IRuleManager {
    protected String spec;
    private RuleManagerDAO ruleManagerDAO;
    private Map<String, Boolean> defaultRuleSet;

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public RuleManagerDAO getRuleManagerDAO() {
        return this.ruleManagerDAO;
    }

    public void setRuleManagerDAO(RuleManagerDAO ruleManagerDAO) {
        this.ruleManagerDAO = ruleManagerDAO;
    }

    public Map<String, Boolean> getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    public void setDefaultRuleSet(Map<String, Boolean> defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @Override
    public Map<String, Boolean> saveRuleSet(String nameOfRuleSet, Map<String, Boolean> ruleSet) throws MetadataException {
        RuleSet savedRuleSet = null;
        try {
            savedRuleSet = this.ruleManagerDAO.lookupRuleSet(nameOfRuleSet, this.spec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RuleSet rs = new RuleSet();
        if (savedRuleSet != null) {
            rs = new RuleSet(savedRuleSet.getId());
        }
        rs.setName(nameOfRuleSet);
        rs.setSpec(this.spec);
        for (Map.Entry<String, Boolean> entry : ruleSet.entrySet()) {
            Rule r = new Rule();
            r.setXpath(entry.getKey());
            r.setIsRequired(entry.getValue());
            rs.addRule(r);
        }
        try {
            this.ruleManagerDAO.saveRuleSet(rs);
        }
        catch (MetadataException e) {
            throw new MetadataException(e.getMessage());
        }
        return ruleSet;
    }

    @Override
    public Map<String, Boolean> getRuleSet(String nameOfRuleSet) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            Set<Rule> rules = this.ruleManagerDAO.lookupRuleSet(nameOfRuleSet, this.spec).getRules();
            for (Rule rule : rules) {
                map.put(rule.getXpath(), rule.getIsRequired());
            }
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public Map<String, Boolean> getRuleSet() {
        return this.defaultRuleSet;
    }

    @Override
    public List<String> getAllRuleSets() {
        try {
            return this.ruleManagerDAO.getAllRuleSetNames(this.spec);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteRuleSet(String nameOfRuleSet) {
        try {
            long id = this.ruleManagerDAO.lookupRuleSet(nameOfRuleSet, this.spec).getId();
            this.ruleManagerDAO.deleteRuleSet(id);
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
    }
}

