/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.ttv;

import com.tandbergtv.metadatamanager.AssetCopyException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.ChildParentRelation;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.ParentChildRelation;
import com.tandbergtv.metadatamanager.model.Relation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AssetCopier {
    AssetCopier() {
    }

    public Asset copyAssetTree(Asset original, boolean referenceOriginal) throws AssetCopyException {
        return this.copyAsset(original, null, referenceOriginal, new HashMap<Asset, Asset>());
    }

    public void overwriteAssetTreeCopy(Asset original, Asset copy) throws AssetCopyException {
        if (copy == null) {
            throw new IllegalArgumentException("The copy asset to overwrite cannot be null.");
        }
        this.copyAsset(original, copy, true, new HashMap<Asset, Asset>());
    }

    private Asset copyAsset(Asset original, Asset copy, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        if (copiedAssets.containsKey(original)) {
            return copiedAssets.get(original);
        }
        this.validateCopy(original, copy, referenceOriginal);
        if (original.getClass().equals(Group.class)) {
            copy = this.copyGroup((Group)original, (Group)copy);
        } else if (original.getClass().equals(Item.class)) {
            copy = this.copyItem((Item)original, (Item)copy);
        } else if (original.getClass().equals(File.class)) {
            copy = this.copyFile((File)original, (File)copy);
        } else {
            String msg = "Cannot copy asset[" + original.getTTVId() + "] of type: " + original.getClass().getName();
            throw new AssetCopyException(msg);
        }
        if (referenceOriginal) {
            copy.setOriginalAssetID(original.getId());
            copy.setOriginalRevisionNumber(original.getLatestRevisionNumber());
        }
        copiedAssets.put(original, copy);
        this.copyAssetRelations(original, copy, referenceOriginal, copiedAssets);
        return copy;
    }

    private void validateCopy(Asset original, Asset copy, boolean referenceOriginal) throws AssetCopyException {
        Long originalId;
        if (referenceOriginal && !original.getTTVId().isValidIdentifier()) {
            String msg = "The copied asset cannot reference the the original asset since it does not have a valid identifier.";
            throw new AssetCopyException(msg);
        }
        if (copy != null && !copy.getClass().equals(original.getClass())) {
            String msg = "Copied asset[" + copy.getTTVId() + "] is not the same type as original asset[" + original.getTTVId() + "].";
            throw new AssetCopyException(msg);
        }
        if (copy != null && ((originalId = copy.getOriginalAssetID()) == null || originalId.longValue() != original.getId())) {
            String msg = "Copied asset[" + copy.getTTVId() + "] cannot be overwritten by asset[" + original.getTTVId() + "] since it was copied from another asset[" + originalId + "].";
            throw new AssetCopyException(msg);
        }
    }

    private Group copyGroup(Group original, Group copy) throws AssetCopyException {
        String groupType;
        if (copy == null) {
            copy = new Group();
        }
        if ((groupType = original.getType()) != null) {
            copy.setType(groupType);
        }
        this.copyAssetProperties(original, copy);
        return copy;
    }

    private Item copyItem(Item original, Item copy) throws AssetCopyException {
        String itemType;
        if (copy == null) {
            copy = new Item();
        }
        if ((itemType = original.getType()) != null) {
            copy.setType(itemType);
        }
        this.copyAssetProperties(original, copy);
        return copy;
    }

    private File copyFile(File original, File copy) throws AssetCopyException {
        if (copy == null) {
            copy = new File();
        }
        this.copyItem(original, copy);
        return copy;
    }

    private void copyAssetProperties(Asset original, Asset copy) throws AssetCopyException {
        copy.setExternalRevision(original.getExternalRevision());
        copy.setState(original.getState());
        this.copyAssetFields(original, copy);
    }

    private void copyAssetFields(Asset original, Asset copy) {
        List<Field> originalFields;
        HashMap<String, Field> copyFieldMap = new HashMap<String, Field>();
        if (copy.getFields() != null) {
            for (Field copyField : copy.getFields()) {
                copyFieldMap.put(copyField.getTtvXPathWithIndices(), copyField);
            }
            copy.getFields().clear();
        }
        if ((originalFields = original.getFields()) != null) {
            for (Field originalField : originalFields) {
                Field copiedField = this.copyField(originalField, copyFieldMap);
                copy.addField(copiedField);
            }
        }
    }

    private Field copyField(Field originalField, Map<String, Field> copyFieldMap) {
        Field copyField = new Field(originalField);
        copyField.setRoot(null);
        copyField.setParentAsset(null);
        String completeXPath = copyField.getTtvXPathWithIndices();
        Field oldCopyField = copyFieldMap.get(completeXPath);
        if (oldCopyField != null) {
            copyField.setId(oldCopyField.getId());
        }
        return copyField;
    }

    private void copyAssetRelations(Asset original, Asset copy, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        List<Relation> originalRelations;
        ArrayList<Relation> copyRelations = new ArrayList<Relation>();
        if (copy.getRelations() != null) {
            copyRelations.addAll(copy.getRelations());
            copy.getRelations().clear();
        }
        if ((originalRelations = original.getRelations()) != null) {
            for (Relation originalRelation : originalRelations) {
                Relation referenceRelation = referenceOriginal ? this.findReferenceRelation(originalRelation, copyRelations) : null;
                Relation copyRelation = this.copyAssetRelation(original, copy, originalRelation, referenceRelation, referenceOriginal, copiedAssets);
                copy.addRelation(copyRelation);
            }
        }
    }

    private Relation findReferenceRelation(Relation originalRelation, List<Relation> copyRelations) {
        if (!originalRelation.getTargetAsset().getTTVId().isValidIdentifier()) {
            return null;
        }
        Relation match = null;
        long targetId = originalRelation.getTargetAsset().getId();
        for (Relation copyRelation : copyRelations) {
            Long copiedFromTargetId;
            if (!originalRelation.getClass().equals(copyRelation.getClass()) || (copiedFromTargetId = copyRelation.getTargetAsset().getOriginalAssetID()) == null || copiedFromTargetId != targetId) continue;
            match = copyRelation;
            break;
        }
        return match;
    }

    private Relation copyAssetRelation(Asset original, Asset copy, Relation originalRelation, Relation referenceRelation, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        Relation copyRelation = null;
        if (originalRelation.getClass().equals(ParentChildRelation.class)) {
            copyRelation = this.copyParentChildRelation(original, copy, (ParentChildRelation)originalRelation, (ParentChildRelation)referenceRelation, referenceOriginal, copiedAssets);
        } else if (originalRelation.getClass().equals(ChildParentRelation.class)) {
            copyRelation = this.copyChildParentRelation(original, copy, (ChildParentRelation)originalRelation, (ChildParentRelation)referenceRelation, referenceOriginal, copiedAssets);
        } else {
            String msg = "Cannot copy asset[" + original.getTTVId() + "], unable to copy relation of type: " + original.getClass().getName();
            throw new AssetCopyException(msg);
        }
        return copyRelation;
    }

    private ParentChildRelation copyParentChildRelation(Asset original, Asset copy, ParentChildRelation originalRelation, ParentChildRelation referenceRelation, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        ParentChildRelation copyRelation = new ParentChildRelation();
        this.copyRelationProperties(original, copy, originalRelation, copyRelation, referenceRelation, referenceOriginal, copiedAssets);
        return copyRelation;
    }

    private ChildParentRelation copyChildParentRelation(Asset original, Asset copy, ChildParentRelation originalRelation, ChildParentRelation referenceRelation, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        ChildParentRelation copyRelation = new ChildParentRelation();
        this.copyRelationProperties(original, copy, originalRelation, copyRelation, referenceRelation, referenceOriginal, copiedAssets);
        return copyRelation;
    }

    private void copyRelationProperties(Asset original, Asset copy, Relation originalRelation, Relation copyRelation, Relation referenceRelation, boolean referenceOriginal, Map<Asset, Asset> copiedAssets) throws AssetCopyException {
        copyRelation.setOwnerAsset(copy);
        copyRelation.setDirection(originalRelation.getDirection());
        Asset originalTarget = originalRelation.getTargetAsset();
        Asset copyTarget = referenceRelation != null ? referenceRelation.getTargetAsset() : null;
        copyTarget = this.copyAsset(originalTarget, copyTarget, referenceOriginal, copiedAssets);
        copyRelation.setTargetAsset(copyTarget);
    }
}

