/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.sql;

import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.sql.AbstractSQLBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectBuilder
extends AbstractSQLBuilder {
    private List<String> columns = new ArrayList<String>();
    private List<String> tables = new ArrayList<String>();
    private List<String> joins = new ArrayList<String>();
    private List<String> leftJoins = new ArrayList<String>();
    private List<String> wheres = new ArrayList<String>();
    private List<String> orderBys = new ArrayList<String>();
    private List<String> groupBys = new ArrayList<String>();
    private List<String> havings = new ArrayList<String>();

    public SelectBuilder() {
    }

    public SelectBuilder(String table) {
        this.tables.add(table);
    }

    public SelectBuilder column(String name) {
        this.columns.add(name);
        return this;
    }

    public SelectBuilder column(String name, boolean groupBy) {
        this.columns.add(name);
        if (groupBy) {
            this.groupBys.add(name);
        }
        return this;
    }

    public SelectBuilder from(String table) {
        this.tables.add(table);
        return this;
    }

    public SelectBuilder groupBy(String expr) {
        this.groupBys.add(expr);
        return this;
    }

    public SelectBuilder having(String expr) {
        this.havings.add(expr);
        return this;
    }

    public SelectBuilder join(String join) {
        this.joins.add(join);
        return this;
    }

    public SelectBuilder leftJoin(String join) {
        this.leftJoins.add(join);
        return this;
    }

    public SelectBuilder orderBy(String name) {
        this.orderBys.add(name);
        return this;
    }

    @Override
    public String build() {
        if (this.tables.isEmpty()) {
            throw new IllegalArgumentException("table cannot be empty.");
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder sql = new StringBuilder("select ");
        if (this.columns.size() == 0) {
            sql.append("*");
        } else {
            this.appendList(sql, this.columns, "", ", ");
        }
        this.appendList(sql, this.tables, " from ", ", ");
        this.appendList(sql, this.joins, " join ", " join ");
        this.appendList(sql, this.leftJoins, " left join ", " left join ");
        this.appendList(sql, this.wheres, " where ", " and ");
        this.appendList(sql, this.groupBys, " group by ", ", ");
        this.appendList(sql, this.havings, " having ", " and ");
        this.appendList(sql, this.orderBys, " order by ", ", ");
        return sql.toString();
    }

    public SelectBuilder where(String expr) {
        this.wheres.add(expr);
        return this;
    }

    public SelectBuilder where(SearchCriteria criteria) {
        Iterator iter = criteria.entrySet().iterator();
        while (iter.hasNext()) {
            this.wheres.add((String)iter.next().getKey() + "= ?");
        }
        return this;
    }
}

