/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeCodeUtil {
    private static TimeCodeUtil instance;
    private String nptRegex;
    private String smpteRegex;
    private static String BOS;
    private static String EOS;
    private static float BOS_FLOAT_VALUE;
    private static float EOS_FLOAT_VALUE;
    private static int PRECISION;
    private static int DEFAULT_FRAME_RATE;

    public static synchronized TimeCodeUtil getInstance() {
        if (instance == null) {
            instance = new TimeCodeUtil();
        }
        return instance;
    }

    private TimeCodeUtil() {
        SearchSchemaHelper helper = new SearchSchemaHelper();
        String simpleTypeName = "NPTTimeCodeType";
        List<String> regexs = helper.getRegexsForSimpleType(simpleTypeName);
        if (!regexs.isEmpty()) {
            this.nptRegex = regexs.get(0);
        }
        if (!(regexs = helper.getRegexsForSimpleType(simpleTypeName = "SMPTETimeCodeType")).isEmpty()) {
            this.smpteRegex = regexs.get(0);
        }
    }

    public boolean isNPT(String timeCode) {
        Pattern p = Pattern.compile(this.nptRegex);
        Matcher m = p.matcher(timeCode);
        return m.matches();
    }

    public boolean isSMPTE(String timeCode) {
        Pattern p = Pattern.compile(this.smpteRegex);
        Matcher m = p.matcher(timeCode);
        return m.matches();
    }

    public boolean isBOS(String timeCode) {
        return timeCode.trim().equalsIgnoreCase(BOS);
    }

    public boolean isEOS(String timeCode) {
        return timeCode.trim().equalsIgnoreCase(EOS);
    }

    public boolean isTimeCode(String value) {
        if (this.isSMPTE(value)) {
            return true;
        }
        return this.isNPT(value);
    }

    public float toSeconds(String tcValue) {
        int frameRate = DEFAULT_FRAME_RATE;
        return this.toSeconds(tcValue, frameRate);
    }

    public float toSeconds(String tcValue, int frameRate) {
        float floatValue = -1.0f;
        if (TimeCodeUtil.getInstance().isBOS(tcValue)) {
            floatValue = BOS_FLOAT_VALUE;
        } else if (this.isEOS(tcValue)) {
            floatValue = EOS_FLOAT_VALUE;
        } else if (this.isNPT(tcValue)) {
            floatValue = this.getFixedPrecisionFloat(tcValue);
        } else if (this.isSMPTE(tcValue)) {
            String[] tcArray = tcValue.split(":");
            int hours = Integer.parseInt(tcArray[0]) * 60 * 60;
            int minutes = Integer.parseInt(tcArray[1]) * 60;
            int seconds = Integer.parseInt(tcArray[2]);
            float frames = (float)Integer.parseInt(tcArray[3]) * (1.0f / (float)frameRate);
            floatValue = this.getFixedPrecisionFloat((float)(hours + minutes + seconds) + frames);
        }
        return floatValue;
    }

    private float getFixedPrecisionFloat(String strNum) {
        return this.getFixedPrecisionFloat(Float.parseFloat(strNum));
    }

    public float getFixedPrecisionFloat(float num) {
        BigDecimal bd = new BigDecimal(num);
        BigDecimal bdFixePrecision = bd.setScale(PRECISION, RoundingMode.HALF_UP);
        return bdFixePrecision.floatValue();
    }

    public String toSMPTE(float nptValue, int frameRate) {
        int timeInSeconds = (int)nptValue;
        float frameFaction = this.getFixedPrecisionFloat(nptValue - (float)timeInSeconds);
        int hours = timeInSeconds / 3600;
        int secondsLeft = timeInSeconds - hours * 3600;
        int minutes = secondsLeft / 60;
        int seconds = secondsLeft - minutes * 60;
        int frame = Math.round(frameFaction * (float)frameRate);
        return this.padWitZero(hours) + ":" + this.padWitZero(minutes) + ":" + this.padWitZero(seconds) + ":" + this.padWitZero(frame);
    }

    private String padWitZero(int num) {
        if (num > 9) {
            return "" + num;
        }
        return "0" + num;
    }

    static {
        BOS = "BOS";
        EOS = "EOS";
        BOS_FLOAT_VALUE = 0.0f;
        EOS_FLOAT_VALUE = 1000000.0f;
        PRECISION = 3;
        DEFAULT_FRAME_RATE = 30;
    }
}

