/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AdvancedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AdvancedProperties.class);

    public boolean loadFromFile(String fileName) {
        try {
            this.load(new FileInputStream(fileName));
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug((Object)ex);
            return false;
        }
    }

    public boolean loadFromClassPath(String path) {
        InputStream is;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((is = this.getClass().getClassLoader().getResourceAsStream(path)) == null) {
            return false;
        }
        try {
            this.load(is);
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug((Object)ex);
            return false;
        }
    }

    public String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property key is null");
        }
        String strVal = this.getProperty(key);
        if (strVal == null) {
            throw new IllegalArgumentException("Invalid property key '" + key + "'");
        }
        return strVal;
    }

    public int getInt(String key, String label) {
        String strVal = this.getString(key);
        try {
            return Integer.parseInt(strVal.trim());
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid " + label + " '" + strVal + "'");
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }
}

