/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.es;

import com.ericsson.neptune.es.ConfigurationException;
import com.ericsson.neptune.es.PropsUtil;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;

public class ESSettings {
    private static final String DEFAULT_CLUSTER_NAME = "cms";
    private static final int DEFAULT_TRANSPORT_PORT = 9300;
    private static final int DEFAULT_HTTP_PORT = 9200;
    private static final int DEFAULT_READ_TIMEOUT = 15;
    private static final int DEFAULT_WRITE_TIMEOUT = 15;
    private String clusterName = "cms";
    private int transportPort = 9300;
    private int httpPort = 9200;
    private int readTimeoutSec = 15;
    private int writeTimeoutSec = 15;

    public ESSettings() {
    }

    public ESSettings(String propFileName) {
        if (propFileName == null) {
            return;
        }
        File file = new File(propFileName);
        if (!file.exists()) {
            return;
        }
        FileReader rd = null;
        try {
            rd = new FileReader(file);
            Properties props = new Properties();
            props.load(rd);
            this.clusterName = PropsUtil.readString(props, "cluster.name", DEFAULT_CLUSTER_NAME);
            this.transportPort = PropsUtil.readPositiveInt(props, "port.transport", 9300);
            this.httpPort = PropsUtil.readPositiveInt(props, "port.http", 9200);
            this.readTimeoutSec = PropsUtil.readPositiveInt(props, "timeout.read", 15);
            this.writeTimeoutSec = PropsUtil.readPositiveInt(props, "timeout.write", 15);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Could not read ElasticSearch settings from " + propFileName, ex);
        }
        finally {
            this.close(rd);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getTransportPort() {
        return this.transportPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getReadTimeoutSec() {
        return this.readTimeoutSec;
    }

    public int getWriteTimeoutSec() {
        return this.writeTimeoutSec;
    }

    public long getReadTimeoutMs() {
        return this.readTimeoutSec * 1000;
    }

    public long getWriteTimeoutMs() {
        return this.writeTimeoutSec * 1000;
    }

    private void close(FileReader rd) {
        if (rd == null) {
            return;
        }
        try {
            rd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

