/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.es;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ESUtil {
    private static Logger LOGGER = Logger.getLogger(ESUtil.class);
    private static final String ES_NODES_DNS = "es-nodes.service";

    private ESUtil() {
    }

    public static Set<String> discoverNodes() throws UnknownHostException {
        HashSet<String> set = new HashSet<String>();
        InetAddress[] array = InetAddress.getAllByName(ES_NODES_DNS);
        if (array != null) {
            for (InetAddress addr : array) {
                set.add(addr.getHostAddress());
            }
        }
        return set;
    }

    public static boolean updateTransportAddresses(TransportClient client, int port) {
        Set<String> newNodes;
        try {
            newNodes = ESUtil.discoverNodes();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Could not discover ES nodes.", (Throwable)ex);
            return false;
        }
        for (TransportAddress addr : client.transportAddresses()) {
            if (newNodes.contains(addr.getHost()) && addr.getPort() == port) {
                newNodes.remove(addr.getHost());
                continue;
            }
            client.removeTransportAddress(addr);
            LOGGER.info((Object)("Removed address " + addr.getHost() + ":" + addr.getPort()));
        }
        for (String ip : newNodes) {
            InetSocketTransportAddress addr = new InetSocketTransportAddress(new InetSocketAddress(ip, port));
            client.addTransportAddress((TransportAddress)addr);
            LOGGER.info((Object)("Added address " + ip + ":" + port));
        }
        return true;
    }
}

