/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.factory;

import com.ericsson.cms.neptune.rabbitmq.factory.IChannelFactory;
import com.ericsson.cms.neptune.rabbitmq.service.ChannelConfiguationPolicy;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ThreadLocalChannelFactory
implements IChannelFactory {
    private static final Logger LOGGER = Logger.getLogger(ThreadLocalChannelFactory.class);
    private static ThreadLocal<Channel> channels;

    public ThreadLocalChannelFactory(Connection connection) {
        this(connection, null);
    }

    public ThreadLocalChannelFactory(final Connection connection, final ChannelConfiguationPolicy policy) {
        channels = new ThreadLocal<Channel>(){

            @Override
            protected Channel initialValue() {
                try {
                    Channel c = connection.createChannel();
                    if (policy != null) {
                        policy.configure(c);
                    }
                    return c;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Fail to create channel", (Throwable)e);
                    return null;
                }
            }
        };
    }

    @Override
    public Channel getChannel() throws IOException {
        Channel channel = channels.get();
        if (channel != null && !channel.isOpen()) {
            channels.remove();
            channel = channels.get();
        }
        return channel;
    }

    @Override
    public void removeChannel(Channel channel) {
        if (channel == channels.get()) {
            channels.remove();
        }
    }
}

