/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.sender;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.util.IMQConfiguration;
import com.ericsson.cms.neptune.rabbitmq.util.MQPropertyLoader;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class MessageSender
implements IMessageSender {
    private static final int DEFAULT_WAIT_FOR_CONFIRM_MS = 5000;
    private static final Logger LOGGER = Logger.getLogger(MessageSender.class);
    private IRabbitMQService mqService;
    private MQPropertyLoader propertyLoader;
    private int waitForConfirmMilli = 5000;

    public MessageSender(IRabbitMQService mqService, MQPropertyLoader propertyLoader) {
        this.mqService = mqService;
        this.propertyLoader = propertyLoader;
        this.loadWaitForConfirmSetting();
    }

    @Override
    public void start() {
        if (this.mqService == null) {
            throw new IllegalStateException("RabbitMQService is not initialized yet, failed to start MessageSender.");
        }
        this.mqService.start();
    }

    protected void loadWaitForConfirmSetting() {
        this.waitForConfirmMilli = this.propertyLoader.getWaitForConfirm(5000);
    }

    @Override
    public void stop() {
        if (this.mqService != null) {
            this.mqService.stop();
        }
    }

    @Override
    public void recoverConnection() {
        this.mqService.recoverConnection();
    }

    private Channel openChannel() {
        try {
            Channel channel = this.mqService.getChannel();
            channel.confirmSelect();
            return channel;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Errors in configration channel. ", (Throwable)e);
            return null;
        }
    }

    private void closeChannel(Channel channel) {
        try {
            this.mqService.releaseChannel(channel);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Errors in configration channel. ", (Throwable)e);
        }
    }

    @Override
    public Boolean send(String exchange, String message) {
        return this.send(exchange, MessageProperties.PERSISTENT_TEXT_PLAIN, message);
    }

    @Override
    public Boolean send(String exchange, int priority, String message) {
        AMQP.BasicProperties properties = MessageProperties.PERSISTENT_TEXT_PLAIN.builder().priority(Integer.valueOf(priority)).build();
        return this.send(exchange, properties, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean send(String exchange, AMQP.BasicProperties properties, String message) {
        Boolean isAcked;
        Channel channel = null;
        try {
            channel = this.openChannel();
            LOGGER.debug((Object)("Message deliverying ... to exchange:" + exchange));
            boolean mandatoryDelivered = true;
            channel.basicPublish(exchange, "", mandatoryDelivered, properties, message.getBytes());
            isAcked = channel.waitForConfirms(5000L);
            LOGGER.debug((Object)("Message delivered. ack:" + isAcked));
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (ShutdownSignalException e) {
            throw new AlreadyClosedException(e);
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            LOGGER.error((Object)"Errors while publishing message message to RabbitMQ.", (Throwable)e);
            isAcked = Boolean.FALSE;
        }
        finally {
            this.closeChannel(channel);
        }
        return isAcked;
    }

    public void setMqService(IRabbitMQService mqService) {
        this.mqService = mqService;
    }

    public int getWaitForConfirmMilli() {
        return this.waitForConfirmMilli;
    }

    public void setWaitForConfirmMilli(int waitForConfirmMilli) {
        this.waitForConfirmMilli = waitForConfirmMilli;
    }

    @Override
    public IMQConfiguration getMQConfiguration() {
        return this.propertyLoader;
    }
}

