/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.ericsson.cms.devices.content.CategoryMessageDispatcher;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class AssociateTitleMessageDispatcher
extends CategoryMessageDispatcher {
    private static final String CATEGORY_TITLE_ID = "categoryTitleId";
    private static final String CATEGORY_PATH = "categoryPath";

    public AssociateTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage message) {
        try {
            this.validateRequired(message, CATEGORY_TITLE_ID, CATEGORY_PATH);
        }
        catch (Exception e) {
            throw new RuntimeException("Title Id and Category Path are required fields.");
        }
        try {
            String titleIdStr = this.getMessageParameter(message, CATEGORY_TITLE_ID);
            long titleId = Long.parseLong(titleIdStr);
            ITitleManager titleService = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
            if (!titleService.isActive(Long.valueOf(titleId))) {
                throw new RuntimeException("Title is not active");
            }
            IContentClassService ccService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
            if (!ccService.isCategoryPackage(titleId)) {
                throw new RuntimeException("Can not associate Category to a Non-Category Title");
            }
            ICategoryManager service = (ICategoryManager)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManager.class);
            String categoryPathStr = this.getMessageParameter(message, CATEGORY_PATH);
            service.associateCategoryPackage(titleId, categoryPathStr, false, true);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Title Id must be a numeric value.");
        }
        catch (Exception e) {
            String msg = "Failed to associate category to title : " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }
}

