/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ListProxyImpl
extends AbstractList
implements IList,
DataSerializable,
HazelcastInstanceAwareInstance {
    String name;
    FactoryImpl factory;

    public ListProxyImpl() {
    }

    public ListProxyImpl(String name, FactoryImpl factory) {
        this.name = "q:" + name;
        this.factory = factory;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LIST;
    }

    public void destroy() {
        this.factory.destroyProxy(new FactoryImpl.ProxyKey(this.name, null));
    }

    public Object getId() {
        return this.name;
    }

    public int size() {
        return this.factory.node.blockingQueueManager.size(this.name);
    }

    public boolean contains(Object o) {
        Set<Long> keys = this.factory.node.blockingQueueManager.getValueKeys(this.name, IOUtil.toData(o));
        return keys != null && keys.size() > 0;
    }

    public Iterator iterator() {
        return this.factory.node.blockingQueueManager.iterate(this.name);
    }

    public boolean add(Object o) {
        return this.factory.node.blockingQueueManager.add(this.name, o, Integer.MAX_VALUE);
    }

    public boolean remove(Object o) {
        return this.factory.node.blockingQueueManager.remove(this.name, o);
    }

    public boolean addAll(Collection c) {
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    public Object get(int index) {
        return this.factory.node.blockingQueueManager.getItemByIndex(this.name, index);
    }

    public Object set(int index, Object element) {
        return this.factory.node.blockingQueueManager.set(this.name, element, index);
    }

    public void add(int index, Object element) {
        try {
            this.factory.node.blockingQueueManager.offer(this.name, element, index, 0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Object remove(int index) {
        return this.factory.node.blockingQueueManager.remove(this.name, index);
    }

    public int indexOf(Object o) {
        return this.factory.node.blockingQueueManager.getIndexOf(this.name, o, true);
    }

    public int lastIndexOf(Object o) {
        return this.factory.node.blockingQueueManager.getIndexOf(this.name, o, false);
    }

    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    public String getName() {
        return this.name.substring(4);
    }

    public void addItemListener(ItemListener itemListener, boolean includeValue) {
        this.factory.node.blockingQueueManager.addItemListener(this.name, itemListener, includeValue);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.factory.node.blockingQueueManager.removeItemListener(this.name, itemListener);
    }

    public String toString() {
        return "List [" + this.getName() + "] ";
    }
}

