/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.TitleSearchPropertiesProvider;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.cms.title.search.entities.TitleSearchResultColumn;
import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.XpathNodeCardinality;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import com.tandbergtv.watchpoint.pmm.title.search.ExportHelper;
import com.tandbergtv.watchpoint.pmm.title.search.SearchPartnerProvider;
import com.tandbergtv.watchpoint.pmm.util.TableConfigHelper;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class ExecuteSavedSearchMessageHandler
extends ContentMessageDispatcher {
    private static final int MAX_RECORDS = 1000;
    private static String SAVED_SEARCH_ID = "searchId";
    private static String EXPORT_FILE_NAME = "resultsFilename";
    private static String SUCCESS = "success";
    private static String QUICK_INFO = "quickInfo";
    private static String SEARCH_RESULTS_TABLE = "SearchResultsColumns";
    private static String SERIES_SEARCH_RESULTS_TABLE = "SeriesSearchResultsColumns";
    private static String QUICK_SEARCH_TABLE = "quickInfoSearchColumns";
    private static String THUMBNAIL_COLUMN = "thumbnail";
    private static String ASSET_TYPE_IN_TABLE_COLUMN = "TitleSection";
    private static String TITLE_ID = "id";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public ExecuteSavedSearchMessageHandler(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)ExecuteSavedSearchMessageHandler.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), ExecuteSavedSearchMessageHandler.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private boolean isSeriesSearch(TitleSearch ts) {
        for (int i = 0; i < ts.getDisplayCols().size(); ++i) {
            boolean isSeries;
            TitleSearchResultColumn col = (TitleSearchResultColumn)ts.getDisplayCols().get(i);
            boolean bl = isSeries = col.getName().startsWith("SERIES/") || col.getName().startsWith("SERIES|");
            if (!isSeries) continue;
            return true;
        }
        return false;
    }

    private List<TitleSearchResultColumn> removeThumbnail(List<TitleSearchResultColumn> displayCols) {
        ArrayList<TitleSearchResultColumn> withoutThumnail = new ArrayList<TitleSearchResultColumn>();
        for (int i = 0; i < displayCols.size(); ++i) {
            if (displayCols.get(i).getName().equals(THUMBNAIL_COLUMN)) continue;
            TitleSearchResultColumn dc = displayCols.get(i);
            TitleSearchResultColumn c = new TitleSearchResultColumn(dc.getId(), dc.getName(), dc.getOrder(), dc.getTs());
            withoutThumnail.add(c);
        }
        return withoutThumnail;
    }

    private List<ExportHelper.ColumnInfo> convertSelectedColumnToColumnInfo(List<TitleSearchResultColumn> displayCols, List<Column> allDisplayColumns) {
        ArrayList<ExportHelper.ColumnInfo> displayColInfo = new ArrayList<ExportHelper.ColumnInfo>();
        for (TitleSearchResultColumn sc : displayCols) {
            String dataType;
            String fieldName;
            String sectionType;
            FieldType fieldType;
            String name = sc.getName();
            boolean isMultiValued = false;
            if (name.contains("|")) {
                fieldType = FieldType.ASSET;
                String[] split = name.split("\\|");
                sectionType = split[0];
                fieldName = split[1];
                isMultiValued = this.isMultiField(sectionType, fieldName);
                dataType = DataTypeMappingReader.getInstance().determineDataType(fieldName);
            } else {
                fieldType = FieldType.PMM_TITLE;
                sectionType = "";
                fieldName = name;
                dataType = fieldName.equals(TITLE_ID) ? "integer" : "string";
            }
            String displayName = "";
            for (Column c : allDisplayColumns) {
                String colAssetType = "";
                String colField = "";
                if (c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN) != null) {
                    colAssetType = c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN);
                    colField = c.getParameter();
                } else {
                    colField = c.getMethodName();
                }
                if (!colAssetType.equals(sectionType) || !colField.equals(fieldName)) continue;
                displayName = c.getColumnName();
            }
            displayColInfo.add(new ExportHelper.ColumnInfo(displayName, false, fieldName, sectionType, fieldType, dataType, isMultiValued));
        }
        return displayColInfo;
    }

    private boolean isMultiField(String sectionType, String fieldName) {
        List nodes = new SearchSchemaHelper().getXpathCardinality(sectionType, fieldName);
        for (int i = sectionType.split("/").length; i < nodes.size(); ++i) {
            if (((XpathNodeCardinality)nodes.get(i)).getCardinality() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean searchContainsQuickInfo(List<TitleSearchResultColumn> displayCols) {
        for (TitleSearchResultColumn dc : displayCols) {
            if (!dc.getName().equals(QUICK_INFO)) continue;
            return true;
        }
        return false;
    }

    private List<ExportHelper.ColumnInfo> convertColumnToColumnInfo(List<Column> columns, boolean isQuickInfoCols) {
        ArrayList<ExportHelper.ColumnInfo> infos = new ArrayList<ExportHelper.ColumnInfo>();
        for (int i = 0; i < columns.size(); ++i) {
            String dataType;
            FieldType fieldType;
            Column c = columns.get(i);
            String displayName = c.getColumnName();
            String assetType = "";
            String fieldName = "";
            boolean multiValue = false;
            if (c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN) != null) {
                assetType = c.getColumnAttribute(ASSET_TYPE_IN_TABLE_COLUMN);
                fieldName = c.getParameter();
                fieldType = FieldType.ASSET;
                dataType = DataTypeMappingReader.getInstance().determineDataType(fieldName);
                multiValue = this.isMultiField(assetType, fieldName);
            } else {
                fieldName = c.getMethodName();
                fieldType = FieldType.ASSET;
                dataType = fieldName.equals(TITLE_ID) ? "integer" : "string";
            }
            infos.add(new ExportHelper.ColumnInfo(displayName, isQuickInfoCols, fieldName, assetType, fieldType, dataType, multiValue));
        }
        return infos;
    }

    private List<ExportHelper.ColumnInfo> replaceQuickInfoColumn(List<ExportHelper.ColumnInfo> displayCols, List<ExportHelper.ColumnInfo> qInfoCols) {
        ArrayList<ExportHelper.ColumnInfo> allColumns = new ArrayList<ExportHelper.ColumnInfo>();
        for (int i = 0; i < displayCols.size(); ++i) {
            ExportHelper.ColumnInfo c = displayCols.get(i);
            if (c.getFieldName().equals(QUICK_INFO)) {
                for (int j = 0; j < qInfoCols.size(); ++j) {
                    ExportHelper.ColumnInfo info = qInfoCols.get(j);
                    allColumns.add(new ExportHelper.ColumnInfo(info.getDisplayName(), true, info.getFieldName(), info.getSectionType(), info.getFieldType(), info.getDataType(), info.isMultiValue()));
                }
                continue;
            }
            allColumns.add(c);
        }
        return allColumns;
    }

    private Table getTable(String tableName) {
        TableConfig configuration = TableConfig.getInstance();
        HashMap<String, String> runtimeProperties = new HashMap<String, String>();
        runtimeProperties.put("specificationName", "UI");
        File tableFile = TableConfigHelper.getTableConfigFile();
        return configuration.getTable(tableName, tableFile, runtimeProperties);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(ExecuteSavedSearchMessageHandler this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{SAVED_SEARCH_ID, EXPORT_FILE_NAME});
        Integer searchId = Integer.valueOf(Util.getStringValueTrimmed((WorkflowMessage)request, (String)SAVED_SEARCH_ID));
        String resultsFileName = Util.getStringValueTrimmed((WorkflowMessage)request, (String)EXPORT_FILE_NAME);
        ITitleSearchPersistenceService tsps = (ITitleSearchPersistenceService)ServiceRegistry.getDefault().lookup(ITitleSearchPersistenceService.class);
        File output = new File(resultsFileName);
        FileOutputStream fs = null;
        OutputStreamWriter osw = null;
        try {
            fs = new FileOutputStream(output);
            TitleSearch ts = tsps.getTitleSearch((Serializable)searchId);
            String tablename = this_.isSeriesSearch(ts) ? SERIES_SEARCH_RESULTS_TABLE : SEARCH_RESULTS_TABLE;
            List allDisplayColumns = this_.getTable(tablename).getColumns();
            List<TitleSearchResultColumn> savedSearchColumns = this_.removeThumbnail(ts.getDisplayCols());
            List<ExportHelper.ColumnInfo> selectedDisplayColumns = this_.convertSelectedColumnToColumnInfo(savedSearchColumns, allDisplayColumns);
            if (this_.searchContainsQuickInfo(ts.getDisplayCols())) {
                List quickInfoColumns = this_.getTable(QUICK_SEARCH_TABLE).getColumns();
                List<ExportHelper.ColumnInfo> qColInfo = this_.convertColumnToColumnInfo(quickInfoColumns, true);
                selectedDisplayColumns = this_.replaceQuickInfoColumn(selectedDisplayColumns, qColInfo);
            }
            ArrayList<ExportHelper.ColumnInfo> scs = new ArrayList<ExportHelper.ColumnInfo>();
            for (ExportHelper.ColumnInfo ci : selectedDisplayColumns) {
                scs.add(ci);
            }
            ExportHelper exportHelper = new ExportHelper((OutputStream)fs, UTF8, selectedDisplayColumns);
            exportHelper.addHeader();
            List partnerIds = SearchPartnerProvider.getParnterIds((String)ts.getUserName());
            ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
            ts.getFilter().setPageInfo(new PagingInfo(0, 1000));
            int maxTitlesAtOnce = TitleSearchPropertiesProvider.getMaxTitlesFetchSize();
            TitleSearchResult searchResults = searchService.getSearchResults(ts.getFilter(), partnerIds, scs);
            for (TitleSearchResult.SearchRow row : searchResults.getRows()) {
                exportHelper.handleRecord(row);
            }
            WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
            response.putValue(SUCCESS, "true");
            WorkflowMessage workflowMessage = response;
            return workflowMessage;
        }
        catch (TitleSearchNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnauthorizedUserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.flush();
                    osw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(ExecuteSavedSearchMessageHandler this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ExecuteSavedSearchMessageHandler.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = ExecuteSavedSearchMessageHandler.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

