/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.devices.content.action.SearchBaseMessageDispatcher;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.metadatamanager.exception.SearchValidationException;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.List;

public class SearchMessageDispatcher
extends SearchBaseMessageDispatcher {
    private static String MATCHING_TITLE_IDS = "titleIds";
    private static String MATCHING_TITLE_IDS_COUNT = "matchingTitleCount";

    public SearchMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage getResponseMessage(ExpNode searchFields, WorkflowMessage message) {
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        ArrayList<Long> titleIds = new ArrayList();
        try {
            titleIds = service.getTitleIds(searchFields);
        }
        catch (Exception e) {
            String msg = "";
            msg = e instanceof SearchValidationException ? "Failed to search for titles: " + e.getMessage() : "Failed to search for titles: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        return this.buildResponse(message, titleIds);
    }

    private WorkflowMessage buildResponse(WorkflowMessage message, List<Long> titleIds) {
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer sb = new StringBuffer();
        int matchingTitleCount = 0;
        for (long id : titleIds) {
            ++matchingTitleCount;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id);
        }
        response.putValue(MATCHING_TITLE_IDS, sb.toString());
        response.putValue(MATCHING_TITLE_IDS_COUNT, String.valueOf(matchingTitleCount));
        return response;
    }

    @Override
    protected void validateRequest(WorkflowMessage message) {
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{FIELD_1_XPATH, FIELD_1_ASSET_TYPE, FIELD_1_VALUE});
        }
        catch (Exception e) {
            throw new RuntimeException("At least 1 search field must be provided.");
        }
    }
}

