/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.devices.content.action.SearchBaseMessageDispatcher;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.Arrays;
import java.util.List;

public class SeriesSearchMessageDispatcher
extends SearchBaseMessageDispatcher {
    private static String SERIES_IDS = "seriesIds";
    private static String MATCHING_SERIES_COUNT = "matchingSeriesCount";
    private static int MAX_RESULT_COUNT = 1000;

    public SeriesSearchMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage getResponseMessage(ExpNode searchFields, WorkflowMessage message) {
        TitleFilter filter = new TitleFilter(searchFields);
        filter.setCriteriaMode(CriteriaMode.SERIES);
        filter.setPageInfo(new PagingInfo(0, MAX_RESULT_COUNT));
        List<SearchColumn> searchColumns = Arrays.asList(new SearchColumn(null, "documentId", FieldType.PMM_TITLE, "integer", false));
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        try {
            TitleSearchResult result = service.getSearchResults(filter, null, searchColumns);
            List seriesRecords = result == null ? null : result.getRows();
            return this.buildResponse(message, seriesRecords);
        }
        catch (Exception e) {
            String msg = "Failed to search for series: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    private WorkflowMessage buildResponse(WorkflowMessage message, List<TitleSearchResult.SearchRow> seriesRecords) {
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        if (seriesRecords == null) {
            return new WorkflowMessage(uid, key, WorkflowMessage.MessageType.nack);
        }
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer seriesIds = new StringBuffer();
        int matchingSeriesCount = seriesRecords.size();
        for (TitleSearchResult.SearchRow series : seriesRecords) {
            if (seriesIds.length() > 0) {
                seriesIds.append(",");
            }
            seriesIds.append(series.getFields().get(0));
        }
        response.putValue(SERIES_IDS, seriesIds.toString());
        response.putValue(MATCHING_SERIES_COUNT, String.valueOf(matchingSeriesCount));
        return response;
    }

    @Override
    protected void validateRequest(WorkflowMessage message) {
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{FIELD_1_XPATH, FIELD_1_ASSET_TYPE, FIELD_1_VALUE});
        }
        catch (Exception e) {
            throw new RuntimeException("At least 1 search field must be provided.");
        }
        Util.validateMetadataDateField((WorkflowMessage)message, (String)FIELD_1_XPATH, (String)FIELD_1_ASSET_TYPE, (String)FIELD_1_VALUE);
        Util.validateMetadataDateField((WorkflowMessage)message, (String)FIELD_2_XPATH, (String)FIELD_2_ASSET_TYPE, (String)FIELD_2_VALUE);
        Util.validateMetadataDateField((WorkflowMessage)message, (String)FIELD_3_XPATH, (String)FIELD_3_ASSET_TYPE, (String)FIELD_3_VALUE);
        Util.validateMetadataDateField((WorkflowMessage)message, (String)FIELD_4_XPATH, (String)FIELD_4_ASSET_TYPE, (String)FIELD_4_VALUE);
        Util.validateMetadataDateField((WorkflowMessage)message, (String)FIELD_5_XPATH, (String)FIELD_5_ASSET_TYPE, (String)FIELD_5_VALUE);
    }
}

