/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class TitleSeriesAssnMessageDispatcher
extends ContentMessageDispatcher {
    private static String TITLE_ID = "titleId";
    private static String SERIES_ID = "seriesId";
    private static String SEASON_ID = "seasonId";

    public TitleSeriesAssnMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage message) {
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{TITLE_ID, SERIES_ID});
        }
        catch (Exception e) {
            throw new RuntimeException("One or more required parameters are missing.");
        }
        Long titleId = null;
        Long seriesId = null;
        Long seasonId = null;
        try {
            titleId = Util.getLongValue((WorkflowMessage)message, (String)TITLE_ID);
            seriesId = Util.getLongValue((WorkflowMessage)message, (String)SERIES_ID);
            if (titleId == null || seriesId == null) {
                throw new RuntimeException("Title Id and Series Id are required. Only numeric values are allowed.");
            }
            String seasonIdStr = Util.getStringValueTrimmed((WorkflowMessage)message, (String)SEASON_ID);
            if (seasonIdStr != null && seasonIdStr.length() > 0) {
                seasonId = Util.getLongValue((WorkflowMessage)message, (String)SEASON_ID);
            }
        }
        catch (NumberFormatException ne) {
            throw new RuntimeException("Invald input. Only numeric values are allowed for Title Id, Series Id. Season Id is optional and can be null, but if present must be numeric.");
        }
        ITitleManager service = this.getTitleManager();
        try {
            service.associateTitleToSeries(titleId, seriesId, seasonId, this.getActionSource(message));
        }
        catch (Exception e) {
            String msg = "Failed to attach series info to title: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }
}

