/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.custom;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static Date validateAndGetDate(String paramName, String dateValue) {
        Date result = null;
        if (dateValue == null || dateValue.trim().length() == 0) {
            throw new RuntimeException("The " + paramName + " message parameter is blank / missing when a date value was expected.");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            result = format.parse(dateValue);
            if (!format.format(result).equals(dateValue)) {
                throw new RuntimeException("The " + paramName + " message parameter does not have a valid date value. Expected format: " + DATE_FORMAT + ", received value: " + dateValue);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("The " + paramName + " message parameter does not have a valid date value. Expected format: " + DATE_FORMAT + ", received value: " + dateValue, e);
        }
        return result;
    }

    public static void validateDateRange(Date startDate, Date endDate) {
        if (startDate.compareTo(endDate) == 1) {
            throw new RuntimeException("Invalid Date Range: endDate has to be equal or greater than startDate.");
        }
    }
}

