/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.custom;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.devices.content.custom.DateUtils;
import com.ericsson.cms.search.IElasticSearchService;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.Date;

public class GetSumOfDurationByProviderIdAndDateMessageDispatcher
extends ContentMessageDispatcher {
    private static final String PROVIDER_ID_PARAM = "providerId";
    private static final String START_DATE_PARAM = "startDate";
    private static final String END_DATE_PARAM = "endDate";
    private static final String TOTAL_DURATION_VARIABLE = "totalDurationInSeconds";

    public GetSumOfDurationByProviderIdAndDateMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{PROVIDER_ID_PARAM, START_DATE_PARAM});
        String providerId = Util.getStringValueTrimmed((WorkflowMessage)request, (String)PROVIDER_ID_PARAM);
        String startDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)START_DATE_PARAM);
        String endDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)END_DATE_PARAM);
        Date startDate = DateUtils.validateAndGetDate(START_DATE_PARAM, startDateValue);
        Date endDate = null;
        if (endDateValue != null) {
            endDate = DateUtils.validateAndGetDate(END_DATE_PARAM, endDateValue);
            DateUtils.validateDateRange(startDate, endDate);
        }
        String totalDuration = this.getTotalDuration(providerId, startDate, endDate);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(TOTAL_DURATION_VARIABLE, totalDuration);
        return response;
    }

    public String getTotalDuration(String providerId, Date startDate, Date endDate) {
        try {
            IElasticSearchService service = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
            double duration = service.getTotalDuration(providerId, startDate, endDate);
            return String.format("%.0f", duration);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

