/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.custom;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.devices.content.custom.DateUtils;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.Date;

public class GetTitleCountByProviderIdAndDateMessageDispatcher
extends ContentMessageDispatcher {
    private static final String PROVIDER_ID_PARAM = "providerId";
    private static final String START_DATE_PARAM = "startDate";
    private static final String END_DATE_PARAM = "endDate";
    private static final String COUNT_VARIABLE = "count";

    public GetTitleCountByProviderIdAndDateMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{PROVIDER_ID_PARAM, START_DATE_PARAM});
        String providerId = Util.getStringValueTrimmed((WorkflowMessage)request, (String)PROVIDER_ID_PARAM);
        String startDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)START_DATE_PARAM);
        String endDateValue = Util.getStringValueTrimmed((WorkflowMessage)request, (String)END_DATE_PARAM);
        Date startDate = DateUtils.validateAndGetDate(START_DATE_PARAM, startDateValue);
        Date endDate = null;
        if (endDateValue != null) {
            endDate = DateUtils.validateAndGetDate(END_DATE_PARAM, endDateValue);
            DateUtils.validateDateRange(startDate, endDate);
        }
        Long count = this.getTitleCount(providerId, startDateValue, endDateValue);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(COUNT_VARIABLE, (Object)count);
        return response;
    }

    public long getTitleCount(String providerId, String startDate, String endDate) {
        ITitleSearchService service = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
        ExpList criteria = GetTitleCountByProviderIdAndDateMessageDispatcher.createCriteria(providerId, startDate, endDate);
        TitleFilter titleFilter = new TitleFilter((ExpNode)criteria);
        titleFilter.setCriteriaMode(CriteriaMode.MASTER);
        long count = service.getTitleCount(titleFilter, null);
        return count;
    }

    public static ExpList createCriteria(String providerId, String startDate, String endDate) {
        ExpList root = new ExpList();
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("/Fields/ProviderInfo/Identifier/Id");
        predicate.setFieldLeftSectionType("PACKAGE");
        predicate.setFieldTypeLhs(FieldType.ASSET);
        predicate.setDataType("string");
        predicate.setOperator(LogicalOperator.EQUAL);
        predicate.setValue(providerId);
        root.addItem((ExpNode)new ExpValue((Predicate)predicate));
        predicate = new PredicateRightValue();
        predicate.setFieldLeft("createDate");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("date");
        predicate.setOperator(LogicalOperator.GREATERTHANEQUAL);
        predicate.setValue(startDate);
        root.addItem((ExpNode)new ExpValue((Predicate)predicate));
        if (endDate != null) {
            predicate = new PredicateRightValue();
            predicate.setFieldLeft("createDate");
            predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
            predicate.setDataType("date");
            predicate.setOperator(LogicalOperator.LESSTHANEQUAL);
            predicate.setValue(endDate);
            root.addItem((ExpNode)new ExpValue((Predicate)predicate));
        }
        return root;
    }
}

