/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.ingest;

import com.ericsson.cms.devices.content.ingest.TitleIngestMessageDispatcher;
import com.ericsson.cms.search.FileSearchResult;
import com.ericsson.cms.search.IElasticSearchService;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;

public class GetMappingForContentMessageDispatcher
extends TitleIngestMessageDispatcher {
    protected static final String MATCH_TYPE = "matchType";
    protected static final String MATCH_COUNT = "matchCount";

    public GetMappingForContentMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{"assetPath", "providerId"});
        String assetPath = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"assetPath");
        String providerId = Util.getStringValueTrimmed((WorkflowMessage)request, (String)"providerId");
        try {
            IElasticSearchService service = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
            FileSearchResult result = service.fileSearch(assetPath, providerId);
            WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
            this.updateResponseParameters(response, result);
            return response;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void updateResponseParameters(WorkflowMessage response, FileSearchResult searchResult) {
        String matchType = null;
        String strTitleId = "";
        String strAssetId = "";
        if (searchResult.count == 0L) {
            matchType = "NO_MATCH";
        } else if (searchResult.count == 1L) {
            matchType = "UNIQUE_MATCH";
            strTitleId = "" + searchResult.titleId;
            strAssetId = "" + searchResult.assetId;
        } else {
            matchType = "DUPLICATE_MATCHES";
        }
        response.putValue(MATCH_TYPE, matchType);
        response.putValue(MATCH_COUNT, "" + searchResult.count);
        response.putValue("titleId", strTitleId);
        response.putValue("assetId", strAssetId);
    }
}

