/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.manualtask;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.text.MessageFormat;

public abstract class AbstractGenerateURLMessageDispatcher
extends ContentMessageDispatcher {
    protected static final String DEFAULT_URL_RESPONSE_PARAMETER = "url";
    protected static final String DEFAULT_URL_CONFIGURATION_PARAMETER = "url";

    public AbstractGenerateURLMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        this.validateRequiredParameters(request);
        String urlParameter = this.getURLResponseParameterName(request);
        String url = this.generateURL(request);
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        response.putValue(urlParameter, url);
        this.updateResponseParameters(response, request);
        return response;
    }

    protected abstract void validateRequiredParameters(WorkflowMessage var1);

    protected String getURLResponseParameterName(WorkflowMessage request) {
        return "url";
    }

    protected String generateURL(WorkflowMessage request) {
        String urlForFormatting = this.getURLForFormatting(request);
        Object[] arguments = this.getArgumentsForFormatting(request);
        return MessageFormat.format(urlForFormatting, arguments);
    }

    protected String getURLForFormatting(WorkflowMessage request) {
        return this.getPropertyValue("url");
    }

    protected abstract Object[] getArgumentsForFormatting(WorkflowMessage var1);

    protected void updateResponseParameters(WorkflowMessage response, WorkflowMessage request) {
    }

    protected void validateLongParameter(String val, String parm) {
        Long longVal = Long.valueOf(val.trim());
        if (longVal < 0L) {
            throw new RuntimeException("Invalid value for Parameter " + parm);
        }
    }
}

