/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.ericsson.cms.devices.content.metadata.AssetUtils;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class AddAssetMessageDispatcher
extends ContentMessageDispatcher {
    private static final String TITLE_ID = "titleId";
    private static final String ASSET_TYPE = "assetType";
    private static final String PARENT_ASSET_ID = "parentAssetId";
    private static final String ASSET_ID = "assetId";

    public AddAssetMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage message) {
        WorkflowMessage workflowMessage = message;
        return (WorkflowMessage)AddAssetMessageDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), AddAssetMessageDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(AddAssetMessageDispatcher this_, WorkflowMessage message) {
        List titleAssets;
        String[] parts;
        Asset parentAsset;
        String assetType;
        try {
            Util.validateRequired((WorkflowMessage)message, (String[])new String[]{TITLE_ID, ASSET_TYPE});
        }
        catch (Exception e) {
            throw new RuntimeException("One or more required parameters are missing.");
        }
        Long titleId = null;
        Long parentAssetId = null;
        try {
            titleId = Util.getLongValue((WorkflowMessage)message, (String)TITLE_ID);
            if (titleId == null) {
                throw new RuntimeException("Title Id are required. Only numeric values are allowed.");
            }
            assetType = Util.getStringValueTrimmed((WorkflowMessage)message, (String)ASSET_TYPE);
            String fileType = Item.ItemType.FILE.name();
            if (fileType.equals(assetType)) {
                throw new RuntimeException(fileType + " asset type is not supported.");
            }
            String assetIdStr = Util.getStringValueTrimmed((WorkflowMessage)message, (String)PARENT_ASSET_ID);
            if (assetIdStr != null && assetIdStr.length() > 0) {
                parentAssetId = Util.getLongValue((WorkflowMessage)message, (String)PARENT_ASSET_ID);
            }
        }
        catch (NumberFormatException ne) {
            throw new RuntimeException("Invald input. Only numeric values are allowed for Title Id, Asset Id. Asset Id is optional and can be null, but if present must be numeric.");
        }
        Title title = this_.getTitleForUpdate(titleId);
        if (parentAssetId != null) {
            parentAsset = AssetUtils.getAsset(title, parentAssetId);
            if (parentAsset == null) {
                throw new RuntimeException("No asset found with Asset ID = " + parentAssetId);
            }
        } else {
            parentAsset = title.getAsset();
        }
        if ((assetType = (parts = assetType.split("/"))[parts.length - 1]).equalsIgnoreCase(Item.ItemType.TITLE.name()) && !(titleAssets = parentAsset.getAllAssetsOfType(Item.ItemType.TITLE.name())).isEmpty()) {
            throw new RuntimeException(" You cannot have more than one asset of type " + assetType);
        }
        Asset newAsset = AssetUtils.createAsset(parentAsset, assetType);
        if (newAsset == null) {
            throw new RuntimeException(parentAsset.getAssetType() + " cannot have a child asset of type " + assetType);
        }
        parentAsset.addChild(newAsset);
        Asset.setPaths((Asset)title.getAsset(), null);
        try {
            this_.getContentClassService().applyContentClassMetadataForIngest(title);
        }
        catch (ContentClassPersistenceException e) {
            throw new RuntimeException("Error applying content class, error: " + e.getLocalizedMessage());
        }
        ISavedTitle savedTitle = null;
        try {
            savedTitle = this_.getTitleManager().save(title, this_.getActionSource(message));
        }
        catch (TitleValidationException e) {
            String msg = "Failed to save title after adding asset, error: " + e.getLocalizedMessage();
            throw new RuntimeException(msg);
        }
        Title updatedTitle = savedTitle.getTitle();
        Long assetId = AssetUtils.getMaxAssetId(updatedTitle);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(ASSET_ID, (Object)assetId);
        return response;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(AddAssetMessageDispatcher this_, WorkflowMessage message, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return AddAssetMessageDispatcher.generateResponse_aroundBody0(this_, message);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = AddAssetMessageDispatcher.generateResponse_aroundBody0(this_, message);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

