/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.metadata;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.List;

public class AssetUtils {
    public static Asset getAsset(Title title, Long assetId) {
        Asset rootAsset = title.getAsset();
        List assets = rootAsset.getAllAssets(false);
        for (Asset a : assets) {
            if (a.getId() != assetId.longValue()) continue;
            return a;
        }
        return null;
    }

    public static Asset createAsset(Asset parentAsset, String assetType) {
        Group childAsset = null;
        String parentAssetType = parentAsset.getAssetType();
        if (assetType.equalsIgnoreCase(Group.GroupType.MOVIE.name()) || assetType.equalsIgnoreCase(Group.GroupType.PREVIEW.name()) || assetType.equalsIgnoreCase(Group.GroupType.SEASON.name())) {
            if (parentAssetType.equalsIgnoreCase(Group.GroupType.PACKAGE.name()) || parentAssetType.equalsIgnoreCase(Group.GroupType.SERIES.name())) {
                childAsset = new Group();
                childAsset.setType(assetType.toUpperCase());
            }
        } else if (assetType.equalsIgnoreCase(Item.ItemType.TITLE.name()) || assetType.equalsIgnoreCase(Item.ItemType.TRICK.name()) || assetType.equalsIgnoreCase(Item.ItemType.BARKER.name()) || assetType.equalsIgnoreCase(Item.ItemType.ENCRYPTED.name()) || assetType.equalsIgnoreCase(Item.ItemType.MOVIESEGMENTGROUP.name()) || assetType.equalsIgnoreCase(Item.ItemType.PREVIEWSEGMENTGROUP.name()) || assetType.equalsIgnoreCase(Item.ItemType.DISPLAY.name()) || assetType.equalsIgnoreCase(Item.ItemType.GAME.name()) || assetType.equalsIgnoreCase(Item.ItemType.AUDIO.name())) {
            if (parentAssetType.equalsIgnoreCase(Group.GroupType.PACKAGE.name()) || parentAssetType.equalsIgnoreCase(Group.GroupType.SERIES.name())) {
                childAsset = new Item();
                ((Item)childAsset).setType(assetType.toUpperCase());
            }
        } else if (assetType.equalsIgnoreCase(Item.ItemType.POSTER.name()) || assetType.equalsIgnoreCase(Item.ItemType.BOXCOVER.name())) {
            if (parentAssetType.equalsIgnoreCase(Group.GroupType.PACKAGE.name()) || parentAssetType.equalsIgnoreCase(Group.GroupType.SEASON.name()) || parentAssetType.equalsIgnoreCase(Group.GroupType.SERIES.name())) {
                childAsset = new Item();
                ((Item)childAsset).setType(assetType.toUpperCase());
            }
        } else if (assetType.equalsIgnoreCase(Item.ItemType.LOGICALCLIP.name()) && (parentAssetType.equalsIgnoreCase(Group.GroupType.PREVIEW.name()) || parentAssetType.equalsIgnoreCase(Group.GroupType.MOVIE.name()))) {
            childAsset = new Item();
            ((Item)childAsset).setType(assetType.toUpperCase());
        }
        return childAsset;
    }

    public static Long getMaxAssetId(Title title) {
        Asset rootAsset = title.getAsset();
        List assets = rootAsset.getAllAssets(false);
        long maxId = rootAsset.getId();
        for (Asset a : assets) {
            if (a.getId() <= maxId) continue;
            maxId = a.getId();
        }
        return maxId;
    }

    public static String getFieldValue(Asset asset, String fieldXPath) {
        Field field = AssetUtils.getFirstField(asset, fieldXPath);
        String value = field != null ? field.getValue() : null;
        return value != null ? value : "";
    }

    public static Field getFirstField(Asset asset, String fieldXPath) {
        for (Field field : asset.getFields()) {
            if (!fieldXPath.equals(field.getTtvXPath()) || !AssetUtils.isFirstField(field)) continue;
            return field;
        }
        return null;
    }

    public static boolean isFirstField(Field field) {
        List indices = field.getIndices();
        Integer expectedIndex = new Integer(1);
        for (Integer index : indices) {
            if (index == null || index.equals(expectedIndex)) continue;
            return false;
        }
        return true;
    }
}

