/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.titlelist;

import com.ericsson.cms.devices.content.titlelist.TitleListMessageDispatcher;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class GetTitleIdListFromTitleListDispatcher
extends TitleListMessageDispatcher {
    private static final Logger logger = Logger.getLogger(GetTitleIdListFromTitleListDispatcher.class);
    private static final String TITLELIST_ID = "titleListId";
    private static final String TITLE_ID_LIST = "titleIdList";

    public GetTitleIdListFromTitleListDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    @Transactional
    protected WorkflowMessage generateResponse(WorkflowMessage request) {
        WorkflowMessage workflowMessage = request;
        return (WorkflowMessage)GetTitleIdListFromTitleListDispatcher.generateResponse_aroundBody1$advice(this, workflowMessage, TransactionEnforcer.aspectOf(), GetTitleIdListFromTitleListDispatcher.class.getDeclaredMethod("generateResponse", WorkflowMessage.class).getAnnotation(Transactional.class), null);
    }

    private static final /* synthetic */ WorkflowMessage generateResponse_aroundBody0(GetTitleIdListFromTitleListDispatcher this_, WorkflowMessage request) {
        Util.validateRequired((WorkflowMessage)request, (String[])new String[]{TITLELIST_ID});
        long titleListId = Util.getLongValue((WorkflowMessage)request, (String)TITLELIST_ID);
        IAssetListManager assetListManager = this_.getAssetListManagerService();
        AssetList assetList = assetListManager.get(titleListId);
        logger.debug((Object)("Generating title id list for title list id:" + titleListId));
        HashSet<Long> titleIdSet = new HashSet<Long>();
        StringBuilder titleIdBuilder = new StringBuilder();
        boolean appendComma = false;
        for (AssetListAssetMap assetMap : assetList.getAssetsMap()) {
            Title title = assetMap.getTitle();
            Long titleId = title.getId();
            if (titleIdSet.contains(titleId)) continue;
            titleIdSet.add(titleId);
            if (appendComma) {
                titleIdBuilder.append(',');
            }
            titleIdBuilder.append(titleId);
            appendComma = true;
        }
        logger.debug((Object)("Title id list:" + titleIdBuilder.toString()));
        WorkflowMessage message = WorkflowMessageFactory.createAckMessage((WorkflowMessage)request);
        message.putValue(TITLE_ID_LIST, titleIdBuilder.toString());
        return message;
    }

    private static final /* synthetic */ Object generateResponse_aroundBody1$advice(GetTitleIdListFromTitleListDispatcher this_, WorkflowMessage request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return GetTitleIdListFromTitleListDispatcher.generateResponse_aroundBody0(this_, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            WorkflowMessage object = GetTitleIdListFromTitleListDispatcher.generateResponse_aroundBody0(this_, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

